/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.GdeInterface;
import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.GenericImageLoader;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.Serializable;

public class ExtDisplayLink
extends Component
implements MouseListener,
MouseMotionListener,
Serializable {
    static final long serialVersionUID = -6188563061754647932L;
    private static final String NO_LABEL = "";
    private transient GdeInterface applet;
    private String label = "?";
    private String link = "";
    private String sBitmap = "Button.gif";

    public ExtDisplayLink() {
        this.InitWrapper();
        this.addMouseListener(this);
        super.setForeground(Color.blue);
        super.setFont(new Font("SansSerif", 0, 14));
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public void setLink(String string) {
        this.link = string.trim();
        this.applet = null;
        this.repaint();
    }

    public String getLink() {
        return this.link;
    }

    public void setLabel(String string) {
        this.label = string.length() > 0 ? string : NO_LABEL;
        this.repaint();
    }

    public String getLabel() {
        return this.label;
    }

    public void setBitmap(String string) {
        this.sBitmap = string;
        this.doLayout();
        this.repaint();
    }

    public String getBitmap() {
        return this.sBitmap;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 30;
        dimension.height += 20;
        return dimension;
    }

    public Dimension getMinimumSize() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.label);
        int n2 = fontMetrics.getHeight();
        return new Dimension(n, n2);
    }

    public void paint(Graphics graphics) {
        GenericImageLoader genericImageLoader = new GenericImageLoader();
        Dimension dimension = this.getSize();
        graphics.drawImage(genericImageLoader.iDownloadImage(this.getBitmap()), 0, 0, dimension.width, dimension.height, this);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        int n = fontMetrics.stringWidth(this.label);
        int n2 = (dimension.width - n) / 2;
        int n3 = (dimension.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
        graphics.setFont(this.getFont());
        graphics.setColor(this.getForeground());
        graphics.drawString(this.label, n2, n3);
        if (this.link.length() > 0) {
            graphics.drawLine(n2, n3, n2 + n, n3);
        }
        if (Wrapper.BORDER_WIDTH != 0) {
            this.InitWrapper();
        }
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 0;
        Wrapper.BORDER_WIDTH_X2 = 0;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.applet == null && this.link.length() > 0) {
            Container container = this.getParent();
            while (container != null && !(container instanceof GdeInterface)) {
                container = ((Component)container).getParent();
            }
            this.applet = (GdeInterface)container;
            this.removeMouseMotionListener(this);
            this.addMouseMotionListener(this);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.applet != null && !this.applet.isEditMode()) {
            this.setCursor(Cursor.getPredefinedCursor(12));
            this.getParent().setCursor(Cursor.getPredefinedCursor(12));
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.applet != null && !this.applet.isEditMode()) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.getParent().setCursor(Cursor.getPredefinedCursor(3));
            if (this.link.indexOf(47) >= 0 || this.link.indexOf(46) >= 0) {
                this.applet.showDocument(this.link, mouseEvent.isShiftDown());
            } else {
                this.applet.loadDisplay(this.link);
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }
}

