/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.factorycast.MonitorInt;
import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.factorycast.MonitorString;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.SetNumber;
import com.schneiderautomation.factorycast.SetRef;
import com.schneiderautomation.factorycast.SetString;
import com.schneiderautomation.gde.GdeDisplayList;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.MonitorSupport;
import com.schneiderautomation.gde.WriteSupport;
import com.schneiderautomation.vars.VarInfo;
import com.schneiderautomation.widgets.ExtLiveTextGui;
import com.schneiderautomation.widgets.InputActionListener;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;

public class ExtLiveText
extends ExtLiveTextGui
implements GraphicalObject,
PropertyChangeListener,
InputActionListener,
Serializable {
    static final long serialVersionUID = 1624606043276780922L;
    private short m_maxLength = (short)16;
    private boolean m_fSwapBytes = false;
    private boolean m_fCentered = true;
    private MonitorRef m_monitor;
    private SetRef m_setter;
    private MonitorSupport m_readSupport;
    private WriteSupport m_writeSupport;
    private transient boolean m_fEnabled;
    private transient GdeDisplayList m_gdtFiles;
    private transient ServerChangeEvent m_commServer;
    private transient String m_lastValue = "";

    public ExtLiveText() {
        this.addInputActionListener(this);
        this.setAddress("");
    }

    public void enableUserInput() {
        this.m_fEnabled = true;
        this.setEnabled(this.m_fEnabled);
    }

    public void disableUserInput() {
        this.m_fEnabled = false;
        this.setEnabled(this.m_fEnabled);
    }

    public String getStatus() {
        return this.m_readSupport.getStatus();
    }

    public boolean isErrorStatus() {
        return this.m_readSupport.isErrorStatus();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            Object object = propertyChangeEvent.getNewValue();
            this.m_lastValue = this.m_monitor instanceof MonitorInt ? ((Number)object).toString() : (String)object;
            this.setValue(this.m_lastValue);
        } else if (propertyChangeEvent.getPropertyName().equals("values")) {
            short[] sArray = ((MonitorInt)this.m_monitor).getValues();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < sArray.length; ++i) {
                byte by;
                byte by2;
                if (this.m_fSwapBytes) {
                    by2 = (byte)sArray[i];
                    by = (byte)(sArray[i] >> 8);
                } else {
                    by2 = (byte)(sArray[i] >> 8);
                    by = (byte)sArray[i];
                }
                if (by2 == 0 || stringBuffer.length() >= this.m_maxLength) break;
                stringBuffer.append((char)(by2 & 0xFF));
                if (by == 0 || stringBuffer.length() >= this.m_maxLength) break;
                stringBuffer.append((char)(by & 0xFF));
            }
            this.m_lastValue = stringBuffer.toString();
            this.setValue(this.m_lastValue);
        }
    }

    public short getMaxLength() {
        return this.m_maxLength;
    }

    public void setMaxLength(short s) {
        this.m_maxLength = (short)Math.max(Math.min(s, 1024), 1);
        short s2 = this.m_monitor instanceof MonitorInt ? (short)((this.m_maxLength + 1) / 2) : this.m_maxLength;
        this.m_monitor.setQuantity(s2);
        this.setValue(this.getValue());
    }

    public String getValue() {
        return this.svalue != null ? this.svalue : new String();
    }

    public void setValue(String string) {
        if (string.length() > this.m_maxLength) {
            string = string.substring(0, this.m_maxLength);
        }
        this.svalue = string;
        this.repaint();
    }

    public boolean isSwapBytesEnabled() {
        return this.m_fSwapBytes;
    }

    public void setSwapBytesEnabled(boolean bl) {
        this.m_fSwapBytes = bl;
    }

    public boolean isCentered() {
        return this.m_fCentered;
    }

    public void setCentered(boolean bl) {
        this.m_fCentered = bl;
        this.repaint();
    }

    public String getAddress() {
        if (this.m_monitor != null) {
            return this.m_monitor.getAddress();
        }
        return "";
    }

    public void setAddress(String string) {
        short s;
        if (this.m_monitor != null) {
            this.m_monitor.deregister();
            this.m_monitor.removePropertyChangeListener((PropertyChangeListener)this);
        }
        try {
            VarInfo varInfo = this.m_commServer.getVarLookup().get(string);
            s = varInfo.getDataType() == 9 ? varInfo.getMaxStrLen() : (short)0;
        }
        catch (Exception exception) {
            s = 0;
        }
        if (s == 0) {
            this.m_monitor = new MonitorInt();
            this.m_setter = new SetNumber();
        } else {
            this.m_monitor = new MonitorString();
            this.m_setter = new SetString();
            this.setMaxLength(s);
        }
        this.serverChanged(this.m_commServer);
        this.m_monitor.addPropertyChangeListener((PropertyChangeListener)this);
        this.m_monitor.setAddress(string);
        this.m_monitor.setQuantity(this.getMaxLength());
        this.m_setter.setAddress(this.m_monitor.getAddress());
        this.m_readSupport = new MonitorSupport(this.m_monitor, (GraphicalObject)this);
        this.m_writeSupport = new WriteSupport(this.m_setter, (GraphicalObject)this);
    }

    public void serverChanged(ServerChangeEvent serverChangeEvent) {
        if (serverChangeEvent != null) {
            this.m_commServer = serverChangeEvent;
            if (this.m_monitor != null) {
                this.m_setter.serverChanged(serverChangeEvent);
                this.m_monitor.serverChanged(serverChangeEvent);
                if (serverChangeEvent.getCommBean() != null) {
                    this.m_setter.enableAccessChecking(serverChangeEvent.getVarLookup());
                }
            }
        }
    }

    public void inputActionPerformed(ActionEvent actionEvent) {
        String string = this.input.getText();
        if (this.m_monitor instanceof MonitorString) {
            ((SetString)this.m_setter).setQuantity(this.m_maxLength);
            ((SetString)this.m_setter).setValue(string);
        } else {
            byte[] byArray;
            try {
                byArray = string.getBytes("ASCII");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.m_writeSupport.setStatus(true, unsupportedEncodingException.getMessage());
                return;
            }
            int n = Math.min(this.m_maxLength, byArray.length);
            Number[] numberArray = new Number[(this.m_maxLength + 1) / 2];
            int n2 = 0;
            int n3 = 0;
            while (n3 < this.m_maxLength) {
                String string2;
                if (n3 < n) {
                    String string3 = Integer.toHexString(byArray[n3]);
                    String string4 = n3 < n - 1 ? Integer.toHexString(byArray[n3 + 1]) : "00";
                    string2 = this.m_fSwapBytes ? string4 + string3 : string3 + string4;
                } else {
                    string2 = "0000";
                }
                numberArray[n2] = new Integer(Integer.parseInt(string2, 16));
                n3 += 2;
                ++n2;
            }
            ((SetNumber)this.m_setter).setValues(numberArray);
        }
        try {
            this.m_setter.sendValues();
        }
        catch (Exception exception) {
            this.m_writeSupport.setStatus(true, exception.getMessage());
            this.setValue(this.m_lastValue);
        }
    }
}

