/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.BeanBox;
import com.schneiderautomation.gde.GdeInterface;
import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.GenericImageLoader;
import com.schneiderautomation.widgets.HLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.io.Serializable;

public class ExtStatic
extends Component
implements Serializable {
    static final long serialVersionUID = -6188563061754647932L;
    private String sBitmap = "GreenSquare01.png";
    private HLabel label = new HLabel();
    private Border border = new Border();
    private Font font = new Font("SansSerif", 0, 12);
    private Rectangle box = new Rectangle();
    private int index = -1;
    private String paths = null;
    private String sImage;
    private transient GdeInterface applet;
    private transient Image ImageFtp;

    public ExtStatic() {
        this.InitWrapper();
        super.setForeground(Color.blue);
        super.setFont(new Font("SansSerif", 0, 14));
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.repaint();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.repaint();
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setBitmap(String string) {
        this.index = string.indexOf(":");
        if (this.index != -1) {
            this.paths = string.substring(this.index + 1, string.length()).trim();
            this.setPath(this.paths);
        }
        this.sBitmap = string;
        this.doLayout();
        this.repaint();
    }

    public String setimage(String string) {
        this.index = string.indexOf(":");
        this.sImage = string = string.substring(0, this.index).trim();
        return this.sImage;
    }

    public String getBitmap() {
        return this.sBitmap;
    }

    private String getPath() {
        return this.paths;
    }

    private void setPath(String string) {
        this.paths = string;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width = 40;
        dimension.height = 40;
        return dimension;
    }

    public Dimension getMinimumSize() {
        int n = 10;
        int n2 = 10;
        return new Dimension(n, n2);
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.label.getMinimumSize().height;
        int n3 = dimension.height - n2;
        int n4 = n / 2;
        this.box = new Rectangle(n4, n4, dimension.width, n3);
        this.label.setBounds(new Rectangle(n4, n4 + n3, dimension.width, n2));
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 0;
        Wrapper.BORDER_WIDTH_X2 = 0;
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        graphics.fillRect(this.box.x, this.box.y, this.box.width, this.box.height);
        GenericImageLoader genericImageLoader = new GenericImageLoader();
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        int n = this.box.x + this.box.width / 2;
        if (n < this.box.x) {
            n = this.box.x;
        }
        int n2 = this.box.y + (this.box.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
        String string = this.getBitmap();
        if (this.index != -1) {
            this.ImageFtp = BeanBox.getBeanImage((String)this.setimage(string), (String)this.getPath());
            MediaTracker mediaTracker = new MediaTracker(this);
            mediaTracker.addImage(this.ImageFtp, 0);
            try {
                mediaTracker.waitForAll();
            }
            catch (InterruptedException interruptedException) {
                System.out.print("error downloading class");
            }
            graphics.drawImage(this.ImageFtp, this.box.x, this.box.y, this.box.width, this.box.height, this);
        } else {
            graphics.drawImage(genericImageLoader.iDownloadImage(string), this.box.x, this.box.y, this.box.width, this.box.height, this);
        }
        this.label.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 0) {
            this.InitWrapper();
        }
    }
}

