/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.Bar;
import com.schneiderautomation.widgets.TScale;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

class HChart
implements Runnable,
Serializable {
    static final long serialVersionUID = 5378265025541520019L;
    static final Color[] defaultColors = new Color[]{Color.black, Color.red, Color.green, Color.blue, Color.orange, Color.lightGray};
    static final int MAX_PENS = defaultColors.length;
    static final int XGRID_WIDTH = 10;
    private transient Image chart;
    private transient Thread engine;
    private transient int nUpdate;
    private transient float[] values;
    private transient Integer[] lastValues;
    private Color[] penColors = new Color[MAX_PENS];
    private Object updateControl = new Integer(0);
    private float minimum = 0.0f;
    private float maximum = 100.0f;
    private int updateInterval = 1000;
    private int gridDivisions = 0;
    private Color background = Color.white;
    private Color gridColor = Color.lightGray;
    private Component parent;
    private TScale scale;
    private Rectangle box = new Rectangle();
    private Color foreground;

    HChart(Component component, TScale tScale) {
        this.parent = component;
        this.scale = tScale;
        System.arraycopy(defaultColors, 0, this.penColors, 0, this.penColors.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void start() {
        Object object = this.updateControl;
        synchronized (object) {
            if (this.engine == null) {
                this.engine = new Thread(this);
                this.engine.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stop() {
        Object object = this.updateControl;
        synchronized (object) {
            this.engine = null;
            this.updateControl.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Object object = this.updateControl;
        synchronized (object) {
            while (this.engine != null) {
                this.updateChart();
                try {
                    this.updateControl.wait(this.updateInterval);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    synchronized void paint(Graphics graphics) {
        if (this.chart == null) {
            this.updateChart();
        }
        if (this.chart != null) {
            graphics.drawImage(this.chart, this.box.x, this.box.y, null);
        }
    }

    void setBounds(Rectangle rectangle) {
        this.box = rectangle;
        this.reset(false);
    }

    synchronized void reset(boolean bl) {
        if (bl && this.lastValues != null) {
            for (int i = 0; i < this.lastValues.length; ++i) {
                this.lastValues[i] = null;
            }
        }
        this.chart = null;
        this.updateChart();
    }

    synchronized void setValue(int n, float f) {
        this.initValueArrays();
        this.values[n] = f;
        float f2 = (this.values[n] - this.minimum) / (this.maximum - this.minimum);
        int n2 = this.box.height - (int)(f2 * (float)this.box.height);
        if (this.lastValues[n] == null) {
            this.lastValues[n] = new Integer(n2);
        }
        if (this.chart != null) {
            Graphics graphics = this.chart.getGraphics();
            graphics.setColor(this.penColors[n]);
            graphics.drawLine(this.box.width - 1, this.lastValues[n], this.box.width - 1, n2);
            graphics.dispose();
        }
        this.lastValues[n] = new Integer(n2);
    }

    float getValue(int n) {
        this.initValueArrays();
        return this.values[n];
    }

    void setPenColor(int n, Color color) {
        this.penColors[n] = color;
        this.reset(true);
    }

    Color getPenColor(int n) {
        return this.penColors[n];
    }

    void setBackground(Color color) {
        this.background = color;
        this.reset(true);
    }

    Color getBackground() {
        return this.background;
    }

    void setGridColor(Color color) {
        this.gridColor = color;
        this.reset(true);
    }

    Color getGridColor() {
        return this.gridColor;
    }

    void setGridDivisions(int n) {
        this.gridDivisions = Math.min(Math.max(n, 0), 100);
        this.reset(true);
    }

    int getGridDivisions() {
        return this.gridDivisions;
    }

    void setUpdateInterval(int n) {
        this.updateInterval = Math.min(Math.max(n, 500), 120000);
        this.reset(true);
    }

    int getUpdateInterval() {
        return this.updateInterval;
    }

    void setMinimum(float f) {
        if ((f = Bar.limitFloat(f)) > this.maximum) {
            f = this.maximum;
        }
        this.minimum = f;
    }

    float getMinimum() {
        return this.minimum;
    }

    void setMaximum(float f) {
        if ((f = Bar.limitFloat(f)) < this.minimum) {
            f = this.minimum;
        }
        this.maximum = f;
    }

    float getMaximum() {
        return this.maximum;
    }

    private synchronized void updateChart() {
        int n;
        int n2;
        Graphics graphics;
        this.initValueArrays();
        if (this.chart == null) {
            try {
                this.chart = this.parent.createImage(this.box.width, this.box.height);
                if (this.chart == null) {
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
            this.nUpdate = 0;
            graphics = this.chart.getGraphics();
            graphics.setColor(this.background);
            graphics.fillRect(0, 0, this.box.width, this.box.height);
            if (this.gridDivisions > 0) {
                int n3 = this.box.width - 1;
                graphics.setColor(this.gridColor);
                for (n2 = 0; n2 < this.gridDivisions; ++n2) {
                    n = this.box.height * n2 / this.gridDivisions;
                    graphics.drawLine(0, n, n3, n);
                }
                while (n3 >= 0) {
                    graphics.drawLine(n3, 0, n3, this.box.height - 1);
                    n3 -= 10;
                }
            }
            graphics.dispose();
        }
        graphics = this.parent.getGraphics();
        if (this.chart != null) {
            Graphics graphics2 = this.chart.getGraphics();
            n2 = this.box.width - 1;
            graphics2.drawImage(this.chart, 0, 0, n2, this.box.height, 1, 0, this.box.width, this.box.height, null);
            if (this.gridDivisions > 0 && ++this.nUpdate % 10 == 0) {
                graphics2.setColor(this.gridColor);
                graphics2.drawLine(n2, 0, n2, this.box.height - 1);
            } else {
                graphics2.setColor(this.background);
                graphics2.drawLine(n2, 0, n2, this.box.height - 1);
                graphics2.setColor(this.gridColor);
                for (n = 0; n < this.gridDivisions; ++n) {
                    int n4 = this.box.height * n / this.gridDivisions;
                    graphics2.drawLine(n2, n4, n2, n4);
                }
            }
            for (n = 0; n < this.lastValues.length; ++n) {
                if (this.lastValues[n] == null) continue;
                graphics2.setColor(this.penColors[n]);
                graphics2.drawLine(n2, this.lastValues[n], n2, this.lastValues[n]);
            }
            graphics2.dispose();
            if (this.scale != null && graphics != null) {
                this.scale.updateTime(graphics);
            }
        }
        if (graphics != null) {
            this.paint(graphics);
            graphics.dispose();
        }
    }

    private final void initValueArrays() {
        if (this.values == null) {
            this.values = new float[MAX_PENS];
        }
        if (this.lastValues == null) {
            this.lastValues = new Integer[MAX_PENS];
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (this.penColors == null) {
                this.penColors = new Color[MAX_PENS];
                System.arraycopy(defaultColors, 0, this.penColors, 0, this.penColors.length);
                this.penColors[0] = this.foreground;
                this.updateControl = new Integer(0);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ClassNotFoundException reading HChart object: " + classNotFoundException.getMessage());
        }
    }
}

