/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;

class HLabel
implements Serializable {
    static final long serialVersionUID = -3911231404699806850L;
    private String text = "";
    private Color foreground = Color.black;
    private Font font = new Font("SansSerif", 0, 12);
    private Rectangle box = new Rectangle();

    HLabel() {
    }

    Dimension getMinimumSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.text.length() > 0) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            dimension.height = fontMetrics.getHeight();
            dimension.width = fontMetrics.stringWidth(this.text);
        }
        return dimension;
    }

    void setBounds(Rectangle rectangle) {
        this.box = rectangle;
    }

    void setText(String string) {
        this.text = string;
    }

    String getText() {
        return this.text;
    }

    void setForeground(Color color) {
        this.foreground = color;
    }

    Color getForeground() {
        return this.foreground;
    }

    void setFont(Font font) {
        this.font = font;
    }

    Font getFont() {
        return this.font;
    }

    void paint(Graphics graphics) {
        if (this.text.length() > 0) {
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            int n = fontMetrics.stringWidth(this.text);
            int n2 = fontMetrics.getAscent();
            int n3 = this.box.x + (this.box.width - n) / 2;
            int n4 = this.box.y + n2;
            graphics.setColor(this.foreground);
            graphics.setFont(this.font);
            graphics.drawString(this.text, n3, n4);
        }
    }
}

