/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.ListScale;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.Serializable;

class HList
extends ListScale
implements Serializable {
    static final long serialVersionUID = -2520407879696165933L;
    private static final int TIC_SIZE = 12;

    HList() {
    }

    Dimension getMinimumSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.visible) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            dimension.height = fontMetrics.getHeight() + 12;
            for (int i = 0; i < this.labels.length; ++i) {
                dimension.width += fontMetrics.stringWidth(this.labels[i]);
            }
        }
        return dimension;
    }

    void paint(Graphics graphics) {
        if (this.visible) {
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            graphics.setColor(this.foreground);
            graphics.setFont(this.font);
            int n = this.box.y + fontMetrics.getHeight();
            for (int i = 0; i < this.labels.length; ++i) {
                int n2 = this.box.x + this.box.width * i / (this.labels.length - 1);
                int n3 = fontMetrics.stringWidth(this.labels[i]);
                int n4 = n2 - n3 / 2;
                int n5 = n - fontMetrics.getDescent();
                graphics.drawString(this.labels[i], n4, n5);
                graphics.drawLine(n2, n, n2, n + 12);
            }
        }
    }
}

