/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.HList;
import com.schneiderautomation.widgets.ListScaleInterface;
import com.schneiderautomation.widgets.Selector;
import com.schneiderautomation.widgets.SelectorGui;
import com.schneiderautomation.widgets.SelectorInterface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;

public class HSelectorGui
extends SelectorGui
implements Serializable {
    static final long serialVersionUID = -6820146707537371302L;
    private HList scale = new HList();
    private Selector bar = new Selector(0);

    public HSelectorGui() {
        this.setBackground(Color.lightGray);
        this.add(this.bar);
        this.bar.addAdjustmentListener(this);
        this.InitWrapper();
    }

    protected ListScaleInterface getScale() {
        return this.scale;
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    protected SelectorInterface getSelector() {
        return this.bar;
    }

    public int getSelectedIndex() {
        return this.bar.getValue();
    }

    public void paint(Graphics graphics) {
        this.scale.paint(graphics);
        super.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.scale.getMinimumSize().height;
        int n3 = this.label.getMinimumSize().height;
        int n4 = dimension.height - (n2 + n3);
        int n5 = n / 2;
        int n6 = this.bar.getThumbLength(dimension.width, this.scale.getLabels().length);
        int n7 = dimension.width - 32 - n6;
        int n8 = n5 + 16 + n6 / 2;
        int n9 = n5;
        this.scale.setBounds(new Rectangle(n8, n9, n7, n2));
        this.bar.setBounds(new Rectangle(n5, n9 += n2, dimension.width, n4));
        this.label.setBounds(new Rectangle(n5, n9 += n4, dimension.width, n3));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 80;
        dimension.height += 6;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.scale.getMinimumSize();
        Dimension dimension2 = this.bar.getMinimumSize();
        Dimension dimension3 = this.label.getMinimumSize();
        Dimension dimension4 = this.border.getMinimumSize();
        int n = dimension.width;
        if (dimension2.width > n) {
            n = dimension2.width;
        }
        if (dimension3.width > n) {
            n = dimension3.width;
        }
        int n2 = dimension.height + dimension3.height + dimension2.height + dimension4.height;
        return new Dimension(n += dimension4.width, n2);
    }
}

