/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.factorycast.MonitorInt;
import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.MonitorSupport;
import com.schneiderautomation.gde.Wrapper;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

public class LiveText
extends Canvas
implements GraphicalObject,
PropertyChangeListener,
Serializable {
    static final long serialVersionUID = 1624606043276780922L;
    private transient String value;
    private short maxLength = 1;
    private boolean fSwapBytes = false;
    private boolean fCentered = true;
    private MonitorInt monitor = new MonitorInt();
    private MonitorSupport support = new MonitorSupport((MonitorRef)this.monitor, (GraphicalObject)this);

    public LiveText() {
        this.InitWrapper();
        this.setBackground(Color.white);
        this.setForeground(Color.black);
        this.setFont(new Font("SansSerif", 0, 12));
        this.monitor.addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    public Dimension getMinimumSize() {
        int n = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont()).getHeight();
        return new Dimension(30, n);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 70;
        return dimension;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.getFont());
        int n = this.fCentered ? (dimension.width - fontMetrics.stringWidth(this.getValue())) / 2 : 0;
        int n2 = (dimension.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
        graphics.setColor(this.getForeground());
        graphics.setFont(this.getFont());
        graphics.drawString(this.getValue(), n, n2);
        graphics.setColor(this.getBackground());
        graphics.draw3DRect(0, 0, dimension.width - 1, dimension.height - 1, true);
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    public void serverChanged(ServerChangeEvent serverChangeEvent) {
        this.monitor.serverChanged(serverChangeEvent);
    }

    public void enableUserInput() {
    }

    public void disableUserInput() {
    }

    public String getStatus() {
        return this.support.getStatus();
    }

    public boolean isErrorStatus() {
        return this.support.isErrorStatus();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("values")) {
            short[] sArray = this.monitor.getValues();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < sArray.length; ++i) {
                byte by;
                byte by2;
                if (this.fSwapBytes) {
                    by2 = (byte)sArray[i];
                    by = (byte)(sArray[i] >> 8);
                } else {
                    by2 = (byte)(sArray[i] >> 8);
                    by = (byte)sArray[i];
                }
                if (by2 == 0 || stringBuffer.length() >= this.maxLength) break;
                stringBuffer.append((char)(by2 & 0xFF));
                if (by == 0 || stringBuffer.length() >= this.maxLength) break;
                stringBuffer.append((char)(by & 0xFF));
            }
            this.setValue(stringBuffer.toString());
        }
    }

    public String getValue() {
        return this.value != null ? this.value : new String();
    }

    public void setValue(String string) {
        if (string.length() > this.maxLength) {
            string = string.substring(0, this.maxLength);
        }
        this.value = string;
        this.repaint();
    }

    public short getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(short s) {
        this.maxLength = (short)Math.max(Math.min(s, 1024), 1);
        this.monitor.setQuantity((short)((this.maxLength + 1) / 2));
        this.setValue(this.getValue());
    }

    public boolean isSwapBytesEnabled() {
        return this.fSwapBytes;
    }

    public void setSwapBytesEnabled(boolean bl) {
        this.fSwapBytes = bl;
    }

    public boolean isCentered() {
        return this.fCentered;
    }

    public void setCentered(boolean bl) {
        this.fCentered = bl;
        this.repaint();
    }

    public String getAddress() {
        return this.monitor.getAddress();
    }

    public void setAddress(String string) {
        this.monitor.setAddress(string);
    }
}

