/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.Scale;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.Serializable;

abstract class MScale
extends Scale
implements Serializable {
    static final long serialVersionUID = 2185545952183757927L;
    protected double cx;
    protected double cy;
    protected double outerRadius;
    protected double labelRadius;
    protected double ticRadius;
    protected double colorRadius;
    protected int degSweep = 160;
    protected int minRadius = 10;
    protected int dialBandWidth = 12;
    protected int bottomPad = 0;

    MScale() {
    }

    abstract int getLabelLength();

    abstract String getLabel(int var1);

    double getCenterX() {
        return this.cx;
    }

    double getCenterY() {
        return this.cy;
    }

    double getInnerRadius() {
        return this.colorRadius;
    }

    void setDegSweep(int n) {
        this.degSweep = Math.min(Math.max(n, 60), 300);
    }

    int getDegSweep() {
        return this.degSweep;
    }

    void setDialBandWidth(int n) {
        this.dialBandWidth = n;
    }

    int getDialBandWidth() {
        return this.dialBandWidth;
    }

    void setMinimumRadius(int n) {
        if (n < 0) {
            n = 0;
        }
        this.minRadius = n;
    }

    int getMinimumRadius() {
        return this.minRadius;
    }

    void setBottomPad(int n) {
        if (n < 0) {
            n = 0;
        }
        this.bottomPad = n;
    }

    int getBottomPad() {
        return this.bottomPad;
    }

    Rectangle getBounds() {
        return this.box;
    }

    void setBounds(Rectangle rectangle) {
        double d;
        double d2;
        this.box = rectangle;
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.height;
        int n4 = rectangle.width;
        int n5 = 0;
        int n6 = 0;
        if (this.majorTics > 0) {
            n6 = this.getLabelLength();
            n5 = this.majorTicSize;
        } else if (this.minorTics > 0) {
            n5 = this.majorTicSize;
        }
        n3 -= this.bottomPad;
        double d3 = (double)this.degSweep * Math.PI / 180.0;
        double d4 = (Math.PI - d3) / 2.0;
        if (d4 <= 0.0) {
            d2 = (double)n4 / 2.0;
        } else {
            d2 = (double)n4 / (2.0 * Math.cos(d4));
            d = n6 + n5 + this.dialBandWidth;
            n3 = (int)((double)n3 - d * Math.sin(d4));
        }
        d = (double)n3 / (1.0 - Math.sin(d4));
        this.outerRadius = d < d2 ? d : d2;
        this.labelRadius = this.outerRadius - (double)n6;
        this.colorRadius = this.labelRadius - (double)n5;
        this.ticRadius = this.labelRadius;
        if (n5 > 0) {
            this.ticRadius -= (double)(this.majorTicSize - this.minorTicSize);
        }
        this.cx = (double)n + (double)n4 / 2.0;
        this.cy = (double)n2 + this.outerRadius;
    }

    Dimension getMinimumSize() {
        double d;
        double d2;
        int n = 0;
        int n2 = 0;
        if (this.majorTics > 0) {
            n2 = this.getLabelLength();
            n = this.majorTicSize;
        } else if (this.minorTics > 0) {
            n = this.majorTicSize;
        }
        int n3 = this.minRadius + n2 + n + this.dialBandWidth;
        double d3 = (double)this.degSweep * Math.PI / 180.0;
        double d4 = (Math.PI - d3) / 2.0;
        if (d4 < 0.0) {
            d2 = (double)n3 - (double)n3 * Math.sin(d4);
            d = (double)n3 * 2.0;
        } else {
            d2 = (double)n3 - (double)this.minRadius * Math.sin(d4);
            d = (double)n3 * Math.cos(d4) * 2.0;
        }
        int n4 = (int)(d2 + 0.5);
        int n5 = (int)(d + 0.5);
        return new Dimension(n5, n4 += this.bottomPad);
    }

    void paint(Graphics graphics) {
        if (this.majorTics > 0 || this.minorTics > 0) {
            Shape shape = graphics.getClip();
            graphics.setClip(this.box);
            this.drawRadials(graphics);
            graphics.setClip(shape);
        }
    }

    private void drawRadials(Graphics graphics) {
        double d;
        int n;
        double d2 = (double)this.degSweep * Math.PI / 180.0;
        double d3 = (Math.PI - d2) / 2.0;
        if (this.minorTics > 0) {
            graphics.setColor(this.foreground);
            for (n = 0; n <= this.minorTics; ++n) {
                d = d3 + d2 * ((double)n / (double)this.minorTics);
                this.drawMinorRadial(graphics, d);
            }
        }
        if (this.majorTics > 0) {
            graphics.setColor(this.foreground);
            for (n = 0; n <= this.majorTics; ++n) {
                d = d3 + d2 * ((double)n / (double)this.majorTics);
                this.drawMajorRadial(graphics, d, this.getLabel(n));
            }
        }
    }

    private void drawMinorRadial(Graphics graphics, double d) {
        int n = (int)(this.cx + this.colorRadius * Math.cos(d) + 0.5);
        int n2 = (int)(this.cy - this.colorRadius * Math.sin(d) + 0.5);
        int n3 = (int)(this.cx + (this.ticRadius - 1.0) * Math.cos(d) + 0.5);
        int n4 = (int)(this.cy - (this.ticRadius - 1.0) * Math.sin(d) + 0.5);
        graphics.drawLine(n, n2, n3, n4);
    }

    private void drawMajorRadial(Graphics graphics, double d, String string) {
        int n = (int)(this.cx + this.colorRadius * Math.cos(d) + 0.5);
        int n2 = (int)(this.cy - this.colorRadius * Math.sin(d) + 0.5);
        int n3 = (int)(this.cx + (this.labelRadius - 1.0) * Math.cos(d) + 0.5);
        int n4 = (int)(this.cy - (this.labelRadius - 1.0) * Math.sin(d) + 0.5);
        graphics.drawLine(n, n2, n3, n4);
        double d2 = (this.outerRadius + this.labelRadius) / 2.0;
        int n5 = (int)(this.cx + d2 * Math.cos(d) + 0.5);
        int n6 = (int)(this.cy - d2 * Math.sin(d) + 0.5);
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        int n7 = fontMetrics.stringWidth(string);
        n5 -= n7 / 2;
        n6 += fontMetrics.getAscent() / 2;
        if (d > -1.5707963267948966 && d < 1.5707963267948966) {
            if (n5 + n7 > this.box.x + this.box.width) {
                n5 = this.box.x + this.box.width - n7;
            }
        } else if (n5 < this.box.x) {
            n5 = this.box.x;
        }
        if (n6 > this.box.y + this.box.height - 1) {
            n6 = this.box.y + this.box.height - 1;
        }
        graphics.setFont(this.font);
        graphics.drawString(string, n5, n6);
    }
}

