/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.HLabel;
import com.schneiderautomation.widgets.IndicatorLight;
import com.schneiderautomation.widgets.PushButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Panel;
import java.awt.Rectangle;
import java.io.Serializable;

public class MotorControl
extends Panel
implements GraphicalObject,
Serializable {
    static final long serialVersionUID = 1780191957457512708L;
    private Border border = new Border();
    private HLabel label = new HLabel();
    private Panel control = new Panel();
    private IndicatorLight light = new IndicatorLight();
    private PushButton topBtn = new PushButton();
    private PushButton btmBtn = new PushButton();

    public MotorControl() {
        this.InitWrapper();
        this.light.setBorderWidth(0);
        this.topBtn.setBorderWidth(0);
        this.btmBtn.setBorderWidth(0);
        this.setBackground(Color.lightGray);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.control.setLayout(new GridBagLayout());
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.control.add((Component)this.light, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.control.add((Component)this.topBtn, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets.top = 0;
        this.control.add((Component)this.btmBtn, gridBagConstraints);
        this.setLayout(null);
        this.add(this.control);
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    public void serverChanged(ServerChangeEvent serverChangeEvent) {
        this.light.serverChanged(serverChangeEvent);
        this.topBtn.serverChanged(serverChangeEvent);
        this.btmBtn.serverChanged(serverChangeEvent);
    }

    public void enableUserInput() {
        this.topBtn.enableUserInput();
        this.btmBtn.enableUserInput();
    }

    public void disableUserInput() {
        this.topBtn.disableUserInput();
        this.btmBtn.disableUserInput();
    }

    public String getStatus() {
        if (this.topBtn.isErrorStatus()) {
            return this.topBtn.getStatus();
        }
        if (this.btmBtn.isErrorStatus()) {
            return this.btmBtn.getStatus();
        }
        return this.light.getStatus();
    }

    public boolean isErrorStatus() {
        return this.light.isErrorStatus() || this.topBtn.isErrorStatus() || this.btmBtn.isErrorStatus();
    }

    public void paint(Graphics graphics) {
        this.label.paint(graphics);
        this.border.paint(graphics);
        super.paint(graphics);
        this.control.repaint();
        this.light.repaint();
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void setName(String string) {
        super.setName(string);
        this.light.setName(string);
        this.topBtn.setName(string);
        this.btmBtn.setName(string);
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.control.setBackground(color);
        this.light.setBackground(color);
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public IndicatorLight getIndicator() {
        return this.light;
    }

    public PushButton getTopButton() {
        return this.topBtn;
    }

    public PushButton getBottomButton() {
        return this.btmBtn;
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n = this.border.getMinimumSize().height;
        dimension.width -= n;
        dimension.height -= n;
        int n2 = this.label.getMinimumSize().height;
        int n3 = dimension.height - n2;
        int n4 = n / 2;
        Rectangle rectangle = new Rectangle(n4, n4, dimension.width, n3);
        this.control.setBounds(rectangle);
        this.control.doLayout();
        rectangle.y += n3;
        rectangle.height = n2;
        this.label.setBounds(rectangle);
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.control.getMinimumSize();
        Dimension dimension2 = this.label.getMinimumSize();
        Dimension dimension3 = this.border.getMinimumSize();
        int n = dimension2.width;
        if (dimension.width > n) {
            n = dimension.width;
        }
        int n2 = dimension.height + dimension2.height + dimension3.height;
        return new Dimension(n += dimension3.width, n2);
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 50;
        dimension.height += 30;
        return dimension;
    }
}

