/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.MonitorNumber;
import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.ServerChangeListener;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.MonitorSupport;
import com.schneiderautomation.widgets.Chart;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;

class Pen
implements PropertyChangeListener,
ServerChangeListener,
Serializable {
    static final long serialVersionUID = 652041064419728288L;
    private transient float value;
    private int index;
    private Chart chart;
    private MonitorNumber monitor;
    private MonitorSupport support;
    private float minValue;
    private float maxValue;

    Pen(int n, Chart chart) {
        this.index = n;
        this.chart = chart;
        this.monitor = new MonitorNumber();
        this.support = new MonitorSupport((MonitorRef)this.monitor, (GraphicalObject)chart);
        this.monitor.addPropertyChangeListener((PropertyChangeListener)this);
        this.minValue = chart.getMinimum();
        this.maxValue = chart.getMaximum();
    }

    public void serverChanged(ServerChangeEvent serverChangeEvent) {
        this.monitor.serverChanged(serverChangeEvent);
        if (!this.isActive() && this.monitor.isRegistered()) {
            this.monitor.deregister();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("value")) {
            this.value = this.monitor.getValue().floatValue();
            this.refreshValue();
        }
    }

    String getStatus() {
        return this.isActive() ? this.support.getStatus() : "";
    }

    boolean isErrorStatus() {
        return this.isActive() ? this.support.isErrorStatus() : false;
    }

    void setMinValue(float f) {
        short s = this.getDatatype();
        if ((f = (float)Math.min(Math.max((double)f, DT.minValue((short)s)), DT.maxValue((short)s))) > this.maxValue) {
            f = this.maxValue;
        }
        this.minValue = f;
        this.chart.resetChart();
        this.refreshValue();
    }

    float getMinValue() {
        return this.minValue;
    }

    void setMaxValue(float f) {
        short s = this.getDatatype();
        if ((f = (float)Math.min(Math.max((double)f, DT.minValue((short)s)), DT.maxValue((short)s))) < this.minValue) {
            f = this.minValue;
        }
        this.maxValue = f;
        this.chart.resetChart();
        this.refreshValue();
    }

    float getMaxValue() {
        return this.maxValue;
    }

    String getAddress() {
        return this.monitor.getAddress();
    }

    void setAddress(String string) {
        this.monitor.setAddress(string);
        this.chart.setPenActive(this.index, this.monitor.getAddress().length() > 0);
        this.chart.resetChart();
        if (this.isActive()) {
            if (!this.monitor.isRegistered()) {
                this.monitor.register();
            }
        } else if (this.monitor.isRegistered()) {
            this.monitor.deregister();
        }
    }

    short getDatatype() {
        return this.monitor.getDatatype();
    }

    void setDatatype(short s) {
        this.monitor.setDatatype(s);
        this.setMinValue(this.minValue);
        this.setMaxValue(this.maxValue);
    }

    final boolean isActive() {
        return this.chart.isPenActive(this.index);
    }

    final void refreshValue() {
        float f = this.chart.getMinimum();
        float f2 = this.chart.getMaximum();
        float f3 = (f2 - f) / (this.maxValue - this.minValue);
        float f4 = (this.value - this.minValue) * f3 + f;
        if (f4 < f) {
            f4 = f;
        }
        if (f4 > f2) {
            f4 = f2;
        }
        this.chart.setValue(this.index, f4);
    }
}

