/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.HChart;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;

class PenLegend
implements Serializable {
    static final long serialVersionUID = 6447213522502255332L;
    private static final int SPACING = 10;
    private static final String UNKNOWN = "???";
    private String[] penLabels = new String[HChart.MAX_PENS];
    private Color[] penColors = new Color[HChart.MAX_PENS];
    private boolean[] activePens = new boolean[HChart.MAX_PENS];
    private Font font = new Font("SansSerif", 0, 12);
    private Color background;
    private Rectangle box = new Rectangle();

    PenLegend() {
        for (int i = 0; i < this.penLabels.length; ++i) {
            this.penLabels[i] = "";
        }
        System.arraycopy(HChart.defaultColors, 0, this.penColors, 0, this.penColors.length);
    }

    void setBackground(Color color) {
        this.background = color;
    }

    void setPenColor(int n, Color color) {
        this.penColors[n] = color;
    }

    void setPenActive(int n, boolean bl) {
        this.activePens[n] = bl;
    }

    boolean isPenActive(int n) {
        return this.activePens[n];
    }

    void setPenLabel(int n, String string) {
        this.penLabels[n] = string;
    }

    String getPenLabel(int n) {
        return this.penLabels[n];
    }

    Dimension getMinimumSize() {
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < this.penLabels.length; ++i) {
            if (!this.activePens[i]) continue;
            String string = this.penLabels[i].trim();
            if (string.length() == 0) {
                string = UNKNOWN;
            }
            ++n3;
            n2 += fontMetrics.stringWidth(string) + 10;
        }
        if (n3 <= 1) {
            n2 = 0;
        }
        if (n2 > 0) {
            n = fontMetrics.getHeight();
        }
        return new Dimension(n2, n);
    }

    void paint(Graphics graphics) {
        int n = 0;
        for (int i = 0; !(i >= this.activePens.length || this.activePens[i] && ++n > 1); ++i) {
        }
        if (n > 1) {
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            graphics.setFont(this.font);
            int n2 = this.box.x + this.box.width - 1;
            int n3 = this.box.y + this.box.height - 1;
            graphics.setColor(Color.lightGray);
            graphics.drawLine(this.box.x, n3, n2, n3);
            graphics.setColor(this.background);
            graphics.fillRect(this.box.x, this.box.y, this.box.width, this.box.height - 1);
            int n4 = this.box.x + 10;
            int n5 = this.box.y + (this.box.height + fontMetrics.getHeight()) / 2 - fontMetrics.getDescent();
            for (int i = 0; i < this.activePens.length; ++i) {
                if (!this.activePens[i]) continue;
                String string = this.penLabels[i].trim();
                if (string.length() == 0) {
                    string = UNKNOWN;
                }
                graphics.setColor(this.penColors[i]);
                graphics.drawString(string, n4, n5);
                n4 += fontMetrics.stringWidth(string) + 10;
            }
        }
    }

    void setBounds(Rectangle rectangle) {
        this.box = rectangle;
    }
}

