/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.MonitorNumber;
import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.SetNumber;
import com.schneiderautomation.factorycast.SetRef;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.MonitorSupport;
import com.schneiderautomation.gde.WriteSupport;
import com.schneiderautomation.widgets.PushButtonGui;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;

public class PushButton
extends PushButtonGui
implements GraphicalObject,
ActionListener,
Serializable {
    static final long serialVersionUID = 7682762335035597768L;
    private transient boolean fEnabled;
    private transient CommBean comm;
    private transient SetNumber resetter;
    private SetNumber setter = new SetNumber();
    private MonitorNumber monitor = new MonitorNumber();
    private WriteSupport writeSupport = new WriteSupport((SetRef)this.setter, (GraphicalObject)this);
    private MonitorSupport readSupport = new MonitorSupport((MonitorRef)this.monitor, (GraphicalObject)this);
    private Number[] resetValues;
    private int resetDelay;

    public PushButton() {
        this.addActionListener(this);
    }

    public void serverChanged(ServerChangeEvent serverChangeEvent) {
        this.monitor.serverChanged(serverChangeEvent);
        this.setter.serverChanged(serverChangeEvent);
        this.comm = serverChangeEvent.getCommBean();
        if (this.comm != null) {
            this.setter.enableAccessChecking(this.comm.getVarLookup());
            this.setEnabled(this.fEnabled);
        } else {
            this.setEnabled(false);
        }
    }

    public void enableUserInput() {
        this.fEnabled = true;
        this.setEnabled(this.fEnabled);
    }

    public void disableUserInput() {
        this.fEnabled = false;
        this.setEnabled(this.fEnabled);
    }

    public String getStatus() {
        return this.readSupport.getStatus();
    }

    public boolean isErrorStatus() {
        return this.readSupport.isErrorStatus();
    }

    public String getAddress() {
        return this.monitor.getAddress();
    }

    public void setAddress(String string) {
        this.monitor.setAddress(string);
        this.setter.setAddress(this.monitor.getAddress());
    }

    public short getDatatype() {
        return this.monitor.getDatatype();
    }

    public void setDatatype(short s) {
        this.monitor.setDatatype(s);
        this.setter.setDatatype(this.monitor.getDatatype());
    }

    public Number[] getValues() {
        return this.setter.getValues();
    }

    public void setValues(Number[] numberArray) {
        this.setter.setValues(numberArray);
        this.setResetValues(this.getResetValues());
    }

    public Number[] getResetValues() {
        if (this.resetValues == null) {
            this.resetValues = new Number[0];
        }
        return this.resetValues;
    }

    public void setResetValues(Number[] numberArray) {
        if (numberArray.length > 0 && numberArray.length != this.setter.getQuantity()) {
            Number[] numberArray2 = new Number[this.setter.getQuantity()];
            for (int i = 0; i < numberArray2.length; ++i) {
                numberArray2[i] = i < numberArray.length ? (Number)numberArray[i] : (Number)new Integer(0);
            }
            numberArray = numberArray2;
        }
        this.resetValues = numberArray;
    }

    public void setResetDelay(int n) {
        this.resetDelay = Math.min(Math.max(n, 0), 2000);
    }

    public int getResetDelay() {
        return this.resetDelay;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            if (this.fEnabled) {
                try {
                    this.setter.sendValues();
                    if (this.resetValues == null || this.resetValues.length <= 0) break block6;
                    try {
                        Thread.sleep(this.resetDelay);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.resetter == null) {
                        this.resetter = new SetNumber(this.comm.getServer());
                        new WriteSupport((SetRef)this.resetter, (GraphicalObject)this);
                    }
                    this.resetter.setAddress(this.setter.getAddress());
                    this.resetter.setDatatype(this.setter.getDatatype());
                    this.resetter.setValues(this.resetValues);
                    this.resetter.sendValues();
                }
                catch (Exception exception) {
                    this.writeSupport.setStatus(true, exception.getMessage());
                }
            }
        }
    }
}

