/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.factorycast.MonitorNumber;
import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.SetNumber;
import com.schneiderautomation.factorycast.SetRef;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.WriteSupport;
import com.schneiderautomation.widgets.RSelectorGui;
import com.schneiderautomation.widgets.SelectorSupport;
import com.schneiderautomation.widgets.SelectorSupportInterface;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;

public class RSelector
extends RSelectorGui
implements GraphicalObject,
SelectorSupportInterface,
ItemListener,
Serializable {
    static final long serialVersionUID = 3006116839631975368L;
    private transient boolean fEnabled;
    private SetNumber setter = new SetNumber();
    private MonitorNumber monitor = new MonitorNumber();
    private WriteSupport writeSupport = new WriteSupport((SetRef)this.setter, (GraphicalObject)this);
    private SelectorSupport readSupport = new SelectorSupport(this, (MonitorRef)this.monitor, this);

    public RSelector() {
        this.addItemListener(this);
    }

    public void serverChanged(ServerChangeEvent serverChangeEvent) {
        this.monitor.serverChanged(serverChangeEvent);
        this.setter.serverChanged(serverChangeEvent);
        if (serverChangeEvent.getCommBean() != null) {
            this.setter.enableAccessChecking(serverChangeEvent.getVarLookup());
            this.setEnabled(this.fEnabled);
        } else {
            this.setEnabled(false);
        }
    }

    public void enableUserInput() {
        this.fEnabled = true;
        this.setEnabled(this.fEnabled);
    }

    public void disableUserInput() {
        this.fEnabled = false;
        this.setEnabled(this.fEnabled);
    }

    public String getStatus() {
        return this.readSupport.getStatus();
    }

    public boolean isErrorStatus() {
        return this.readSupport.isErrorStatus();
    }

    public String getAddress() {
        return this.monitor.getAddress();
    }

    public void setAddress(String string) {
        this.monitor.setAddress(string);
        this.setter.setAddress(this.monitor.getAddress());
    }

    public short getDatatype() {
        return this.monitor.getDatatype();
    }

    public void setDatatype(short s) {
        this.monitor.setDatatype(s);
        this.setter.setDatatype(this.monitor.getDatatype());
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.fEnabled) {
            this.readSupport.updateNotify();
            try {
                this.setter.setValue((Number)new Long(this.getSelectedValue()));
                this.setter.sendValues();
            }
            catch (Exception exception) {
                this.writeSupport.setStatus(true, exception.getMessage());
            }
        }
    }

    public boolean select(long l) {
        if (l != this.getSelectedValue()) {
            this.setSelection(l);
            return this.getSelectedValue() == l;
        }
        return true;
    }
}

