/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.Bar;
import com.schneiderautomation.widgets.SliderInterface;
import com.schneiderautomation.widgets.WidgetScrollbar;
import java.awt.Dimension;
import java.io.Serializable;

class Scroller
extends WidgetScrollbar
implements SliderInterface,
Serializable {
    static final long serialVersionUID = 2750648654545728585L;
    static final int SB_RANGE = 100000;
    private float minimum = 0.0f;
    private float maximum = 100.0f;

    Scroller(int n) {
        super(n, 0, 1, 0, 100001);
        this.setEUBlockIncrement(10.0f);
        this.setEUUnitIncrement(1.0f);
    }

    int getThumbLength() {
        return 8;
    }

    public Dimension getMinimumSize() {
        if (this.getOrientation() == 1) {
            return new Dimension(12, 64);
        }
        return new Dimension(64, 12);
    }

    public void setEUMinimum(float f) {
        if ((f = Bar.limitFloat(f)) > this.maximum) {
            f = this.maximum;
        }
        this.minimum = f;
    }

    public float getEUMinimum() {
        return this.minimum;
    }

    public void setEUMaximum(float f) {
        if ((f = Bar.limitFloat(f)) < this.minimum) {
            f = this.minimum;
        }
        this.maximum = f;
    }

    public float getEUMaximum() {
        return this.maximum;
    }

    public void setEUValue(float f) {
        int n = (int)((f - this.minimum) / (this.maximum - this.minimum) * 100000.0f);
        if (this.getOrientation() == 1) {
            n = 100000 - n;
        }
        this.setValue(n);
    }

    public float getEUValue() {
        int n = this.getValue();
        if (this.getOrientation() == 1) {
            n = 100000 - n;
        }
        float f = (float)n * (this.maximum - this.minimum) / 100000.0f + this.minimum;
        return f;
    }

    public void setEUBlockIncrement(float f) {
        float f2 = this.maximum - this.minimum;
        f = Math.min(Math.max(f, f2 / 100000.0f), f2);
        int n = (int)(f / f2 * 100000.0f);
        this.setBlockIncrement(n);
    }

    public float getEUBlockIncrement() {
        return (float)this.getBlockIncrement() * (this.maximum - this.minimum) / 100000.0f;
    }

    public void setEUUnitIncrement(float f) {
        float f2 = this.maximum - this.minimum;
        f = Math.min(Math.max(f, f2 / 100000.0f), f2);
        int n = (int)(f / f2 * 100000.0f);
        this.setUnitIncrement(n);
    }

    public float getEUUnitIncrement() {
        return (float)this.getUnitIncrement() * (this.maximum - this.minimum) / 100000.0f;
    }
}

