/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.factorycast.MonitorRef;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.MonitorSupport;
import com.schneiderautomation.widgets.InputSupport;
import com.schneiderautomation.widgets.InputSupportInterface;
import com.schneiderautomation.widgets.SliderSupportInterface;
import java.beans.PropertyChangeEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class SliderSupport
extends MonitorSupport
implements InputSupportInterface,
Serializable {
    static final long serialVersionUID = -8396327886080122512L;
    private InputSupport support = new InputSupport(this);
    private SliderSupportInterface slider;

    public SliderSupport(SliderSupportInterface sliderSupportInterface, MonitorRef monitorRef, GraphicalObject graphicalObject) {
        super(monitorRef, graphicalObject);
        this.slider = sliderSupportInterface;
    }

    public void updateNotify() {
        this.support.updateNotify();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("value")) {
            this.support.input((Number)propertyChangeEvent.getNewValue());
            return;
        }
        super.propertyChange(propertyChangeEvent);
    }

    public void receive(Number number) {
        this.slider.slide(number.floatValue());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (this.support == null) {
                this.support = new InputSupport(this);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ClassNotFoundException reading SliderSupport object: " + classNotFoundException.getMessage());
        }
    }
}

