/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;

class TScale
implements Serializable {
    static final long serialVersionUID = 7815844699104311552L;
    static final int TOP = 0;
    static final int BOTTOM = 1;
    private transient DateFormat format;
    private transient Date time;
    private int orientation = 0;
    private int majorTics = 1;
    private int majorTicSize = 8;
    private Color background = Color.white;
    private Color foreground = Color.black;
    private Font font = new Font("SansSerif", 0, 12);
    private Rectangle box = new Rectangle();
    private long updateInterval;

    TScale() {
    }

    TScale(int n) {
        this.orientation = n;
    }

    void updateTime(Graphics graphics) {
        if (this.majorTics > 0) {
            this.time = new Date();
            int n = this.orientation == 0 ? this.box.y : this.box.y + this.majorTicSize;
            graphics.setColor(this.background);
            graphics.fillRect(this.box.x, n, this.box.width, graphics.getFontMetrics(this.font).getHeight());
            this.drawLabels(graphics);
        }
    }

    void setBounds(Rectangle rectangle) {
        this.box = rectangle;
    }

    void setUpdateInterval(long l) {
        this.updateInterval = l;
    }

    void setBackground(Color color) {
        this.background = color;
    }

    void setForeground(Color color) {
        this.foreground = color;
    }

    Color getForeground() {
        return this.foreground;
    }

    void setFont(Font font) {
        this.font = font;
    }

    Font getFont() {
        return this.font;
    }

    void setMajorTics(int n) {
        this.majorTics = Math.min(Math.max(n, 0), 6);
    }

    int getMajorTics() {
        return this.majorTics;
    }

    Dimension getMinimumSize() {
        Dimension dimension = new Dimension(0, 0);
        if (this.majorTics > 0) {
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
            dimension.height = fontMetrics.getHeight() + this.majorTicSize;
            dimension.width = fontMetrics.stringWidth(this.formatValue(new Date())) * 2;
        }
        return dimension;
    }

    void paint(Graphics graphics) {
        if (this.majorTics > 0) {
            this.drawScale(graphics);
            this.drawLabels(graphics);
        }
    }

    void drawScale(Graphics graphics) {
        int n;
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        graphics.setColor(this.foreground);
        int n2 = this.orientation == 0 ? this.box.y + fontMetrics.getHeight() : this.box.y;
        int n3 = this.orientation == 0 ? this.box.y + this.box.height - 1 : this.box.y + this.majorTicSize - 1;
        int n4 = this.box.x;
        graphics.drawLine(n4, n2, n4, n3);
        for (n = 1; n <= this.majorTics; ++n) {
            n4 = this.box.x + this.box.width * n / this.majorTics - 1;
            graphics.drawLine(n4, n2, n4, n3);
        }
        n = this.orientation == 0 ? this.box.y + this.box.height - 1 : this.box.y;
        graphics.drawLine(this.box.x, n, this.box.x + this.box.width - 1, n);
    }

    void drawLabels(Graphics graphics) {
        if (this.time == null) {
            this.time = new Date();
        }
        FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
        graphics.setColor(this.foreground);
        graphics.setFont(this.font);
        long l = (long)this.box.width * this.updateInterval;
        int n = this.box.y + (this.orientation == 0 ? fontMetrics.getHeight() : this.box.height) - fontMetrics.getDescent();
        String string = this.formatValue(new Date(this.time.getTime() - l));
        int n2 = this.box.x;
        graphics.drawString(string, n2, n);
        for (int i = 1; i < this.majorTics; ++i) {
            long l2 = l * (long)(this.majorTics - i) / (long)this.majorTics;
            string = this.formatValue(new Date(this.time.getTime() - l2));
            n2 = this.box.x + this.box.width * i / this.majorTics - fontMetrics.stringWidth(string) / 2;
            graphics.drawString(string, n2, n);
        }
        string = this.formatValue(this.time);
        n2 = this.box.x + this.box.width - fontMetrics.stringWidth(string);
        graphics.drawString(string, n2, n);
    }

    private String formatValue(Date date) {
        if (this.format == null) {
            this.format = DateFormat.getTimeInstance(2);
        }
        return this.format.format(date);
    }
}

