/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.dt;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class FT {
    public static final String[] fmtNames = new String[]{"", "BOOLEAN", "DECIMAL", "HEXA", "BINARY", "REAL", "ASCII", "TIME", "DATE"};
    public static final int NOFMT = 0;
    public static final int BOOL = 1;
    public static final int DEC = 2;
    public static final int HEX = 3;
    public static final int BIN = 4;
    public static final int REAL = 5;
    public static final int ASCII = 6;
    public static final int TIME = 7;
    public static final int DATE = 8;
    public static final int N_FMTS = 9;
    private static final short MAX_USHORT = 255;
    private static final int MAX_UINT = 65535;
    private static final long MAX_UDINT = 0xFFFFFFFFL;
    private static final String ZEROES = "00000000000000000000000000000000";
    private static final int[] maxDay = new int[]{0, 49, 41, 49, 48, 49, 48, 49, 49, 48, 0, 0, 0, 0, 0, 0, 49, 48, 49};
    private static final DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance();

    public static final short toFT(String string) {
        for (short s = 1; s < fmtNames.length; s = (short)(s + 1)) {
            if (!string.equalsIgnoreCase(fmtNames[s])) continue;
            return s;
        }
        return 0;
    }

    public static String formatValue(Number number, int n, short s) {
        String string;
        block0 : switch (n) {
            case 3: 
            case 4: {
                int n2;
                int n3;
                long l = number.longValue();
                switch (s) {
                    case 1: {
                        return number.toString();
                    }
                    case 2: 
                    case 3: {
                        l &= 0xFFL;
                        n3 = 1;
                        break;
                    }
                    case 4: 
                    case 5: {
                        l &= 0xFFFFL;
                        n3 = 2;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 10: 
                    case 14: 
                    case 15: {
                        l &= 0xFFFFFFFFL;
                        n3 = 4;
                        break;
                    }
                    case 16: {
                        n3 = 8;
                        break;
                    }
                    default: {
                        return "????";
                    }
                }
                if (n == 3) {
                    n2 = n3 * 2;
                    string = Long.toHexString(l).toUpperCase();
                } else {
                    n2 = n3 * 8;
                    string = Long.toBinaryString(l);
                }
                if (string.length() >= n2) break;
                string = ZEROES.substring(0, n2 - string.length()) + string;
                break;
            }
            case 7: {
                long l = number.longValue();
                long l2 = l / 86400000L;
                long l3 = (l %= 86400000L) / 3600000L;
                long l4 = (l %= 3600000L) / 60000L;
                long l5 = (l %= 60000L) / 1000L;
                l %= 1000L;
                if (l2 > 0L) {
                    if (l > 0L) {
                        string = l2 + "d_" + l3 + "h_" + l4 + "m_" + l5 + "s_" + l + "ms";
                        break;
                    }
                    if (l5 > 0L) {
                        string = l2 + "d_" + l3 + "h_" + l4 + "m_" + l5 + "s";
                        break;
                    }
                    if (l4 > 0L) {
                        string = l2 + "d_" + l3 + "h_" + l4 + "m";
                        break;
                    }
                    if (l3 > 0L) {
                        string = l2 + "d_" + l3 + "h";
                        break;
                    }
                    string = l2 + "d";
                    break;
                }
                if (l3 > 0L) {
                    if (l > 0L) {
                        string = l3 + "h_" + l4 + "m_" + l5 + "s_" + l + "ms";
                        break;
                    }
                    if (l5 > 0L) {
                        string = l3 + "h_" + l4 + "m_" + l5 + "s";
                        break;
                    }
                    if (l4 > 0L) {
                        string = l3 + "h_" + l4 + "m";
                        break;
                    }
                    string = l3 + "h";
                    break;
                }
                if (l4 > 0L) {
                    if (l > 0L) {
                        string = l4 + "m_" + l5 + "s_" + l + "ms";
                        break;
                    }
                    if (l5 > 0L) {
                        string = l4 + "m_" + l5 + "s";
                        break;
                    }
                    string = l4 + "m";
                    break;
                }
                if (l5 > 0L) {
                    if (l > 0L) {
                        string = l5 + "s_" + l + "ms";
                        break;
                    }
                    string = l5 + "s";
                    break;
                }
                string = l + "ms";
                break;
            }
            case 6: {
                byte[] byArray;
                long l = number.longValue();
                switch (s) {
                    case 2: 
                    case 3: {
                        byArray = new byte[]{(byte)l};
                        break;
                    }
                    case 4: 
                    case 5: {
                        byArray = new byte[]{(byte)(l >> 8), (byte)l};
                        break;
                    }
                    case 6: 
                    case 7: {
                        byArray = new byte[]{(byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
                        break;
                    }
                    default: {
                        return "????";
                    }
                }
                for (int i = 0; i < byArray.length; ++i) {
                    if (byArray[i] >= 32 && byArray[i] <= 126) continue;
                    byArray[i] = 63;
                }
                string = new String(byArray);
                break;
            }
            case 2: {
                switch (s) {
                    case 8: {
                        string = FT.formatReal(number.doubleValue());
                        break block0;
                    }
                    case 14: 
                    case 15: 
                    case 16: {
                        string = FT.formatValue(number, 3, s);
                        break block0;
                    }
                }
                string = number.toString();
                break;
            }
            case 5: {
                string = FT.formatReal(number.doubleValue());
                break;
            }
            case 8: {
                string = FT.formatValue(number, 3, s);
                switch (s) {
                    case 14: {
                        string = string.substring(0, 4) + "-" + string.substring(4, 6) + "-" + string.substring(6, 8);
                        break;
                    }
                    case 15: {
                        string = string.substring(0, 2) + ":" + string.substring(2, 4) + ":" + string.substring(4, 6);
                        break;
                    }
                    case 16: {
                        string = string.substring(0, 4) + "-" + string.substring(4, 6) + "-" + string.substring(6, 8) + "-" + string.substring(8, 10) + ":" + string.substring(10, 12) + ":" + string.substring(12, 14);
                    }
                }
                break;
            }
            default: {
                string = number.toString();
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String formatReal(double d) {
        double d2 = Math.abs(d);
        if (d2 < 1.0E-5 || d2 >= 100000.0) {
            return String.valueOf((float)d);
        }
        DecimalFormat decimalFormat = formatter;
        synchronized (decimalFormat) {
            if (d2 >= 10000.0) {
                formatter.setMaximumFractionDigits(1);
            } else if (d2 >= 1000.0) {
                formatter.setMaximumFractionDigits(2);
            } else if (d2 >= 100.0) {
                formatter.setMaximumFractionDigits(3);
            } else if (d2 >= 10.0) {
                formatter.setMaximumFractionDigits(4);
            } else {
                formatter.setMaximumFractionDigits(5);
            }
            return formatter.format(d);
        }
    }

    public static Number parseValue(String string, int n, short s) {
        if (string == null || string.length() == 0) {
            return null;
        }
        Number number = null;
        block2 : switch (n) {
            case 1: {
                Byte by;
                if (s != 1 || (by = Byte.valueOf(string)).intValue() != 0 && by.intValue() != 1) break;
                number = by;
                break;
            }
            case 2: {
                switch (s) {
                    case 2: {
                        number = Byte.valueOf(string);
                        break;
                    }
                    case 3: {
                        Short s2 = Short.valueOf(string);
                        if (s2.intValue() < 0 || s2.intValue() > 255) break;
                        number = s2;
                        break;
                    }
                    case 4: {
                        number = Short.valueOf(string);
                        break;
                    }
                    case 5: {
                        Integer n2 = Integer.valueOf(string);
                        if (n2 < 0 || n2 > 65535) break;
                        number = n2;
                        break;
                    }
                    case 6: {
                        number = Integer.valueOf(string);
                        break;
                    }
                    case 7: 
                    case 10: {
                        Long l = Long.valueOf(string);
                        if (l < 0L || l > 0xFFFFFFFFL) break;
                        number = l;
                    }
                }
                break;
            }
            case 3: 
            case 4: {
                int n3 = n == 3 ? 16 : 2;
                switch (s) {
                    case 2: 
                    case 3: {
                        Short s3 = Short.valueOf(string, n3);
                        if (s3.intValue() < 0 || s3.intValue() > 255) break;
                        number = s3;
                        break;
                    }
                    case 4: 
                    case 5: {
                        Integer n4 = Integer.valueOf(string, n3);
                        if (n4 < 0 || n4 > 65535) break;
                        number = n4;
                        break;
                    }
                    case 6: 
                    case 7: 
                    case 10: 
                    case 14: 
                    case 15: {
                        Long l = Long.valueOf(string, n3);
                        if (l < 0L || l > 0xFFFFFFFFL) break;
                        number = l;
                        break;
                    }
                    case 16: {
                        number = Long.valueOf(string, n3);
                    }
                }
                break;
            }
            case 5: {
                if (s != 8) break;
                number = Float.valueOf(string);
                break;
            }
            case 7: {
                String[] stringArray = new String[5];
                StringTokenizer stringTokenizer = new StringTokenizer(string.trim().toLowerCase(), "_", false);
                int n5 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    if (n5 < stringArray.length) {
                        stringArray[n5++] = stringTokenizer.nextToken();
                        continue;
                    }
                    return null;
                }
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                long l5 = 0L;
                for (int i = 0; i < n5; ++i) {
                    String string2 = stringArray[i];
                    if (string2.endsWith("d") && string2.length() > 1) {
                        l = Long.parseLong(string2.substring(0, string2.length() - 1));
                        if (l >= 0L) continue;
                        return null;
                    }
                    if (string2.endsWith("h") && string2.length() > 1) {
                        l2 = Long.parseLong(string2.substring(0, string2.length() - 1));
                        if (l2 >= 0L) continue;
                        return null;
                    }
                    if (string2.endsWith("m") && string2.length() > 1) {
                        l3 = Long.parseLong(string2.substring(0, string2.length() - 1));
                        if (l3 >= 0L) continue;
                        return null;
                    }
                    if (string2.endsWith("s") && !string2.endsWith("ms") && string2.length() > 1) {
                        l4 = Long.parseLong(string2.substring(0, string2.length() - 1));
                        if (l4 >= 0L) continue;
                        return null;
                    }
                    if (string2.endsWith("ms") && string2.length() > 2) {
                        l5 = Long.parseLong(string2.substring(0, string2.length() - 2));
                        if (l5 >= 0L) continue;
                        return null;
                    }
                    return null;
                }
                Long l6 = new Long(l * 86400000L + l2 * 3600000L + l3 * 60000L + l4 * 1000L + l5);
                switch (s) {
                    case 3: {
                        if (l6 > 255L) break;
                        number = l6;
                        break;
                    }
                    case 5: {
                        if (l6 > 65535L) break;
                        number = l6;
                        break;
                    }
                    case 7: 
                    case 10: {
                        if (l6 > 0xFFFFFFFFL) break;
                        number = l6;
                    }
                }
                break;
            }
            case 6: {
                int n6;
                for (n6 = string.length(); n6 > 0 && string.charAt(n6 - 1) == ' '; --n6) {
                }
                StringBuffer stringBuffer = new StringBuffer(n6 > 0 ? string.substring(0, n6) : "");
                switch (s) {
                    case 2: 
                    case 3: {
                        if (stringBuffer.length() > 1) break;
                        stringBuffer.append(" ");
                        number = new Byte((byte)stringBuffer.charAt(0));
                        break;
                    }
                    case 4: 
                    case 5: {
                        if (stringBuffer.length() > 2) break;
                        stringBuffer.append("  ");
                        number = new Short((short)(stringBuffer.charAt(0) << 8 | stringBuffer.charAt(1)));
                        break;
                    }
                    case 6: 
                    case 7: {
                        if (stringBuffer.length() > 4) break;
                        stringBuffer.append("    ");
                        number = new Integer(stringBuffer.charAt(0) << 24 | stringBuffer.charAt(1) << 16 | stringBuffer.charAt(2) << 8 | stringBuffer.charAt(3));
                    }
                }
                break;
            }
            case 8: {
                switch (s) {
                    case 14: {
                        int n7;
                        String string3;
                        String string4;
                        String string5;
                        Object object;
                        try {
                            object = new StringTokenizer(string, "-");
                            string5 = ((StringTokenizer)object).nextToken();
                            string4 = ((StringTokenizer)object).nextToken();
                            string3 = ((StringTokenizer)object).nextToken();
                            if (((StringTokenizer)object).hasMoreTokens()) {
                                return null;
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            return null;
                        }
                        if (string4.length() == 1) {
                            string4 = "0" + string4;
                        }
                        if (string3.length() == 1) {
                            string3 = "0" + string3;
                        }
                        if (string5.length() != 4 || string4.length() != 2 || string3.length() != 2) {
                            return null;
                        }
                        object = string5 + string4 + string3;
                        for (n7 = 0; n7 < ((String)object).length(); ++n7) {
                            if (Character.isDigit(((String)object).charAt(n7))) continue;
                            return null;
                        }
                        n7 = Integer.parseInt(string5, 16);
                        int n8 = Integer.parseInt(string4, 16);
                        int n9 = Integer.parseInt(string3, 16);
                        if (n7 < 6544 || n7 > 8345 || n8 < 1 || n8 > 18 || n9 < 1 || n9 > maxDay[n8]) {
                            return null;
                        }
                        number = Integer.valueOf((String)object, 16);
                        break block2;
                    }
                    case 15: {
                        int n10;
                        String string6;
                        String string7;
                        String string8;
                        Object object;
                        try {
                            object = new StringTokenizer(string, ":");
                            string8 = ((StringTokenizer)object).nextToken();
                            string7 = ((StringTokenizer)object).nextToken();
                            string6 = ((StringTokenizer)object).nextToken();
                            if (((StringTokenizer)object).hasMoreTokens()) {
                                return null;
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {
                            return null;
                        }
                        if (string8.length() == 1) {
                            string8 = "0" + string8;
                        }
                        if (string7.length() == 1) {
                            string7 = "0" + string7;
                        }
                        if (string6.length() == 1) {
                            string6 = "0" + string6;
                        }
                        if (string8.length() != 2 || string7.length() != 2 || string6.length() != 2) {
                            return null;
                        }
                        object = string8 + string7 + string6 + "00";
                        for (n10 = 0; n10 < ((String)object).length(); ++n10) {
                            if (Character.isDigit(((String)object).charAt(n10))) continue;
                            return null;
                        }
                        n10 = Integer.parseInt(string8, 16);
                        int n11 = Integer.parseInt(string7, 16);
                        int n12 = Integer.parseInt(string6, 16);
                        if (n10 < 0 || n10 > 35 || n11 < 0 || n11 > 89 || n12 < 0 || n12 > 89) {
                            return null;
                        }
                        number = Integer.valueOf((String)object, 16);
                        break block2;
                    }
                    case 16: {
                        int n13 = string.lastIndexOf(45);
                        if (n13 <= 0 || n13 >= string.length() - 1) {
                            return null;
                        }
                        Number number2 = FT.parseValue(string.substring(0, n13), 8, (short)14);
                        Number number3 = FT.parseValue(string.substring(n13 + 1), 8, (short)15);
                        if (number2 == null || number3 == null) {
                            return null;
                        }
                        number = new Long(number2.longValue() << 32 | number3.longValue() & 0xFFFFFFFFL);
                    }
                }
            }
        }
        return number;
    }

    static {
        ((NumberFormat)formatter).setGroupingUsed(false);
        formatter.setMinimumFractionDigits(1);
    }
}

