/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.ServerChangeListener;
import com.schneiderautomation.factorycast.comm.ClientHandlerInterface;
import com.schneiderautomation.factorycast.comm.FCCExceptionMessages;
import com.schneiderautomation.factorycast.comm.StatusMessages;
import com.schneiderautomation.factorycast.comm.ValueAdaptor;
import com.schneiderautomation.factorycast.comm.XBFExceptionMessages;
import com.schneiderautomation.misc.GlobalConfig;
import com.schneiderautomation.namespace.VarLookupInterface;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import java.util.Locale;

public abstract class CommBeanSupport
implements Serializable {
    static final long serialVersionUID = 2697393450746540849L;
    private transient ValueAdaptor adaptor;
    private transient ClientHandlerInterface server;
    private transient boolean fConnected;
    private transient boolean fSuspended;
    private transient ServerChangeEvent serverChangeEvent;
    private int pollingDelay = GlobalConfig.MIN_POLLING_DELAY;
    protected PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);

    public CommBeanSupport(Locale locale) {
        this.initWorkers(locale);
    }

    public void setPollingDelay(int n) {
        this.pollingDelay = Math.min(Math.max(n, GlobalConfig.MIN_POLLING_DELAY), GlobalConfig.MAX_POLLING_DELAY);
        if (this.server != null) {
            try {
                this.server.setPollingDelay(this.pollingDelay);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public int getPollingDelay() {
        return this.pollingDelay;
    }

    public boolean isStarted() {
        return this.adaptor != null ? this.adaptor.isStarted() : false;
    }

    public boolean isConnected() {
        return this.fConnected;
    }

    public boolean isSuspended() {
        return this.fSuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String string, boolean bl) throws Exception {
        CommBeanSupport commBeanSupport = this;
        synchronized (commBeanSupport) {
            if (this.server == null) {
                System.out.println("CommBean.connect(): server == null!");
                return;
            }
            if (this.fConnected) {
                System.out.println("CommBean.connect(): already connected!");
                return;
            }
            if (this.pollingDelay > 0) {
                this.server.setPollingDelay(this.pollingDelay);
            }
            this.server.connect(string, bl);
            this.fConnected = true;
        }
        this.boundSupport.firePropertyChange("connected", null, new Boolean(this.fConnected));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() throws Exception {
        boolean bl = false;
        boolean bl2 = false;
        CommBeanSupport commBeanSupport = this;
        synchronized (commBeanSupport) {
            if (this.server == null || !this.fConnected) {
                return;
            }
            this.server.disconnect();
            this.fConnected = false;
            if (this.adaptor.isStarted()) {
                this.adaptor.disconnectOccured();
                bl = true;
            }
            if (this.fSuspended) {
                this.fSuspended = false;
                bl2 = true;
            }
        }
        if (bl) {
            this.boundSupport.firePropertyChange("started", null, new Boolean(this.adaptor.isStarted()));
        }
        if (bl2) {
            this.boundSupport.firePropertyChange("suspended", null, new Boolean(this.fSuspended));
        }
        this.boundSupport.firePropertyChange("connected", null, new Boolean(this.fConnected));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        CommBeanSupport commBeanSupport = this;
        synchronized (commBeanSupport) {
            if (this.server == null || this.adaptor.isStarted() || !this.fConnected) {
                return;
            }
            this.adaptor.start(this.server);
        }
        this.boundSupport.firePropertyChange("started", null, new Boolean(this.adaptor.isStarted()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        CommBeanSupport commBeanSupport = this;
        synchronized (commBeanSupport) {
            if (this.server == null || !this.adaptor.isStarted()) {
                return;
            }
            this.adaptor.stop();
        }
        this.boundSupport.firePropertyChange("started", null, new Boolean(this.adaptor.isStarted()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspend() throws Exception {
        CommBeanSupport commBeanSupport = this;
        synchronized (commBeanSupport) {
            if (this.server == null || this.fSuspended) {
                return;
            }
            this.server.suspend();
            this.fSuspended = true;
        }
        this.boundSupport.firePropertyChange("suspended", null, new Boolean(this.fSuspended));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resume() throws Exception {
        CommBeanSupport commBeanSupport = this;
        synchronized (commBeanSupport) {
            if (this.server == null || !this.fSuspended) {
                return;
            }
            this.server.resume();
            this.fSuspended = false;
        }
        this.boundSupport.firePropertyChange("suspended", null, new Boolean(this.fSuspended));
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.boundSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.boundSupport.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addServerChangeListener(ServerChangeListener serverChangeListener) {
        this.initWorkers(GlobalConfig.getLocale());
        try {
            this.serverChangeEvent = new ServerChangeEvent(this, (CommBean)this);
            serverChangeListener.serverChanged(this.serverChangeEvent);
        }
        finally {
            this.serverChangeEvent = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeServerChangeListener(ServerChangeListener serverChangeListener) {
        try {
            this.serverChangeEvent = new ServerChangeEvent(this, null);
            serverChangeListener.serverChanged(this.serverChangeEvent);
        }
        finally {
            this.serverChangeEvent = null;
        }
    }

    public ValueAdaptor getAdaptor() {
        return this.adaptor;
    }

    public ClientHandlerInterface getServer() {
        return this.server;
    }

    public VarLookupInterface getVarLookup() {
        try {
            return this.server.getVarLookup();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public ServerChangeEvent getServerChangeEvent() {
        return this.serverChangeEvent;
    }

    protected abstract ClientHandlerInterface createClientHandler(Locale var1);

    private void initWorkers(Locale locale) {
        if (this.server == null) {
            StatusMessages.init(locale);
            FCCExceptionMessages.init(locale);
            XBFExceptionMessages.init(locale);
            this.adaptor = new ValueAdaptor();
            this.server = this.createClientHandler(locale);
        }
    }
}

