/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.ServerChangeEvent;
import com.schneiderautomation.factorycast.ServerChangeListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;

public class ConnectPLC
implements ServerChangeListener,
PropertyChangeListener,
Serializable {
    static final long serialVersionUID = -3571057960071385391L;
    private transient CommBean comm;
    private PropertyChangeSupport boundSupport = new PropertyChangeSupport(this);
    private String hostname = "";
    private boolean loadSymbols;

    public String getPLC() {
        return this.hostname;
    }

    public boolean isLoadSymbols() {
        return this.loadSymbols;
    }

    public void setPLC(String string) {
        String string2 = this.hostname;
        this.hostname = string;
        this.boundSupport.firePropertyChange("PLC", string2, this.hostname);
    }

    public void setLoadSymbols(boolean bl) {
        Boolean bl2 = new Boolean(this.loadSymbols);
        this.loadSymbols = bl;
        this.boundSupport.firePropertyChange("loadSymbols", bl2, new Boolean(bl));
    }

    public boolean isConnected() {
        return this.comm != null ? this.comm.isConnected() : false;
    }

    public boolean isStarted() {
        return this.comm != null ? this.comm.isStarted() : false;
    }

    public boolean isSuspended() {
        return this.comm != null ? this.comm.isSuspended() : false;
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.boundSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.boundSupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void connect() {
        if (this.comm != null) {
            try {
                this.comm.connect(this.hostname, this.loadSymbols);
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public void disconnect() {
        if (this.comm != null) {
            try {
                this.comm.disconnect();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public void start() {
        if (this.comm != null) {
            this.comm.start();
        }
    }

    public void stop() {
        if (this.comm != null) {
            this.comm.stop();
        }
    }

    public void suspend() {
        if (this.comm != null) {
            try {
                this.comm.suspend();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public void resume() {
        if (this.comm != null) {
            try {
                this.comm.resume();
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    public void serverChanged(ServerChangeEvent serverChangeEvent) {
        if (this.comm != null) {
            try {
                this.comm.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.comm.removePropertyChangeListener(this);
            this.comm = null;
        }
        this.comm = serverChangeEvent.getCommBean();
        if (this.comm != null) {
            this.comm.addPropertyChangeListener(this);
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("connected") || string.equals("started") || string.equals("suspended")) {
            this.boundSupport.firePropertyChange(string, propertyChangeEvent.getOldValue(), propertyChangeEvent.getNewValue());
        }
    }
}

