/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast;

import com.schneiderautomation.factorycast.GetBits;
import com.schneiderautomation.factorycast.SetRef;
import com.schneiderautomation.factorycast.comm.BadDataTypeException;
import com.schneiderautomation.factorycast.comm.ClientHandlerInterface;
import java.io.Serializable;
import java.util.BitSet;

public class SetBits
extends SetRef
implements Serializable {
    static final long serialVersionUID = -4211260980049956054L;
    private BitSet bitset;
    private short qty = 1;

    public SetBits() {
        super((short)0);
    }

    public SetBits(ClientHandlerInterface clientHandlerInterface) {
        super(clientHandlerInterface, (short)0);
    }

    public short getQuantity() {
        return this.qty;
    }

    public synchronized void setQuantity(short s) {
        if (this.qty != s && s > 0) {
            Short s2 = new Short(this.qty);
            this.qty = s;
            this.clearValueObject();
            this.fireQuantityPropertyChange(s2);
        }
    }

    public synchronized void setValue(BitSet bitSet) {
        if (bitSet != null) {
            BitSet bitSet2 = this.bitset;
            this.bitset = (BitSet)bitSet.clone();
            this.clearValueObject();
            this.fireValuePropertyChange(bitSet2);
        }
    }

    public BitSet getValue() {
        return this.bitset != null ? (BitSet)this.bitset.clone() : new BitSet();
    }

    public void setDatatype(short s) {
        super.setDatatype(s);
    }

    protected void fireValuePropertyChange(Object object) {
        this.firePropertyChange("value", object, this.bitset.clone());
    }

    protected void validateDatatype(short s) throws BadDataTypeException {
        GetBits.getBitsPerValue(s);
    }

    protected final Number[] getNumberValues() {
        int n;
        try {
            n = GetBits.getBitsPerValue(this.getValueType());
        }
        catch (BadDataTypeException badDataTypeException) {
            return null;
        }
        int n2 = 1 << n - 1;
        Number[] numberArray = new Number[this.qty];
        int n3 = 0;
        for (int i = 0; i < this.qty; ++i) {
            int n4 = 0;
            for (int j = 0; j < n; ++j) {
                if (!this.bitset.get(n3++)) continue;
                n4 |= n2 >>> j;
            }
            numberArray[i] = new Integer(n4);
        }
        return numberArray;
    }
}

