/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast.comm;

import com.schneiderautomation.factorycast.comm.ClientHandlerInterface;
import com.schneiderautomation.factorycast.comm.CommUpdateInterface;
import com.schneiderautomation.factorycast.comm.FCIOException;
import com.schneiderautomation.factorycast.comm.GetRefRequest;
import com.schneiderautomation.factorycast.comm.GetRefResponse;
import com.schneiderautomation.factorycast.comm.ServerHandlerInterface;
import com.schneiderautomation.factorycast.comm.SetRefRequest;
import com.schneiderautomation.factorycast.comm.SetRefResponse;
import com.schneiderautomation.factorycast.comm.SubscriptionList;
import com.schneiderautomation.factorycast.comm.UpdateQueue;
import com.schneiderautomation.factorycast.comm.UpdateRequest;
import com.schneiderautomation.factorycast.comm.UtilInterface;
import com.schneiderautomation.namespace.NameSpace;
import com.schneiderautomation.namespace.VarLookupInterface;
import com.schneiderautomation.namespace.VerInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Vector;

public abstract class ClientHandlerAdaptor
implements ClientHandlerInterface,
CommUpdateInterface {
    public static final byte MODBUS = 0;
    public static final byte UNITE = 1;
    private InetAddress host;
    private boolean fSymbolsOK;
    private boolean fDebugMode;
    private VerInfo verInfo;
    protected Socket socket;
    protected InputStream input;
    protected OutputStream output;
    protected ServerHandlerInterface client;
    protected NameSpace varLookup;
    protected UpdateQueue queue;
    protected SubscriptionList subscriptions;

    protected ClientHandlerAdaptor(ServerHandlerInterface serverHandlerInterface, VarLookupInterface varLookupInterface) {
        this.client = serverHandlerInterface;
        this.varLookup = new NameSpace();
        this.queue = new UpdateQueue(serverHandlerInterface);
        this.subscriptions = new SubscriptionList(this, this.queue);
    }

    protected abstract int getPort();

    protected abstract int getProtocolId();

    protected abstract Object readVerInfo() throws Exception;

    protected int mapXWAY(byte[] byArray, int n) {
        return 0;
    }

    protected int unmapXWAY(byte[] byArray, int n) throws FCIOException {
        return n;
    }

    public abstract Vector createRequests(GetRefRequest[] var1) throws Exception;

    public abstract GetRefResponse[] getRefs(UpdateRequest var1) throws Exception;

    public abstract SetRefResponse setRef(SetRefRequest var1) throws Exception;

    public abstract GetRefResponse getRef(GetRefRequest var1) throws Exception;

    public abstract UtilInterface getUtil() throws Exception;

    public VarLookupInterface getVarLookup() {
        return this.varLookup;
    }

    public Object getExtension(Class clazz) {
        return null;
    }

    public boolean isUMASSupported() {
        return false;
    }

    public void setPollingDelay(int n) {
        this.subscriptions.setPollingDelay(n);
    }

    public int getPollingDelay() {
        return this.subscriptions.getPollingDelay();
    }

    public boolean isSymbolTableOK() {
        return this.fSymbolsOK;
    }

    public boolean isDebugModeEnabled() {
        return this.fDebugMode;
    }

    public VerInfo getProgramInfo() {
        return this.getVerInfo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect(String string, boolean bl) throws Exception {
        ClientHandlerAdaptor clientHandlerAdaptor = this;
        synchronized (clientHandlerAdaptor) {
            if (this.socket == null) {
                VerInfo verInfo = null;
                this.verInfo = null;
                this.fSymbolsOK = false;
                this.fDebugMode = false;
                try {
                    System.out.println("Connecting to '" + string + "'");
                    this.setSocket(new Socket(string, this.getPort()));
                    this.host = this.socket.getInetAddress();
                    this.verInfo = (VerInfo)this.readVerInfo();
                    if (bl) {
                        try {
                            System.out.println("Reading Symbol Table from " + this.host.getHostAddress());
                            this.varLookup.init(this.host);
                            verInfo = this.varLookup.getVerInfo();
                            switch (this.varLookup.getAccessLevel()) {
                                case 0: {
                                    if (this.verInfo == null) break;
                                    this.fSymbolsOK = this.verInfo.equals(verInfo);
                                    break;
                                }
                                case 1: {
                                    if (this.verInfo == null) break;
                                    this.fSymbolsOK = this.verInfo.symbolVerSame(verInfo);
                                    break;
                                }
                                case 2: {
                                    this.fSymbolsOK = true;
                                    if (this.verInfo == null) break;
                                    this.fDebugMode = !this.verInfo.symbolVerSame(verInfo);
                                }
                            }
                        }
                        catch (Exception exception) {
                            System.out.println("Unable to read Symbol Table: " + exception.getMessage());
                        }
                    }
                }
                catch (Exception exception) {
                    if (this.socket != null) {
                        try {
                            this.socket.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    this.input = null;
                    this.output = null;
                    this.socket = null;
                    System.out.println("Unable to connect to '" + string + "': " + exception.getMessage());
                    throw exception;
                }
                System.out.println("Successfully connected to '" + this.host.getHostName() + "' <" + this.host.getHostAddress() + ">");
                this.queue.start();
                this.subscriptions.startProcessing();
                if (this.fSymbolsOK) {
                    if (this.fDebugMode) {
                        System.out.println("Symbol Table is inconsistent with program.  Debug Access Mode enabled.");
                    } else {
                        System.out.println("Symbol Table is available and consistent with program.");
                    }
                } else if (bl) {
                    System.out.println("Symbol Table is unavailable or inconsistent with program.");
                }
                if (verInfo != null) {
                    System.out.println("Symbol Table is for program: " + verInfo.toDisplayString());
                }
                if (this.verInfo != null) {
                    System.out.println("Program is: " + this.verInfo.toDisplayString());
                }
            }
        }
    }

    protected synchronized void connect(String string) throws Exception {
        if (this.socket == null) {
            this.verInfo = null;
            this.fSymbolsOK = false;
            this.fDebugMode = false;
            try {
                System.out.println("Connecting to '" + string + "'");
                this.setSocket(new Socket(string, this.getPort()));
                this.host = this.socket.getInetAddress();
            }
            catch (Exception exception) {
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                this.input = null;
                this.output = null;
                this.socket = null;
                throw exception;
            }
            System.out.println("Successfully connected to '" + this.host.getHostName() + "' <" + this.host.getHostAddress() + ">");
            this.queue.start();
            this.subscriptions.startProcessing();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        ClientHandlerAdaptor clientHandlerAdaptor = this;
        synchronized (clientHandlerAdaptor) {
            if (this.socket != null) {
                this.subscriptions.stopProcessing(true);
                this.queue.stop();
                try {
                    this.socket.close();
                    System.out.println("Disconnected from '" + this.host.getHostName() + "'");
                }
                catch (IOException iOException) {
                    System.out.println("Disconnect Exception: " + iOException.getMessage());
                }
                this.input = null;
                this.output = null;
                this.socket = null;
            }
        }
    }

    public GetRefResponse[] subscribeList(GetRefRequest[] getRefRequestArray) throws Exception {
        return this.subscriptions.addList(getRefRequestArray);
    }

    public GetRefResponse subscribe(GetRefRequest getRefRequest) throws Exception {
        return this.subscriptions.add(getRefRequest);
    }

    public boolean unsubscribe(int n) {
        return this.subscriptions.remove(n);
    }

    public void suspend() {
        this.subscriptions.suspendProcessing();
    }

    public void resume() {
        this.subscriptions.resumeProcessing();
    }

    protected final VerInfo getVerInfo() {
        return this.verInfo;
    }

    protected synchronized void reset() {
        try {
            this.socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            this.setSocket(new Socket(this.host, this.getPort()));
        }
        catch (IOException iOException) {
            System.out.println("IOException opening socket: " + iOException.getMessage());
        }
    }

    private void setSocket(Socket socket) throws IOException {
        try {
            socket.setSoLinger(false, 0);
            socket.setSoTimeout(30000);
            socket.setTcpNoDelay(true);
        }
        catch (SocketException socketException) {
            System.out.println("SocketException initializing socket: " + socketException.getMessage());
        }
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        this.socket = socket;
        this.input = inputStream;
        this.output = outputStream;
    }
}

