/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast.comm;

import com.schneiderautomation.misc.GlobalConfig;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class StatusMessages {
    private static final String XBF_BNDL = "com.schneiderautomation.factorycast.comm.xbf.res.StatusStrBundle";
    private static final String UMAS_BNDL = "com.schneiderautomation.factorycast.comm.umas.res.StatusStrBundle";
    private static final String defMsgKey = "defStatusMsg";
    private static final String defEngMsg = "Error {0}";
    private static String defMsg = "Error {0}";
    private static ResourceBundle xbfMessages;
    private static ResourceBundle umasMessages;

    public static synchronized void init(Locale locale) {
        xbfMessages = ResourceBundle.getBundle(XBF_BNDL, locale);
        if (xbfMessages != null) {
            try {
                defMsg = xbfMessages.getString(defMsgKey);
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        umasMessages = ResourceBundle.getBundle(UMAS_BNDL, locale);
    }

    public static synchronized String get(Number number) {
        return StatusMessages.get(number.intValue());
    }

    public static String get(int n) {
        try {
            StatusMessages.init(GlobalConfig.getLocale());
            if (n < 0) {
                return umasMessages.getString(String.valueOf(-n));
            }
            return xbfMessages.getString(String.valueOf(n));
        }
        catch (MissingResourceException missingResourceException) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        return MessageFormat.format(defMsg, objectArray);
    }
}

