/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast.comm;

import com.schneiderautomation.factorycast.comm.ClientHandlerInterface;
import com.schneiderautomation.factorycast.comm.GetRefRequest;
import com.schneiderautomation.factorycast.comm.GetRefResponse;
import com.schneiderautomation.factorycast.comm.SubscriptionList;
import com.schneiderautomation.factorycast.comm.Target;
import com.schneiderautomation.factorycast.comm.ValueChangeEvent;
import com.schneiderautomation.factorycast.comm.ValueChangeListener;
import com.schneiderautomation.factorycast.comm.Xact;
import com.schneiderautomation.factorycast.comm.XactKey;
import java.util.Enumeration;
import java.util.Hashtable;

public class ValueAdaptor
implements ValueChangeListener {
    public static final int MAX_XBF_STATUS_ID = 65535;
    public static final int SUBSCRIPTION_REJECTED = 65536;
    public static final int SUBSCRIPTION_CANCELLED = 65537;
    public static final int SUBSCRIPTION_UNAVAILABLE = 65538;
    public static final int SUBSCRIPTION_WITHOUT_VALUE = 65539;
    private static int idLastXact = 0;
    private Hashtable handlerList = new Hashtable();
    private ClientHandlerInterface server = null;
    private boolean fStarted = false;

    public void valueChanged(ValueChangeEvent valueChangeEvent) {
        Xact xact = (Xact)this.handlerList.get(new XactKey(valueChangeEvent));
        if (xact != null) {
            xact.notifyTarget(valueChangeEvent);
        }
    }

    public boolean isStarted() {
        return this.fStarted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int registerEventHandler(Object object, String string, GetRefRequest getRefRequest) {
        Xact xact;
        int n;
        boolean bl = false;
        ValueAdaptor valueAdaptor = this;
        synchronized (valueAdaptor) {
            n = ++idLastXact;
            getRefRequest.setXactID(n);
            xact = new Xact(getRefRequest, new Target(object, string));
            this.handlerList.put(new XactKey(n), xact);
            if (this.fStarted) {
                bl = true;
            }
        }
        if (bl) {
            this.subscribe(xact);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deregisterEventHandler(Object object, String string, int n) {
        Xact xact;
        boolean bl = false;
        ValueAdaptor valueAdaptor = this;
        synchronized (valueAdaptor) {
            xact = (Xact)this.handlerList.remove(new XactKey(n));
            if (xact == null) {
                return false;
            }
            xact.removeTarget();
            if (this.fStarted) {
                bl = true;
            }
        }
        if (bl) {
            try {
                this.server.unsubscribe(xact.getRequest().getXactID());
            }
            catch (Exception exception) {
                System.out.println("Unsubscribe Exception: " + exception.getMessage());
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ClientHandlerInterface clientHandlerInterface) {
        Enumeration enumeration = null;
        int n = 0;
        GetRefRequest[] getRefRequestArray = this;
        synchronized (this) {
            if (clientHandlerInterface != null && !this.fStarted) {
                enumeration = this.handlerList.elements();
                n = this.handlerList.size();
                this.server = clientHandlerInterface;
                this.fStarted = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (enumeration != null) {
                GetRefResponse[] getRefResponseArray;
                getRefRequestArray = new GetRefRequest[n];
                for (int i = 0; i < n; ++i) {
                    Xact xact = (Xact)enumeration.nextElement();
                    getRefRequestArray[i] = xact.getRequest();
                }
                try {
                    getRefResponseArray = this.server.subscribeList(getRefRequestArray);
                }
                catch (Exception exception) {
                    System.err.println("Unexpected exception subscribing list: " + exception);
                    getRefResponseArray = new GetRefResponse[n];
                    for (int i = 0; i < n; ++i) {
                        getRefResponseArray[i] = SubscriptionList.createErrorResponse(getRefRequestArray[i].getXactID(), exception.getMessage(), 65536);
                    }
                }
                for (int i = 0; i < getRefResponseArray.length; ++i) {
                    Xact xact = (Xact)this.handlerList.get(new XactKey(getRefResponseArray[i].getXactID()));
                    if (xact == null) continue;
                    xact.notifyTarget(new ValueChangeEvent(this, getRefResponseArray[i]));
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Enumeration enumeration = null;
        Object object = this;
        synchronized (object) {
            if (this.fStarted) {
                enumeration = this.handlerList.elements();
                this.fStarted = false;
            }
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                object = (Xact)enumeration.nextElement();
                this.unsubscribe((Xact)object);
            }
        }
    }

    public synchronized void disconnectOccured() {
        this.fStarted = false;
    }

    private void subscribe(Xact xact) {
        GetRefResponse getRefResponse;
        GetRefRequest getRefRequest = xact.getRequest();
        try {
            getRefResponse = this.server.subscribe(getRefRequest);
        }
        catch (Exception exception) {
            getRefResponse = SubscriptionList.createErrorResponse(getRefRequest.getXactID(), exception.getMessage(), 65536);
        }
        if (getRefResponse != null) {
            xact.notifyTarget(new ValueChangeEvent(this, getRefResponse));
        }
    }

    private void unsubscribe(Xact xact) {
        int n = xact.getRequest().getXactID();
        try {
            this.server.unsubscribe(n);
        }
        catch (Exception exception) {
            System.out.println("Unsubscribe Exception: " + exception.getMessage());
        }
        GetRefResponse getRefResponse = SubscriptionList.createErrorResponse(n, null, 65537);
        xact.notifyTarget(new ValueChangeEvent(this, getRefResponse));
    }
}

