/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast.comm.umas;

import com.schneiderautomation.factorycast.comm.GetRefRequest;
import com.schneiderautomation.factorycast.comm.umas.AddressUMAS;
import com.schneiderautomation.factorycast.comm.umas.UpdateRequestUMAS;
import java.util.Vector;

abstract class UpdateOptimizer {
    private Vector optimized;

    UpdateOptimizer() {
    }

    abstract Vector getRaw();

    abstract Vector getOptimized();

    synchronized void addElement(UpdateRequestUMAS updateRequestUMAS) {
        this.getRaw().addElement(updateRequestUMAS);
        this.optimized = null;
    }

    synchronized void removeAllElements() {
        this.getRaw().removeAllElements();
        this.optimized = null;
    }

    synchronized int size() {
        return this.getRaw().size();
    }

    synchronized Vector optimize() {
        if (this.optimized == null) {
            this.optimized = this.getOptimized();
        }
        return this.optimized;
    }

    static UpdateRequestUMAS merge(Vector vector) {
        int n = vector.size();
        if (n == 1) {
            return (UpdateRequestUMAS)vector.elementAt(0);
        }
        if (n > 1) {
            GetRefRequest[] getRefRequestArray = new GetRefRequest[n];
            AddressUMAS[] addressUMASArray = new AddressUMAS[n];
            for (int i = 0; i < n; ++i) {
                UpdateRequestUMAS updateRequestUMAS = (UpdateRequestUMAS)vector.elementAt(i);
                getRefRequestArray[i] = updateRequestUMAS.getRequest();
                addressUMASArray[i] = updateRequestUMAS.addresses[0];
            }
            return new UpdateRequestUMAS(getRefRequestArray, addressUMASArray);
        }
        return null;
    }
}

