/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast.comm.xbf;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.factorycast.comm.FCIOException;
import com.schneiderautomation.factorycast.comm.InvalidAddressException;
import com.schneiderautomation.factorycast.comm.InvalidSymbolTableException;
import com.schneiderautomation.factorycast.comm.NotFoundException;
import com.schneiderautomation.factorycast.comm.Request;
import com.schneiderautomation.namespace.VarLookupInterface;
import com.schneiderautomation.vars.VarInfo;

class Address984 {
    public static final byte ref0x = 0;
    public static final byte ref1x = 1;
    public static final byte ref3x = 3;
    public static final byte ref4x = 4;
    public static final byte ref6x = 6;
    public static final byte refMem = 8;
    public static final byte refSym = 9;
    static final int MAX_OFFSET = 100000;
    static final int MAX_PAGE = 1000;
    byte idRefType;
    int idSymbol;
    int offset;
    short idDataType;

    private Address984(byte by, int n, int n2) {
        this.idRefType = by;
        this.idSymbol = n;
        this.offset = n2;
    }

    public String toString() {
        int n = this.offset % 100000;
        switch (this.idRefType) {
            case 0: {
                int n2 = 1000000 + n;
                return String.valueOf(n2).substring(1);
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: {
                int n3 = this.idRefType * 100000 + n;
                return String.valueOf(n3);
            }
            case 9: {
                int n4 = this.idRefType * 100000 + this.idSymbol % 100000;
                return String.valueOf(n4);
            }
            case 8: {
                int n5 = this.idSymbol % 1000;
                int n6 = n5 == 0 ? this.idRefType * 100000 + n : this.idRefType * 100000 * 1000 + n5 * 100000 + n;
                return String.valueOf(n6);
            }
        }
        return "";
    }

    short[] getDataTypes() {
        switch (this.idRefType) {
            case 0: 
            case 1: {
                return new short[]{1};
            }
            case 3: 
            case 4: 
            case 6: {
                return new short[]{4, 5, 6, 7, 8, 10};
            }
            case 8: {
                return new short[]{5};
            }
        }
        return new short[]{0};
    }

    static boolean isDirectAddress(String string) {
        if (string != null && string.length() > 1 && Character.isDigit(string.charAt(0))) {
            try {
                Long.parseLong(string);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    static Address984 parse(String string) throws InvalidAddressException {
        try {
            Byte by = new Byte(string.substring(0, 1));
            Long l = new Long(string.substring(1));
            byte by2 = by;
            if (by2 == 9) {
                return new Address984(by2, l.intValue(), 0);
            }
            if (by2 == 8) {
                int n = (int)(l / 100000L);
                int n2 = (int)(l % 100000L);
                return new Address984(by2, n, n2);
            }
            int n = l.intValue();
            if (by2 != 6 && (n < 1 || n > 65535)) {
                throw new Exception();
            }
            return new Address984(by2, 0, n);
        }
        catch (Exception exception) {
            throw new InvalidAddressException(string);
        }
    }

    static Address984 parse(Request request, VarLookupInterface varLookupInterface) throws FCIOException {
        Address984 address984;
        VarInfo varInfo;
        String string = request.getAddress().trim();
        if (string.length() == 0) {
            throw new InvalidAddressException(request.getAddress());
        }
        if (Address984.isDirectAddress(string)) {
            Address984 address9842 = Address984.parse(string);
            address9842.idDataType = request.getDatatype();
            if (address9842.idDataType == 0) {
                short s;
                address9842.idDataType = s = address9842.getDataTypes()[0];
            }
            return address9842;
        }
        if (varLookupInterface == null) {
            throw new InvalidSymbolTableException();
        }
        try {
            varInfo = varLookupInterface.get(string);
        }
        catch (Exception exception) {
            throw new FCIOException(exception.getMessage());
        }
        if (varInfo == null) {
            throw new NotFoundException(string);
        }
        if (varInfo.getSymbolType() == 1) {
            address984 = Address984.parse(varInfo.getAddress());
            address984.idSymbol = varInfo.getOffset();
        } else {
            address984 = new Address984(9, (int)varInfo.getSymbolID(), varInfo.getOffset());
        }
        address984.idDataType = DT.getNumericDataType(varInfo.getDataType());
        return address984;
    }
}

