/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.factorycast.comm.xbf;

import java.io.Serializable;

public class ENetStats
implements Serializable {
    private static final long MASK = 255L;
    private byte[] data;
    private int idx;
    public short[] macAddress;
    public short moduleStatus;
    public long rcvInterrupts;
    public long xmtInterrupts;
    public long xmtTimeoutErr;
    public long collisionErr;
    public long missedPacketErr;
    public long memoryErr;
    public long restartCount;
    public long rcvFrameErr;
    public long rcvOverflowErr;
    public long rcvCrcErr;
    public long rcvBufferErr;
    public long xmtBufferErr;
    public long xmtSiloUnderflow;
    public long xmtLateCollision;
    public long xmitLostCarrier;
    public long xmitRetries;
    public short[] ipAddress;

    public ENetStats() {
        this.macAddress = new short[6];
        this.ipAddress = new short[4];
    }

    ENetStats(byte[] byArray, int n) {
        this.data = byArray;
        this.idx = n;
        this.macAddress = new short[]{this.nextUSHORT(), this.nextUSHORT(), this.nextUSHORT(), this.nextUSHORT(), this.nextUSHORT(), this.nextUSHORT()};
        this.moduleStatus = this.nextINT();
        this.rcvInterrupts = this.nextUDINT();
        this.xmtInterrupts = this.nextUDINT();
        this.xmtTimeoutErr = this.nextUDINT();
        this.collisionErr = this.nextUDINT();
        this.missedPacketErr = this.nextUDINT();
        this.memoryErr = this.nextUDINT();
        this.restartCount = this.nextUDINT();
        this.rcvFrameErr = this.nextUDINT();
        this.rcvOverflowErr = this.nextUDINT();
        this.rcvCrcErr = this.nextUDINT();
        this.rcvBufferErr = this.nextUDINT();
        this.xmtBufferErr = this.nextUDINT();
        this.xmtSiloUnderflow = this.nextUDINT();
        this.xmtLateCollision = this.nextUDINT();
        this.xmitLostCarrier = this.nextUDINT();
        this.xmitRetries = this.nextUDINT();
        this.ipAddress = new short[]{this.nextUSHORT(), this.nextUSHORT(), this.nextUSHORT(), this.nextUSHORT()};
    }

    private final short nextUSHORT() {
        return (short)(this.data[this.idx++] & 0xFF);
    }

    private final short nextINT() {
        short s = (short)(this.data[this.idx + 1] << 8 | this.data[this.idx] & 0xFF);
        this.idx += 2;
        return s;
    }

    private final long nextUDINT() {
        long l = ((long)this.data[this.idx + 3] & 0xFFL) << 24 | ((long)this.data[this.idx + 2] & 0xFFL) << 16 | ((long)this.data[this.idx + 1] & 0xFFL) << 8 | (long)this.data[this.idx] & 0xFFL;
        this.idx += 4;
        return l;
    }
}

