/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.ftpsession;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.StringTokenizer;

public class FileInfo {
    static final int FILE = 0;
    static final int DIRECTORY = 1;
    private Date m_date;
    private int m_type;
    private String m_name;
    private int m_size;
    private int m_version;

    public FileInfo(Date date, int n, int n2, int n3, String string) {
        this.setDate(date);
        this.setType(n);
        this.setVersion(n2);
        this.setSize(n3);
        this.setName(string);
    }

    public FileInfo(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.charAt(0) == '0' || string2.charAt(0) == '1') {
                this.parseWindowsFormat(string);
            } else {
                stringTokenizer.nextToken();
                stringTokenizer.nextToken();
                try {
                    Integer.parseInt(stringTokenizer.nextToken());
                    this.parseUnixFormat(string);
                }
                catch (NumberFormatException numberFormatException) {
                    this.parseUnixFormat2(string);
                }
            }
        }
    }

    private void parseWindowsFormat(String string) {
        String string2 = null;
        String string3 = null;
        String string4 = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreElements()) {
            string4 = stringTokenizer.nextToken();
        }
        try {
            DateFormat dateFormat = DateFormat.getDateTimeInstance();
            this.setDate(DateFormat.getDateTimeInstance().parse(string3 + " " + string4));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            try {
                this.setSize(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                this.setType(1);
            }
        }
        if (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken("");
            if (string2.charAt(0) == ' ') {
                string2 = string2.substring(1);
            }
            this.setName(string2);
        }
    }

    private void parseUnixFormat(String string) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements() && (string2 = stringTokenizer.nextToken()).charAt(0) == 'd') {
            this.setType(1);
        }
        if (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            this.setVersion(Integer.parseInt(string2));
        }
        if (stringTokenizer.hasMoreElements()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreElements()) {
            String string3;
            String string4;
            string2 = stringTokenizer.nextToken("\r\n");
            if (string2.charAt(0) == ' ') {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2);
                string4 = stringTokenizer2.nextToken();
                string3 = stringTokenizer2.nextToken("\r\n").substring(1);
            } else {
                int n = string2.indexOf(32);
                string4 = string2.substring(0, n);
                string3 = string2.substring(n + 1);
            }
            if (!this.isDirectory()) {
                this.setSize(Integer.parseInt(string4));
            }
            this.setName(string3);
        }
    }

    private void parseUnixFormat2(String string) {
        Object object;
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        if (stringTokenizer.hasMoreElements() && (string2 = stringTokenizer.nextToken()).charAt(0) == 'd') {
            this.setType(1);
        }
        if (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            this.setVersion(Integer.parseInt(string2));
        }
        if (stringTokenizer.hasMoreElements()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreElements()) {
            stringTokenizer.nextToken();
        }
        if (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
            if (!this.isDirectory()) {
                this.setSize(Integer.parseInt(string2));
            }
        }
        string2 = "Jan";
        if (stringTokenizer.hasMoreElements()) {
            string2 = stringTokenizer.nextToken();
        }
        String string3 = "1";
        if (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
        }
        String string4 = "00:00";
        if (stringTokenizer.hasMoreElements()) {
            string4 = stringTokenizer.nextToken();
        }
        try {
            object = new SimpleDateFormat("MMM dd HH:mm", Locale.US);
            this.setDate(((DateFormat)object).parse(string2 + " " + string3 + " " + string4));
        }
        catch (ParseException parseException) {
            try {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MMM dd yyyy", Locale.US);
                this.setDate(simpleDateFormat.parse(string2 + " " + string3 + " " + string4));
            }
            catch (ParseException parseException2) {
                System.out.println("Syntax error parsing date: " + parseException2.getMessage());
                this.setDate(new Date());
            }
        }
        if (stringTokenizer.hasMoreElements()) {
            object = stringTokenizer.nextToken("\r\n");
            this.setName(((String)object).trim());
        }
    }

    public Date getDate() {
        return this.m_date;
    }

    public String getName() {
        return this.m_name;
    }

    private int getType() {
        return this.m_type;
    }

    public int getSize() {
        return this.m_size;
    }

    public int getVersion() {
        return this.m_version;
    }

    private void setDate(Date date) {
        this.m_date = date;
    }

    private void setType(int n) {
        this.m_type = n;
    }

    private void setName(String string) {
        this.m_name = new String(string);
    }

    private void setSize(int n) {
        this.m_size = n;
    }

    private void setVersion(int n) {
        this.m_version = n;
    }

    public boolean isDirectory() {
        return this.m_type == 1;
    }

    public String toString() {
        if (this.isDirectory()) {
            return "DIR " + this.getName();
        }
        return this.getSize() + " " + this.getName();
    }
}

