/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.namespace;

import com.schneiderautomation.ftpsession.FTPSession;
import com.schneiderautomation.ftpsession.FtpSessionException;
import com.schneiderautomation.misc.GlobalConfig;
import com.schneiderautomation.namespace.VarLookupInterface;
import com.schneiderautomation.namespace.VerInfo;
import com.schneiderautomation.vars.RegisterItem;
import com.schneiderautomation.vars.VarInfo;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class NameSpace
implements VarLookupInterface {
    protected String configName;
    protected Hashtable vars;
    protected Vector regs;
    protected VerInfo info;
    protected int access;
    protected boolean fUnity;
    protected Locale locale;

    public NameSpace() {
        this(GlobalConfig.getLocale());
    }

    public NameSpace(Locale locale) {
        this.locale = locale;
        this.clear();
    }

    public VerInfo getVerInfo() {
        return this.info;
    }

    public int getAccessLevel() {
        return this.access;
    }

    public VarInfo get(String string) {
        return (VarInfo)this.vars.get(string);
    }

    public boolean isReadOnly(String string, int n) {
        int n2;
        String string2;
        int n3;
        int n4;
        try {
            if (string.charAt(0) == '%') {
                int n5;
                n4 = 1;
                int n6 = n3 = Character.isDigit(string.charAt(2)) ? 2 : 3;
                if (this.fUnity && (n5 = string.lastIndexOf(46)) > 0) {
                    string = string.substring(0, n5);
                }
            } else {
                n4 = 0;
                n3 = 1;
            }
            string2 = string.substring(n4, n3);
            n2 = Integer.parseInt(string.substring(n3));
            if (this.fUnity) {
                string2 = NameSpace.normalizeRegion(string2);
            }
        }
        catch (Exception exception) {
            return true;
        }
        n3 = this.regs.size();
        for (n4 = 0; n4 < n3; ++n4) {
            RegisterItem registerItem = (RegisterItem)this.regs.elementAt(n4);
            if (!registerItem.contains(string2, n2, n)) continue;
            return false;
        }
        return true;
    }

    public Enumeration getSymbols() {
        return this.vars.elements();
    }

    public int getSymbolCount() {
        return this.vars.size();
    }

    public String getConfigName() {
        return this.configName;
    }

    public void init(InetAddress inetAddress) throws IOException {
        this.init(inetAddress.getHostName(), "sysdiag", "factorycast@schneider");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(String string, String string2, String string3) throws IOException {
        this.clear();
        try {
            FTPSession fTPSession = new FTPSession(this.locale);
            fTPSession.connectHost(string);
            try {
                fTPSession.login(string2, string3);
                fTPSession.setTransferMode(1);
                BufferedInputStream bufferedInputStream = fTPSession.getFile(GlobalConfig.getFtpRoot() + "/namspace.dat");
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(bufferedInputStream));
                try {
                    this.init(bufferedReader);
                }
                finally {
                    bufferedReader.close();
                    fTPSession.readComplete();
                }
            }
            catch (IOException iOException) {
                this.clear();
                throw iOException;
            }
            catch (FtpSessionException ftpSessionException) {
                this.clear();
                throw ftpSessionException;
            }
            finally {
                try {
                    fTPSession.quit();
                }
                catch (Exception exception) {}
            }
        }
        catch (FtpSessionException ftpSessionException) {
            throw new IOException(ftpSessionException.getMessage());
        }
    }

    protected void clear() {
        this.vars = new Hashtable();
        this.regs = new Vector();
        this.info = null;
        this.access = 0;
        this.fUnity = false;
        this.configName = "";
    }

    protected void init(BufferedReader bufferedReader) throws IOException {
        int n;
        this.info = new VerInfo();
        if (!this.info.readData(bufferedReader)) {
            this.info = null;
        }
        int n2 = Integer.parseInt(bufferedReader.readLine());
        for (n = 0; n < n2; ++n) {
            VarInfo varInfo = new VarInfo();
            varInfo.readData(bufferedReader);
            this.vars.put(varInfo.getName(), varInfo);
        }
        n = Integer.parseInt(bufferedReader.readLine());
        for (int i = 0; i < n; ++i) {
            RegisterItem registerItem = new RegisterItem();
            registerItem.readData(bufferedReader);
            this.regs.addElement(registerItem);
        }
        this.configName = bufferedReader.readLine();
        try {
            this.access = Integer.parseInt(bufferedReader.readLine());
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.fUnity = Boolean.valueOf(bufferedReader.readLine());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static String normalizeRegion(String string) {
        if (string.equals("MD") || string.equals("MF") || string.equals("4")) {
            return "MW";
        }
        if (string.equals("SD") || string.equals("SF")) {
            return "SW";
        }
        if (string.equals("0")) {
            return "M";
        }
        return string;
    }
}

