/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag;

import com.schneiderautomation.sysdiag.Etching;
import com.schneiderautomation.sysdiag.Orientation;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;

public class Separator
extends Component {
    private static Etching defaultEtching = Etching.IN;
    private static int defaultThickness = 2;
    private Etching etching;
    private int thickness;

    public Separator() {
        this(defaultThickness, defaultEtching);
    }

    public Separator(int n) {
        this(n, defaultEtching);
    }

    public Separator(Etching etching) {
        this(defaultThickness, etching);
    }

    public Separator(int n, Etching etching) {
        this.etching = etching;
        this.thickness = n;
        this.setSize(n, n);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        SystemColor systemColor = SystemColor.controlLtHighlight;
        SystemColor systemColor2 = SystemColor.controlShadow;
        if (this.etching == Etching.IN) {
            if (dimension.width > dimension.height) {
                this.paintHorizontal(graphics, dimension, systemColor2, systemColor);
            } else {
                this.paintVertical(graphics, dimension, systemColor2, systemColor);
            }
        } else if (dimension.width > dimension.height) {
            this.paintHorizontal(graphics, dimension, systemColor, systemColor2);
        } else {
            this.paintVertical(graphics, dimension, systemColor, systemColor2);
        }
    }

    public String paramString() {
        Dimension dimension = this.getSize();
        Orientation orientation = dimension.width > dimension.height ? Orientation.HORIZONTAL : Orientation.VERTICAL;
        return super.paramString() + "thickness=" + this.thickness + "," + this.etching + "," + orientation;
    }

    private void paintHorizontal(Graphics graphics, Dimension dimension, Color color, Color color2) {
        int n;
        graphics.setColor(color);
        for (n = dimension.height / 2 - this.thickness / 2; n < dimension.height / 2; ++n) {
            graphics.drawLine(0, n, dimension.width, n);
        }
        graphics.setColor(color2);
        for (n = dimension.height / 2; n < dimension.height / 2 + this.thickness / 2; ++n) {
            graphics.drawLine(0, n, dimension.width, n);
        }
    }

    private void paintVertical(Graphics graphics, Dimension dimension, Color color, Color color2) {
        int n;
        graphics.setColor(color);
        for (n = dimension.width / 2 - this.thickness / 2; n < dimension.width / 2; ++n) {
            graphics.drawLine(n, 0, n, dimension.height);
        }
        graphics.setColor(color2);
        for (n = dimension.width / 2; n < dimension.width / 2 + this.thickness / 2; ++n) {
            graphics.drawLine(n, 0, n, dimension.height);
        }
    }
}

