/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag;

import com.schneiderautomation.sysdiag.Assert;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;

public class SysDiagUtil {
    public static Dialog getDialog(Component component) {
        if (component instanceof Dialog) {
            return (Dialog)component;
        }
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Dialog)) continue;
            return (Dialog)component;
        }
        return null;
    }

    public static Frame getFrame(Component component) {
        if (component instanceof Frame) {
            return (Frame)component;
        }
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Frame)) continue;
            return (Frame)component;
        }
        return null;
    }

    public static Applet getApplet(Component component) {
        if (component instanceof Applet) {
            return (Applet)component;
        }
        while ((component = component.getParent()) != null) {
            if (!(component instanceof Applet)) continue;
            return (Applet)component;
        }
        return null;
    }

    public static void waitForImage(Component component, Image image) {
        MediaTracker mediaTracker = new MediaTracker(component);
        try {
            mediaTracker.addImage(image, 0);
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public static void wallPaper(Component component, Graphics graphics, Image image) {
        Dimension dimension = component.getSize();
        SysDiagUtil.waitForImage(component, image);
        int n = image.getWidth(component);
        int n2 = image.getHeight(component);
        Assert.notFalse(n != -1 && n2 != -1);
        for (int i = 0; i < dimension.width; i += n) {
            for (int j = 0; j < dimension.height; j += n2) {
                graphics.drawImage(image, i, j, component);
            }
        }
    }

    public static void stretchImage(Component component, Graphics graphics, Image image) {
        Dimension dimension = component.getSize();
        SysDiagUtil.waitForImage(component, image);
        graphics.drawImage(image, 0, 0, dimension.width, dimension.height, component);
    }

    public static void setCursor(int n, Component component) {
        component.setCursor(Cursor.getPredefinedCursor(n));
    }
}

