/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.MonitorNumber;
import com.schneiderautomation.sysdiag.qbf.CPUConfigApplet;
import com.schneiderautomation.sysdiag.qbf.LocalCPUStrings;
import com.schneiderautomation.sysdiag.qbf.PageA0;
import com.schneiderautomation.sysdiag.qbf.PlcInfo;
import com.schneiderautomation.sysdiag.qbf.QuantumCPUInfo;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

class CPUHeaderPanel
extends Panel
implements PropertyChangeListener {
    private static final Color myLightGray = new Color(226, 226, 226);
    private static final Font lclfont = new Font("SansSerif", 1, 12);
    private static final int TEXTWIDTH = 11;
    private static final short DIMAWARE = 8192;
    private static final short SNGL_SWP = 512;
    private static final short BATT_OK = 16;
    private Applet applet;
    private TextField statusField;
    private TextField batteryField;
    private TextField loggedInField;

    CPUHeaderPanel(PlcInfo plcInfo, CPUConfigApplet cPUConfigApplet, CommBean commBean) {
        this.applet = cPUConfigApplet;
        this.setBackground(Color.white);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.setLayout(gridBagLayout);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 1;
        boolean bl = plcInfo.status == 4;
        Color color = bl ? Color.magenta.darker() : Color.black;
        this.createLabel(LocalCPUStrings.getString("S_STATUS"), gridBagConstraints);
        this.statusField = this.createField(11, myLightGray, gridBagConstraints, color);
        this.createLabel(LocalCPUStrings.getString("S_REFERENCE"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        TextField textField = this.createField(11, myLightGray, gridBagConstraints, color);
        textField.setText(QuantumCPUInfo.getCpuName(commBean));
        gridBagConstraints.gridwidth = 1;
        this.createLabel(LocalCPUStrings.getString("S_BATTERY"), gridBagConstraints);
        this.batteryField = this.createField(11, myLightGray, gridBagConstraints, color);
        this.createLabel(LocalCPUStrings.getString("S_PRODTYPE"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        TextField textField2 = this.createField(11, myLightGray, gridBagConstraints, color);
        textField2.setText("Quantum");
        gridBagConstraints.gridwidth = 1;
        this.createLabel(LocalCPUStrings.getString("S_RACK"), gridBagConstraints);
        TextField textField3 = this.createField(11, myLightGray, gridBagConstraints, color);
        textField3.setText("1");
        this.createLabel(LocalCPUStrings.getString("S_EXECID"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        TextField textField4 = this.createField(11, myLightGray, gridBagConstraints, color);
        textField4.setText(Integer.toHexString(plcInfo.execID));
        gridBagConstraints.gridwidth = 1;
        this.createLabel(LocalCPUStrings.getString("S_SLOT"), gridBagConstraints);
        TextField textField5 = this.createField(11, myLightGray, gridBagConstraints, color);
        this.createLabel(LocalCPUStrings.getString("S_LOGGEDIN"), gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.loggedInField = this.createField(11, myLightGray, gridBagConstraints, color);
        if (bl) {
            String string = LocalCPUStrings.getString("S_UNKNOWN");
            this.statusField.setText(string);
            this.batteryField.setText(string);
            this.loggedInField.setText(string);
            textField5.setText(string);
        } else {
            PageA0 pageA0 = new PageA0(commBean);
            if (pageA0.CPUSlot > 0 && pageA0.CPUSlot <= 16) {
                textField5.setText(Short.toString(pageA0.CPUSlot));
            } else {
                textField5.setText("?");
            }
            MonitorNumber monitorNumber = new MonitorNumber(commBean.getAdaptor());
            monitorNumber.setAddress("800101");
            monitorNumber.setDatatype((short)5);
            monitorNumber.setQuantity((short)42);
            monitorNumber.addPropertyChangeListener((PropertyChangeListener)this);
            monitorNumber.register();
        }
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        String string2 = propertyChangeEvent.getPropertyName();
        if (string2.equals("values")) {
            boolean bl;
            boolean bl2;
            boolean bl3;
            Number[] numberArray = (Number[])propertyChangeEvent.getNewValue();
            int n = numberArray[0].intValue();
            int n2 = numberArray[4].intValue();
            int n3 = numberArray[41].intValue();
            boolean bl4 = bl3 = (n2 & 0x2000) == 8192;
            if (n2 > 0) {
                if (bl3) {
                    this.statusField.setForeground(Color.magenta.darker());
                    this.statusField.setText(LocalCPUStrings.getString("S_NOTCFGD"));
                } else {
                    this.statusField.setForeground(Color.red.darker());
                    this.statusField.setText(LocalCPUStrings.getString("S_STOPPED"));
                }
            } else if ((n & 0x200) == 512) {
                this.statusField.setForeground(Color.yellow.darker());
                this.statusField.setText(LocalCPUStrings.getString("S_SNGLSWP"));
            } else {
                this.statusField.setForeground(Color.green.darker());
                this.statusField.setText(LocalCPUStrings.getString("S_RUNNING"));
            }
            boolean bl5 = bl2 = (n & 0x10) != 16;
            if (bl2) {
                this.batteryField.setForeground(Color.green.darker());
                this.batteryField.setText(LocalCPUStrings.getString("S_OK"));
            } else {
                this.batteryField.setForeground(Color.red.darker());
                this.batteryField.setText(LocalCPUStrings.getString("S_LOW"));
            }
            boolean bl6 = bl = n3 > 0;
            if (bl) {
                this.loggedInField.setForeground(Color.black);
                this.loggedInField.setText(LocalCPUStrings.getString("S_YES"));
            } else {
                this.loggedInField.setForeground(Color.black);
                this.loggedInField.setText(LocalCPUStrings.getString("S_NO"));
            }
        } else if (string2.equals("subscribeStatus") && (string = (String)propertyChangeEvent.getNewValue()).length() > 0) {
            this.applet.showStatus(string);
            this.statusField.setForeground(Color.magenta);
            this.batteryField.setForeground(Color.magenta);
            this.loggedInField.setForeground(Color.magenta);
        }
    }

    private void createLabel(String string, GridBagConstraints gridBagConstraints) {
        Label label = new Label(string, 2);
        label.setFont(lclfont);
        this.add((Component)label, gridBagConstraints);
    }

    private TextField createField(int n, Color color, GridBagConstraints gridBagConstraints, Color color2) {
        TextField textField = new TextField(n);
        textField.setFont(lclfont);
        textField.setEditable(false);
        textField.setBackground(color);
        textField.setForeground(color2);
        this.add((Component)textField, gridBagConstraints);
        return textField;
    }
}

