/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.GetUInt;
import com.schneiderautomation.factorycast.GetUShort;
import com.schneiderautomation.sysdiag.MessageDisplay;
import com.schneiderautomation.sysdiag.qbf.MessageStrings;
import java.applet.Applet;

class ConfigExtension {
    private static final int MAXNOES = 6;
    private static final int STATEOFFSET = 2;
    private static final int SLOTOFFSET = 6;
    private static final int FRAMEOFFSET = 7;
    private static final int IPOFFSET = 8;
    private static final int MASKOFFSET = 12;
    private static final int GTWYOFFSET = 16;
    private static final int MAXDPS = 6;
    private static final int DP_SLOTOFFSET = 4;
    private short counter = 0;
    private short[] noeSlotList = new short[6];
    private String[] ipAddrList = new String[6];
    private String[] subnetList = new String[6];
    private String[] gtwyList = new String[6];
    private short[] profibusSlotList = new short[0];
    private CommBean comm;
    private Applet applet;

    ConfigExtension(CommBean commBean, Applet applet) {
        this.comm = commBean;
        this.applet = applet;
        GetUInt getUInt = new GetUInt(commBean.getServer());
        getUInt.setAddress("800049");
        int n = 0;
        try {
            getUInt.readValues();
            n = getUInt.getValue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (n != 0) {
            int n2;
            do {
                try {
                    getUInt.setAddress("8" + n);
                    getUInt.setQuantity((short)3);
                    getUInt.readValues();
                    int[] nArray = getUInt.getValues();
                    n2 = nArray[0];
                    if (n2 <= 0) continue;
                    int n3 = nArray[2];
                    if (n3 == 7) {
                        this.parseNOEData(n, n2);
                    } else if (n3 == 6) {
                        this.parseProfibusData(n);
                    }
                    n += n2;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    new MessageDisplay(applet, MessageStrings.getString("M_COMMERR"), exception.getMessage());
                    break;
                }
            } while (n2 > 0);
        }
    }

    private void parseProfibusData(int n) {
        try {
            GetUShort getUShort = new GetUShort(this.comm.getServer());
            getUShort.setAddress("8" + (n + 3));
            getUShort.setQuantity((short)6);
            getUShort.readValues();
            this.profibusSlotList = getUShort.getValues();
            for (int i = 0; i < this.profibusSlotList.length; ++i) {
                if (this.profibusSlotList[i] <= 0) continue;
                int n2 = i;
                this.profibusSlotList[n2] = (short)(this.profibusSlotList[n2] + 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new MessageDisplay(this.applet, MessageStrings.getString("M_COMMERR"), exception.getMessage());
        }
    }

    private void parseNOEData(int n, int n2) {
        this.counter = 0;
        try {
            GetUShort getUShort = new GetUShort(this.comm.getServer());
            getUShort.setAddress("8" + n);
            getUShort.setQuantity((short)(n2 * 2));
            getUShort.readValues();
            short[] sArray = getUShort.getValues();
            for (int i = 0; i < (n2 - 4) * 2; i += 32) {
                this.ipAddrList[this.counter] = sArray[i + 8 + 1] + "." + sArray[i + 8] + "." + sArray[i + 8 + 3] + "." + sArray[i + 8 + 2];
                this.subnetList[this.counter] = sArray[i + 12 + 3] + "." + sArray[i + 12 + 2] + "." + sArray[i + 12 + 1] + "." + sArray[i + 12];
                this.gtwyList[this.counter] = sArray[i + 16 + 1] + "." + sArray[i + 16] + "." + sArray[i + 16 + 3] + "." + sArray[i + 16 + 2];
                this.noeSlotList[this.counter] = sArray[i + 6];
                this.counter = (short)(this.counter + 1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            new MessageDisplay(this.applet, MessageStrings.getString("M_COMMERR"), exception.getMessage());
            this.counter = 0;
        }
    }

    short[] getProfibusSlotList() {
        return this.profibusSlotList;
    }

    short[] getNOESlotList() {
        return this.noeSlotList;
    }

    int getNOECount() {
        return this.counter;
    }

    short getNOESlot(int n) {
        if (n >= 0 && n < 6) {
            return this.noeSlotList[n];
        }
        return 99;
    }

    String getIpAddr(int n) {
        if (n >= 0 && n < 6) {
            return this.ipAddrList[n];
        }
        return null;
    }

    String getGtwy(int n) {
        if (n >= 0 && n < 6) {
            return this.gtwyList[n];
        }
        return null;
    }

    String getSubnet(int n) {
        if (n >= 0 && n < 6) {
            return this.subnetList[n];
        }
        return null;
    }
}

