/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.MonitorBits;
import com.schneiderautomation.sysdiag.qbf.DigitalAddrPanel;
import com.schneiderautomation.sysdiag.qbf.DigitalDataPanel;
import com.schneiderautomation.sysdiag.qbf.DigitalListener;
import com.schneiderautomation.sysdiag.qbf.ModuleDescriptor;
import com.schneiderautomation.sysdiag.qbf.ThreeDBorder;
import com.schneiderautomation.sysdiag.qbf.TrafficCop;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;

public class DigitalPanel
extends Panel
implements ActionListener {
    private static final Color myLightYellow = new Color(240, 243, 187);
    private static final int number = 32;
    private static TrafficCop myCop;
    private Label[] labelArray = new Label[96];
    private MonitorBits monitorInBean = null;
    private MonitorBits monitorOutBean = null;
    private DigitalListener digitalInListener;
    private DigitalListener digitalOutListener;
    private ModuleDescriptor modDesc = new ModuleDescriptor();
    private CommBean comm;
    private Label l1;
    private DigitalDataPanel dataPanel;
    private DigitalDataPanel dataPanel1;
    private DigitalDataPanel dataPanel2;
    private Button backbutton;
    private GridBagConstraints constraints;
    private GridBagLayout gbLayout;
    private int index = 0;
    ThreeDBorder border;
    ThreeDBorder border1;
    ThreeDBorder border2;
    Label in1 = new Label("Input Range xxxxxx - xxxxxx", 1);
    Label out1 = new Label("Output Range xxxxxx - xxxxxx", 1);

    public DigitalPanel(CommBean commBean, TrafficCop trafficCop, Button button) {
        this.comm = commBean;
        myCop = trafficCop;
        this.backbutton = button;
        if (myCop == null) {
            myCop = new TrafficCop(commBean);
        }
        this.setBackground(myLightYellow);
        this.constraints = new GridBagConstraints();
        this.gbLayout = new GridBagLayout();
        this.setLayout(this.gbLayout);
        Panel panel = new Panel();
        this.l1 = new Label("Digital Screen  -  Drop # xx Rack # xx Slot # xxx ", 1);
        this.l1.setFont(new Font("TimesRoman", 1, 16));
        panel.add(this.l1);
        this.constraints.anchor = 10;
        this.constraints.fill = 0;
        this.constraints.gridx = 1;
        this.constraints.gridy = 1;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.add((Component)panel, this.constraints);
        this.dataPanel = new DigitalDataPanel(this.labelArray, 32, 0);
        this.dataPanel1 = new DigitalDataPanel(this.labelArray, 64, 32);
        this.dataPanel2 = new DigitalDataPanel(this.labelArray, 96, 64);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        panel2.setBackground(myLightYellow);
        this.border = new ThreeDBorder(this.dataPanel, 4, 0);
        this.border1 = new ThreeDBorder(this.dataPanel1, 4, 0);
        this.border2 = new ThreeDBorder(this.dataPanel2, 4, 0);
        panel2.add((Component)this.border, "Center");
        panel2.add((Component)this.border1, "Center");
        panel2.add((Component)this.border2, "Center");
        this.border.setVisible(true);
        this.border1.setVisible(false);
        this.border2.setVisible(false);
        ++this.constraints.gridy;
        this.add((Component)panel2, this.constraints);
        DigitalAddrPanel digitalAddrPanel = new DigitalAddrPanel(this.in1, this.out1);
        ++this.constraints.gridy;
        this.constraints.fill = 2;
        this.add((Component)digitalAddrPanel, this.constraints);
        button.addActionListener(this);
    }

    public void showActualModule(short s, short s2, short s3, short s4, CommBean commBean, short s5, String string) {
        boolean bl;
        String string2;
        String string3;
        int n;
        boolean bl2;
        int n2 = 0;
        this.border.setVisible(true);
        this.border1.setVisible(false);
        this.border2.setVisible(false);
        this.l1.setText(string + ": Drop " + s2 + "  Rack " + s3 + "  Slot " + s4);
        this.modDesc = myCop.getModuleIO(s, s2, s3, s4, s5);
        if (this.modDesc == null) {
            for (int i = 0; i < this.labelArray.length; ++i) {
                this.labelArray[i].setText("?");
                this.labelArray[i].setForeground(Color.magenta);
            }
            return;
        }
        int n3 = this.modDesc.numInputBytes * 8;
        int n4 = this.modDesc.numOutputBytes * 8;
        if (n4 > 0) {
            bl2 = true;
            if (this.modDesc.outputsReference == 1) {
                n = n4;
                string3 = String.valueOf(1000000 + this.modDesc.outStartReference);
                string2 = String.valueOf(1000000 + this.modDesc.outStartReference + n - 1);
                this.out1.setText("Output Range " + string3.substring(1) + " - " + string2.substring(1));
            } else {
                n = (n4 + 15) / 16;
                string3 = String.valueOf(400000 + this.modDesc.outStartReference);
                string2 = String.valueOf(400000 + this.modDesc.outStartReference + n - 1);
                this.out1.setText("Output Range " + string3 + " - " + string2);
            }
        } else {
            bl2 = false;
            this.out1.setText("");
        }
        if (n3 > 0) {
            bl = true;
            if (this.modDesc.inputsReference == 0) {
                n = n3;
                string3 = String.valueOf(100000 + this.modDesc.inStartReference);
                string2 = String.valueOf(100000 + this.modDesc.inStartReference + n - 1);
                this.in1.setText("Input Range " + string3 + " - " + string2);
            } else {
                n = (n3 + 15) / 16;
                string3 = String.valueOf(300000 + this.modDesc.inStartReference);
                string2 = String.valueOf(300000 + this.modDesc.inStartReference + n - 1);
                this.in1.setText("Input Range " + string3 + " - " + string2);
            }
        } else {
            bl = false;
            this.in1.setText("");
        }
        if (n3 > 96 || n4 > 96) {
            if (n4 > 96) {
                n4 = 96;
                bl = false;
            } else {
                n3 = 96;
                bl2 = false;
            }
        } else if (n3 + n4 > 96) {
            bl = false;
        }
        if (bl) {
            if (n3 > 0 && n3 <= 32) {
                n3 = 32;
                this.border.setVisible(true);
            } else if (n3 > 32 && n3 <= 64) {
                n3 = 64;
                this.border.setVisible(true);
                this.border1.setVisible(true);
            } else if (n3 > 64 && n3 <= 96) {
                n3 = 96;
                this.border.setVisible(true);
                this.border1.setVisible(true);
                this.border2.setVisible(true);
            }
        } else if (n4 > 0 && n4 <= 32) {
            n4 = 32;
            this.border.setVisible(true);
        } else if (n4 > 32 && n4 <= 64) {
            n4 = 64;
            this.border.setVisible(true);
            this.border1.setVisible(true);
        } else if (n4 > 64 && n4 <= 96) {
            n4 = 96;
            this.border.setVisible(true);
            this.border1.setVisible(true);
            this.border2.setVisible(true);
        }
        for (n = 0; n < this.labelArray.length; ++n) {
            this.labelArray[n].setForeground(Color.black);
        }
        if (this.monitorOutBean != null) {
            this.monitorOutBean.deregister();
            if (this.digitalOutListener != null) {
                this.monitorOutBean.removePropertyChangeListener((PropertyChangeListener)this.digitalOutListener);
            }
        }
        if (this.monitorInBean != null) {
            this.monitorInBean.deregister();
            if (this.digitalInListener != null) {
                this.monitorInBean.removePropertyChangeListener((PropertyChangeListener)this.digitalInListener);
            }
        }
        if (bl2) {
            n2 = n4 <= 16 && n3 <= 16 ? 16 : (n4 + 7) / 8 * 8;
            for (n = 0; n < n4; ++n) {
                this.labelArray[n].setText(Integer.toString(n + 1));
                this.labelArray[n].setForeground(Color.darkGray);
            }
            if (this.modDesc.outputsReference == 1 || this.modDesc.outputsReference == 3) {
                this.digitalOutListener = new DigitalListener(this.labelArray, n4, 0, this.modDesc.outputsReference == 3);
                this.monitorOutBean = new MonitorBits(commBean.getAdaptor());
                if (this.modDesc.outputsReference == 1) {
                    this.monitorOutBean.setAddress("0" + Integer.toString(this.modDesc.outStartReference));
                    this.monitorOutBean.setDatatype((short)1);
                    this.monitorOutBean.setQuantity((short)n4);
                } else {
                    this.monitorOutBean.setAddress("4" + Integer.toString(this.modDesc.outStartReference));
                    this.monitorOutBean.setDatatype((short)5);
                    this.monitorOutBean.setQuantity((short)((n4 + 15) / 16));
                }
                this.monitorOutBean.addPropertyChangeListener((PropertyChangeListener)this.digitalOutListener);
                this.monitorOutBean.register();
            }
        }
        if (bl) {
            for (n = 0; n < n3; ++n) {
                int n5 = n + n2;
                if (n5 >= this.labelArray.length) continue;
                this.labelArray[n5].setText(Integer.toString(n + 1));
                this.labelArray[n5].setForeground(Color.darkGray);
            }
            if (this.modDesc.inputsReference == 0 || this.modDesc.inputsReference == 2) {
                this.digitalInListener = new DigitalListener(this.labelArray, n3, n2, this.modDesc.inputsReference == 2);
                this.monitorInBean = new MonitorBits(commBean.getAdaptor());
                if (this.modDesc.inputsReference == 0) {
                    this.monitorInBean.setAddress("1" + Integer.toString(this.modDesc.inStartReference));
                    this.monitorInBean.setDatatype((short)1);
                    this.monitorInBean.setQuantity((short)n3);
                } else {
                    this.monitorInBean.setAddress("3" + Integer.toString(this.modDesc.inStartReference));
                    this.monitorInBean.setDatatype((short)5);
                    this.monitorInBean.setQuantity((short)((n3 + 15) / 16));
                }
                this.monitorInBean.addPropertyChangeListener((PropertyChangeListener)this.digitalInListener);
                this.monitorInBean.register();
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.monitorInBean != null) {
            this.monitorInBean.deregister();
            this.monitorInBean.removePropertyChangeListener((PropertyChangeListener)this.digitalInListener);
            this.monitorInBean = null;
            this.digitalInListener = null;
        }
        if (this.monitorOutBean != null) {
            this.monitorOutBean.deregister();
            this.monitorOutBean.removePropertyChangeListener((PropertyChangeListener)this.digitalOutListener);
            this.monitorOutBean = null;
            this.digitalOutListener = null;
        }
    }
}

