/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.sysdiag.qbf.DIOModuleHealth;
import com.schneiderautomation.sysdiag.qbf.DioDropHdrListener;
import com.schneiderautomation.sysdiag.qbf.DioStrings;
import com.schneiderautomation.sysdiag.qbf.ModuleIDs;
import com.schneiderautomation.sysdiag.qbf.PageA0;
import com.schneiderautomation.sysdiag.qbf.TrafficCop;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

class DioDropsPanel
extends Panel {
    private static final short MAX_DIO_HEADS = 3;
    private static final short MAX_NO_OF_DROPS = 64;
    private static final short MAX_RACKS = 1;
    private static final short MAX_NO_OF_MODULES = 16;
    private static final short TEXTFIELDSIZE = 10;
    private static final short DIODROPTYPE = 2;
    private static final short BOTH = 2;
    private static final short INPUT = 1;
    private static final short OUTPUT = 0;
    private static final short MAIN = 0;
    private static final short DROP = 1;
    private static final short MODULE = 2;
    private static PageA0 pageA0;
    private static TrafficCop tCop;
    private static int trafficcopaddress;
    private static short trafficcoplength;
    private static short totalnumberofdrops;
    private static short[] numberofdrops;
    private static short[] headslotnumbers;
    private static short cpuHeadSlot;
    private static int NOM1Slot;
    private static int NOM2Slot;
    private static short CPUdropnumberindex;
    private static short NOM1dropnumberindex;
    private static short NOM2dropnumberindex;
    private static short[][] dropnumbers;
    private static short[][] configuredmodules;
    private static short[][] racknumbers;
    private static short[][] readflgs;
    private static short[][] highestslotnumber;
    private static short[][][] moduleracknumber;
    private static short[][][] moduleslotnumber;
    private static short[][][] moduleinputs;
    private static short[][][] moduleoutputs;
    private static boolean[][][] analog;
    private static short[][][] iotype;
    private static short[][][] modulepersonality;
    private static String[][][] personalitystrings;
    private static String[][][] descstrings;
    private static String[] maintextarray;
    private static String[] droptextarray;
    private static String[] moduletextarray;
    private TextField status = new TextField(10);
    private TextField rack = new TextField(10);
    private TextField slot = new TextField(10);
    private TextField reference = new TextField(10);
    private TextField product = new TextField(10);
    private TextField drm = new TextField(10);
    private Label[] labels = new Label[6];
    private ModuleIDs modIDList;
    private String headname;
    private short headselected;
    DIOModuleHealth modHealth;

    DioDropsPanel(String string, Applet applet, CommBean commBean, ModuleIDs moduleIDs, int n, String string2, TrafficCop trafficCop) {
        this.modIDList = moduleIDs;
        this.headselected = (short)n;
        this.headname = string2;
        tCop = trafficCop;
        this.initmaintextarray();
        this.initdroptextarray();
        this.initmoduletextarray();
        if (pageA0 == null) {
            pageA0 = new PageA0(commBean);
        }
        Font font = new Font("SansSerif", 1, 12);
        Color color = new Color(226, 226, 226);
        this.status.setBackground(color);
        this.status.setFont(font);
        this.status.setEditable(false);
        this.rack.setBackground(color);
        this.rack.setFont(font);
        this.rack.setEditable(false);
        this.slot.setBackground(color);
        this.slot.setFont(font);
        this.slot.setEditable(false);
        this.reference.setBackground(color);
        this.reference.setFont(font);
        this.reference.setEditable(false);
        this.product.setBackground(color);
        this.product.setFont(font);
        this.product.setEditable(false);
        this.drm.setBackground(color);
        this.drm.setFont(font);
        this.drm.setEditable(false);
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new Label();
            this.labels[i].setFont(font);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.status, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.rack, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.slot, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.reference, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.product, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.drm, gridBagConstraints);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.labels[0], gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.labels[1], gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.labels[2], gridBagConstraints);
        gridBagConstraints.insets.left = 30;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.labels[3], gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.labels[4], gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.labels[5], gridBagConstraints);
        applet.showStatus("Accessing Traffic Cop...");
        this.recordTrafficCop(commBean);
        applet.showStatus("Reading Distributed I/O health...");
        this.modHealth = new DIOModuleHealth(commBean);
        applet.showStatus("         ");
    }

    private void initmoduletextarray() {
        if (moduletextarray == null) {
            moduletextarray = new String[6];
            DioDropsPanel.moduletextarray[0] = DioStrings.getString("STATUS");
            DioDropsPanel.moduletextarray[1] = DioStrings.getString("RACK");
            DioDropsPanel.moduletextarray[2] = DioStrings.getString("SLOT");
            DioDropsPanel.moduletextarray[3] = DioStrings.getString("REFERENCE");
            DioDropsPanel.moduletextarray[4] = DioStrings.getString("INPUTSTARTREF");
            DioDropsPanel.moduletextarray[5] = DioStrings.getString("OUTPUTSTARTREF");
        }
    }

    private void initdroptextarray() {
        if (droptextarray == null) {
            droptextarray = new String[6];
            DioDropsPanel.droptextarray[0] = DioStrings.getString("STATUS");
            DioDropsPanel.droptextarray[1] = DioStrings.getString("RACK");
            DioDropsPanel.droptextarray[2] = DioStrings.getString("HEADSLOT");
            DioDropsPanel.droptextarray[3] = DioStrings.getString("READONLY");
            DioDropsPanel.droptextarray[4] = DioStrings.getString("PRODUCTTYPE");
            DioDropsPanel.droptextarray[5] = DioStrings.getString("NUMBEROFMODULES");
        }
    }

    private void initmaintextarray() {
        if (maintextarray == null) {
            maintextarray = new String[6];
            DioDropsPanel.maintextarray[0] = DioStrings.getString("STATUS");
            DioDropsPanel.maintextarray[1] = DioStrings.getString("RACK");
            DioDropsPanel.maintextarray[2] = DioStrings.getString("HEADSLOT");
            DioDropsPanel.maintextarray[3] = DioStrings.getString("REFERENCE");
            DioDropsPanel.maintextarray[4] = DioStrings.getString("PRODUCTTYPE");
            DioDropsPanel.maintextarray[5] = DioStrings.getString("NUMBEROFDROPS");
        }
    }

    void setMultiDropData(CommBean commBean, short s) {
        this.status.setText(DioStrings.getString("OK"));
        this.status.setForeground(Color.green.darker());
        this.rack.setText("1");
        this.slot.setText(new Integer(this.headselected).toString());
        this.reference.setText(this.headname);
        this.product.setText(DioStrings.getString("QUANTUM"));
        this.drm.setText(new Integer(s).toString());
        this.doLabels(0);
    }

    void setDropData(int n, int n2, int n3) {
        int n4 = n - 1;
        int n5 = n2 - 1;
        if (n2 != 0) {
            this.status.setText(DioStrings.getString("OK"));
            this.status.setForeground(Color.green.darker());
            this.rack.setText(new Integer(racknumbers[n4][n5]).toString());
            this.rack.setForeground(Color.black);
            this.product.setText(DioStrings.getString("QUANTUM"));
            this.product.setForeground(Color.black);
            this.drm.setText(new Integer(this.getNumberOfModules((short)n4, (short)n5)).toString());
            this.drm.setForeground(Color.black);
            short s = readflgs[n4][n5];
            if (s == 1) {
                this.reference.setText("TRUE ");
            } else {
                this.reference.setText("FALSE ");
            }
            this.reference.setForeground(Color.black);
            this.slot.setText(new Integer(headslotnumbers[n4]).toString());
            this.slot.setForeground(Color.black);
        }
        this.doLabels(1);
    }

    void setModuleData(CommBean commBean, short s, short s2, short s3) {
        short s4 = this.getHeadSlotIndex(this.headselected);
        this.initmodulevars(commBean, s4, s, s3);
        this.doLabels(2);
    }

    short getHighestSlotNumber(short s, short s2) {
        return highestslotnumber[s][s2];
    }

    short getHeadSlotIndex(short s) {
        for (int i = 0; i < 3; ++i) {
            if (s != headslotnumbers[i]) continue;
            return (short)i;
        }
        return -1;
    }

    short getCPUHeadSlot() {
        return cpuHeadSlot;
    }

    short getHeadSlot(short s) {
        return headslotnumbers[s];
    }

    short getSlotNumber(short s, short s2, short s3) {
        return moduleslotnumber[s][s2][s3];
    }

    short getRackNumber(short s, short s2, short s3) {
        return moduleracknumber[s][s2][s3];
    }

    short getDropNumber(short s, short s2) {
        return dropnumbers[s][s2];
    }

    TrafficCop getTrafficCop() {
        return tCop;
    }

    short getNumberOfDrops(short s) {
        return numberofdrops[s];
    }

    short getNumberOfModules(short s, short s2) {
        if (s2 >= 0) {
            return configuredmodules[s][s2];
        }
        return 0;
    }

    String getPersonality(short s, short s2, short s3) {
        if (s2 >= 0 && s3 >= 0) {
            return personalitystrings[s][s2][s3];
        }
        return null;
    }

    String getDesc(short s, short s2, short s3) {
        if (s2 >= 0 && s3 >= 0) {
            return descstrings[s][s2][s3];
        }
        return null;
    }

    short getIOType(short s, short s2, short s3) {
        if (s2 >= 0 && s3 >= 0) {
            return iotype[s][s2][s3];
        }
        return 0;
    }

    boolean getAnalog(short s, short s2, short s3) {
        if (s2 >= 0 && s3 >= 0) {
            return analog[s][s2][s3];
        }
        return false;
    }

    private void initmodulevars(CommBean commBean, short s, short s2, short s3) {
        short s4 = (short)(s2 - 1);
        short s5 = (short)(s3 - 1);
        short s6 = s;
        short s7 = moduleslotnumber[s6][s4][s5];
        if (s3 != 0) {
            short s8 = headslotnumbers[s6];
            DioDropHdrListener dioDropHdrListener = new DioDropHdrListener(this.status, pageA0, s8, s2, s7);
            this.modHealth.setupMonitoring(dioDropHdrListener, DioDropsPanel.pageA0.quantity);
        } else {
            this.status.setText(DioStrings.getString("UNKNOWN"));
        }
        this.rack.setText("1");
        this.slot.setText(new Integer(moduleslotnumber[s6][s4][s5]).toString());
        String string = Integer.toHexString(modulepersonality[s6][s4][s5]);
        int n = this.modIDList.findStringIndex(string, (short)2);
        if (n != this.modIDList.counter) {
            this.reference.setText(this.modIDList.name[n]);
            DioDropsPanel.personalitystrings[s6][s4][s5] = this.modIDList.name[n];
            DioDropsPanel.descstrings[s6][s4][s5] = this.modIDList.desc[n];
            DioDropsPanel.analog[s6][s4][s5] = this.modIDList.analog[n];
            DioDropsPanel.iotype[s6][s4][s5] = this.modIDList.inBytes[n] > 0 && this.modIDList.outBytes[n] > 0 ? 2 : (this.modIDList.inBytes[n] > 0 ? 1 : 0);
        } else {
            this.reference.setText(DioStrings.getString("UNKNOWN"));
            this.reference.setForeground(Color.magenta);
            DioDropsPanel.personalitystrings[s6][s4][s5] = "Unknown";
        }
        this.product.setText(new Integer(moduleinputs[s6][s4][s5]).toString());
        this.drm.setText(new Integer(moduleoutputs[s6][s4][s5]).toString());
    }

    private void recordTrafficCop(CommBean commBean) {
        if (tCop == null) {
            tCop = new TrafficCop(commBean);
            trafficcopaddress = tCop.getTCopAddress();
            if (trafficcopaddress == 0) {
                return;
            }
            trafficcoplength = tCop.getTCopLength();
            if (trafficcoplength == 0) {
                return;
            }
        }
        if ((totalnumberofdrops = tCop.getTCopDrops()) == 0) {
            return;
        }
        this.saveTrafficCop();
    }

    private boolean saveTrafficCop() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n = 0;
        boolean bl6 = false;
        DioDropsPanel.numberofdrops[2] = 0;
        DioDropsPanel.numberofdrops[1] = 0;
        DioDropsPanel.numberofdrops[0] = 0;
        CPUdropnumberindex = 0;
        NOM1dropnumberindex = 0;
        NOM2dropnumberindex = 0;
        block0: for (short s = 0; s < totalnumberofdrops; s = (short)(s + 1)) {
            short s2 = TrafficCop.dDescArray[s].dropNumber;
            short s3 = TrafficCop.dDescArray[s].dropType;
            if (s3 != 2) continue;
            short s4 = TrafficCop.dDescArray[s].headSlotNum;
            n = 4;
            if (s4 == 0 || DioDropsPanel.pageA0.CPUSlot == s4) {
                bl3 = true;
                cpuHeadSlot = s4;
                s4 = DioDropsPanel.pageA0.CPUSlot;
                n = 0;
            } else if (!bl4 || NOM1Slot == s4) {
                n = 1;
                bl4 = true;
                NOM1Slot = s4;
            } else {
                n = 2;
                bl5 = true;
                NOM2Slot = s4;
            }
            if (n > 3) {
                return false;
            }
            short s5 = (short)(s2 - 1);
            DioDropsPanel.headslotnumbers[n] = s4;
            int n2 = n;
            numberofdrops[n2] = (short)(numberofdrops[n2] + 1);
            DioDropsPanel.readflgs[n][s5] = TrafficCop.dDescArray[s].readOnly ? (short)1 : 0;
            if (n == 0) {
                DioDropsPanel.dropnumbers[n][DioDropsPanel.CPUdropnumberindex] = s2;
                CPUdropnumberindex = (short)(CPUdropnumberindex + 1);
            } else if (n == 1) {
                DioDropsPanel.dropnumbers[n][DioDropsPanel.NOM1dropnumberindex] = s2;
                NOM1dropnumberindex = (short)(NOM1dropnumberindex + 1);
            } else {
                DioDropsPanel.dropnumbers[n][DioDropsPanel.NOM2dropnumberindex] = s2;
                NOM2dropnumberindex = (short)(NOM2dropnumberindex + 1);
            }
            DioDropsPanel.configuredmodules[n][s5] = TrafficCop.dDescArray[s].numModulesCfgd;
            int n3 = 0;
            while (true) {
                short s6;
                if (n3 >= TrafficCop.dDescArray[s].numModulesCfgd) continue block0;
                short s7 = TrafficCop.dDescArray[s].mDescArray[n3].slot;
                short s8 = TrafficCop.dDescArray[s].mDescArray[n3].rack;
                short s9 = (short)(s7 - 1);
                short s10 = (short)(s8 - 1);
                DioDropsPanel.moduleracknumber[n][s5][s9] = s8;
                DioDropsPanel.racknumbers[n][s5] = s8;
                DioDropsPanel.moduleslotnumber[n][s5][s9] = s7;
                if (highestslotnumber[n][s5] < s7) {
                    DioDropsPanel.highestslotnumber[n][s5] = s7;
                }
                DioDropsPanel.modulepersonality[n][s5][s9] = s6 = (short)TrafficCop.dDescArray[s].mDescArray[n3].modulePerson;
                String string = Integer.toHexString(s6);
                int n4 = this.modIDList.findStringIndex(string, (short)2);
                if (n4 != this.modIDList.counter) {
                    DioDropsPanel.personalitystrings[n][s5][s9] = this.modIDList.name[n4];
                    DioDropsPanel.descstrings[n][s5][s9] = this.modIDList.desc[n4];
                } else {
                    DioDropsPanel.personalitystrings[n][s5][s9] = "???-???";
                }
                DioDropsPanel.moduleinputs[n][s5][s9] = (short)TrafficCop.dDescArray[s].mDescArray[n3].inStartReference;
                DioDropsPanel.moduleoutputs[n][s5][s9] = (short)TrafficCop.dDescArray[s].mDescArray[n3].outStartReference;
                ++n3;
            }
        }
        return true;
    }

    private void doLabels(int n) {
        String[] stringArray = n == 0 ? maintextarray : (n == 1 ? droptextarray : moduletextarray);
        for (int i = 0; i < stringArray.length; ++i) {
            this.labels[i].setText(stringArray[i]);
        }
    }

    public Insets getInsets() {
        return new Insets(0, 30, 0, 30);
    }

    static {
        trafficcoplength = 0;
        numberofdrops = new short[3];
        headslotnumbers = new short[3];
        cpuHeadSlot = 0;
        NOM1Slot = -1;
        NOM2Slot = -1;
        CPUdropnumberindex = 0;
        NOM1dropnumberindex = 0;
        NOM2dropnumberindex = 0;
        dropnumbers = new short[3][64];
        configuredmodules = new short[3][64];
        racknumbers = new short[3][64];
        readflgs = new short[3][64];
        highestslotnumber = new short[3][64];
        moduleracknumber = new short[3][64][16];
        moduleslotnumber = new short[3][64][16];
        moduleinputs = new short[3][64][16];
        moduleoutputs = new short[3][64][16];
        analog = new boolean[3][64][16];
        iotype = new short[3][64][16];
        modulepersonality = new short[3][64][16];
        personalitystrings = new String[3][64][16];
        descstrings = new String[3][64][16];
    }
}

