/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.GetNumber;
import com.schneiderautomation.factorycast.GetUInt;
import com.schneiderautomation.factorycast.comm.umas.PlcInfoInterface;
import com.schneiderautomation.factorycast.comm.umas.PlcInfoUMAS;
import com.schneiderautomation.sysdiag.qbf.PlcInfo;

public class QuantumCPUInfo {
    private static final String CFG_DATA = "800048";
    private static final short DIMAWARE = 8192;
    private static final short CNST_SWP = 1024;
    private static final short SNGL_SWP = 512;
    private static final short MEM_PROT = 32;
    private static final short BATT_OK = 16;
    private static final short DOWNSIZE = 1;
    private static final int ID_CPU65150 = 332;
    private static final int ID_CPU65160 = 333;
    private static final int ID_CPU67160 = 334;
    static /* synthetic */ Class class$com$schneiderautomation$factorycast$comm$umas$PlcInfoInterface;

    QuantumCPUInfo(CommBean commBean, PlcInfo plcInfo) {
        GetNumber getNumber = new GetNumber(commBean.getServer());
        getNumber.setAddress(CFG_DATA);
        getNumber.setQuantity((short)128);
        getNumber.setDatatype((short)5);
        boolean bl = false;
        try {
            getNumber.readValues();
        }
        catch (Exception exception) {
            bl = true;
            System.out.println(exception.getMessage());
        }
        if (!bl) {
            int n;
            short s;
            Number[] numberArray = getNumber.getValues();
            short s2 = numberArray[53].shortValue();
            short s3 = numberArray[57].shortValue();
            plcInfo.execID = numberArray[0].shortValue();
            short s4 = numberArray[51].shortValue();
            plcInfo.systemMem = s4 * 4096;
            if ((s2 & 1) == 1) {
                s = numberArray[127].shortValue();
                plcInfo.systemMem -= (s & 0xFF) * 16;
            }
            if ((s = numberArray[123].shortValue()) != 0) {
                plcInfo.extendedMem = (s - 1) * 10000;
                s = numberArray[124].shortValue();
                plcInfo.extendedMem += s + 1;
            } else {
                plcInfo.extendedMem = 0;
            }
            boolean bl2 = (s3 & 0x2000) == 8192;
            plcInfo.ioMapWords = bl2 ? (short)0 : numberArray[42].shortValue();
            plcInfo.numberOfSegments = bl2 ? (short)1 : numberArray[58].shortValue();
            plcInfo.availableMem = plcInfo.systemMem + plcInfo.extendedMem;
            if (bl2) {
                plcInfo.DCPDrop = 0;
                plcInfo.number0xReg = 0;
                plcInfo.number1xReg = 0;
                plcInfo.number3xReg = 0;
                plcInfo.number4xReg = 0;
                plcInfo.number6xReg = 0;
            } else {
                plcInfo.DCPDrop = numberArray[120].shortValue();
                plcInfo.number0xReg = numberArray[5].intValue();
                plcInfo.number1xReg = numberArray[10].intValue();
                plcInfo.number3xReg = numberArray[14].intValue();
                plcInfo.number4xReg = numberArray[16].intValue();
                plcInfo.number6xReg = plcInfo.extendedMem;
            }
            plcInfo.memoryProtect = (s2 & 0x20) == 32;
            plcInfo.constantSweep = (s2 & 0x400) == 1024;
            plcInfo.batteryOk = (s2 & 0x10) == 16;
            s = numberArray[62].shortValue();
            boolean bl3 = plcInfo.optimize = s == 1;
            plcInfo.status = s3 > 0 ? (short)(!bl2 ? 1 : 0) : ((s2 & 0x200) == 512 ? (short)2 : (short)3);
            plcInfo.stoppedCode = s3;
            s = numberArray[94].shortValue();
            plcInfo.loggedIn = s > 0;
            plcInfo.battery0x = numberArray[9].intValue();
            plcInfo.batteryCfg = !bl2 && plcInfo.battery0x != 0;
            int n2 = numberArray[109].intValue();
            if (n2 == 0 || bl2) {
                plcInfo.timerRegConfigured = false;
            } else {
                plcInfo.timerRegConfigured = true;
                n = numberArray[17].intValue();
                plcInfo.timer4x = n2 - n + 1;
            }
            plcInfo.TOD4x = numberArray[68].intValue();
            boolean bl4 = plcInfo.TODConfigured = !bl2 && plcInfo.TOD4x != 0;
            if (bl2) {
                plcInfo.totalAsciiWords = 0;
                plcInfo.totalAsciiMessages = 0;
                plcInfo.asciiWordsUsed = 0;
                plcInfo.asciiMessagesUsed = 0;
                plcInfo.asciiWordsFree = 0;
                plcInfo.asciiMessagesFree = 0;
                plcInfo.numberAsciiPorts = 0;
                plcInfo.asciiInputCfg = false;
                plcInfo.asciiOutputCfg = false;
            } else {
                plcInfo.totalAsciiWords = numberArray[97].intValue();
                plcInfo.totalAsciiMessages = numberArray[30].intValue();
                plcInfo.asciiWordsUsed = numberArray[110].intValue() - numberArray[98].intValue() + 1;
                if (plcInfo.asciiWordsUsed < 0 || plcInfo.asciiWordsUsed > plcInfo.totalAsciiWords) {
                    plcInfo.asciiWordsUsed = 0;
                }
                n = numberArray[31].shortValue();
                plcInfo.asciiMessagesUsed = 0;
                String string = String.valueOf(n);
                GetNumber getNumber2 = new GetNumber(commBean.getServer());
                getNumber2.setAddress("80000" + string);
                getNumber2.setQuantity((short)plcInfo.totalAsciiMessages);
                getNumber2.setDatatype((short)5);
                try {
                    getNumber2.readValues();
                }
                catch (Exception exception) {
                    bl = true;
                    System.out.println(exception.getMessage());
                }
                if (!bl) {
                    Number[] numberArray2 = getNumber2.getValues();
                    for (int i = 0; i < plcInfo.totalAsciiMessages; ++i) {
                        if (numberArray2[i].intValue() == 65535) continue;
                        ++plcInfo.asciiMessagesUsed;
                    }
                } else {
                    plcInfo.asciiMessagesUsed = 0;
                }
                plcInfo.asciiWordsFree = plcInfo.totalAsciiWords - plcInfo.asciiWordsUsed;
                plcInfo.asciiMessagesFree = plcInfo.totalAsciiMessages - plcInfo.asciiMessagesUsed;
                plcInfo.numberAsciiPorts = numberArray[76].intValue();
                plcInfo.asciiInput4x = numberArray[69].intValue();
                plcInfo.asciiInputCfg = plcInfo.asciiInput4x > 0;
                plcInfo.asciiOutput4x = numberArray[71].intValue();
                plcInfo.asciiOutputCfg = plcInfo.asciiOutput4x > 0;
            }
        } else {
            plcInfo.execID = 0;
            plcInfo.systemMem = 0;
            plcInfo.extendedMem = 0;
            plcInfo.availableMem = 0;
            plcInfo.ioMapWords = 0;
            plcInfo.numberOfSegments = 0;
            plcInfo.numberOfNetworks = 0;
            plcInfo.DCPDrop = 0;
            plcInfo.number0xReg = 0;
            plcInfo.number1xReg = 0;
            plcInfo.number3xReg = 0;
            plcInfo.number4xReg = 0;
            plcInfo.number6xReg = 0;
            plcInfo.memoryProtect = false;
            plcInfo.constantSweep = false;
            plcInfo.batteryOk = false;
            plcInfo.optimize = false;
            plcInfo.status = (short)4;
            plcInfo.loggedIn = false;
            plcInfo.stoppedCode = 0;
            plcInfo.battery0x = 0;
            plcInfo.batteryCfg = false;
            plcInfo.timerRegConfigured = false;
            plcInfo.timer4x = 0;
            plcInfo.TODConfigured = false;
            plcInfo.TOD4x = 0;
            plcInfo.totalAsciiWords = 0;
            plcInfo.totalAsciiMessages = 0;
            plcInfo.asciiWordsUsed = 0;
            plcInfo.asciiMessagesUsed = 0;
            plcInfo.asciiWordsFree = 0;
            plcInfo.asciiMessagesFree = 0;
            plcInfo.numberAsciiPorts = 0;
            plcInfo.asciiInputCfg = false;
            plcInfo.asciiOutputCfg = false;
        }
    }

    public static boolean isHECPU(CommBean commBean) {
        boolean bl = false;
        try {
            if (commBean.getServer().isUMASSupported()) {
                PlcInfoInterface plcInfoInterface = (PlcInfoInterface)commBean.getServer().getExtension(class$com$schneiderautomation$factorycast$comm$umas$PlcInfoInterface == null ? (class$com$schneiderautomation$factorycast$comm$umas$PlcInfoInterface = QuantumCPUInfo.class$("com.schneiderautomation.factorycast.comm.umas.PlcInfoInterface")) : class$com$schneiderautomation$factorycast$comm$umas$PlcInfoInterface);
                int n = plcInfoInterface.getPlcInfo().getPlcID();
                bl = n == 332 || n == 333 || n == 334;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getCpuName(CommBean commBean) {
        String string = "CPU xxx xx";
        try {
            GetUInt getUInt;
            if (commBean.getServer().isUMASSupported()) {
                getUInt = (PlcInfoInterface)commBean.getServer().getExtension(class$com$schneiderautomation$factorycast$comm$umas$PlcInfoInterface == null ? (class$com$schneiderautomation$factorycast$comm$umas$PlcInfoInterface = QuantumCPUInfo.class$("com.schneiderautomation.factorycast.comm.umas.PlcInfoInterface")) : class$com$schneiderautomation$factorycast$comm$umas$PlcInfoInterface);
                PlcInfoUMAS plcInfoUMAS = getUInt.getPlcInfo();
                string = plcInfoUMAS.getReference();
            } else {
                getUInt = new GetUInt(commBean.getServer());
                getUInt.setAddress("800099");
                getUInt.readValues();
                block1 : switch (getUInt.getValue()) {
                    case 2: {
                        string = "CPU 113 02";
                        break;
                    }
                    case 4: {
                        string = "CPU 113 03";
                        break;
                    }
                    case 6: {
                        string = "CPU 213 03";
                        break;
                    }
                    case 8: 
                    case 12: {
                        string = "CPU 213 04";
                        break;
                    }
                    default: {
                        if (getUInt.getValue() < 16) break;
                        getUInt.setAddress("81565361");
                        getUInt.readValues();
                        switch (getUInt.getValue()) {
                            case 1: {
                                string = "CPU 434 12";
                                break block1;
                            }
                            case 2: {
                                string = "CPU 534 14";
                                break block1;
                            }
                        }
                        string = "CPU 424 0x";
                        break;
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (!string.startsWith("CPU")) {
            int n = -1;
            n = string.indexOf("CPU");
            if (n < 0) return string;
            return string.substring(n);
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

