/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.GetNumber;
import com.schneiderautomation.sysdiag.MessageDisplay;
import com.schneiderautomation.sysdiag.qbf.MessageStrings;
import com.schneiderautomation.sysdiag.qbf.RIOCommInfo;
import com.schneiderautomation.sysdiag.qbf.RIODropInfo;
import java.applet.Applet;

public class RIOCommStatus {
    private CommBean comm;
    RIOCommInfo rioCommInfo;
    String dropStatusAddress;
    private static final String PAGE0_START = "800048";
    private static final String MACH_CONFIG = "800097";
    private static final String DROP_ADDR = "800051";
    private static final String MACH_STATUS = "800105";
    private static final short TCOP_BIT = 16384;
    private static final short COMM_HEALTH = Short.MIN_VALUE;
    private static final short CABA_HEALTH = 16384;
    private static final short CABB_HEALTH = 8192;
    private static final short LOST_COMM_CTR = 3840;
    private static final short CUM_RETRY_CTR = 255;
    private static final int offset = 97;
    private GetNumber getStatusVals;
    private GetNumber getRioVals;
    private Number dropAddress;
    private int dropNo;
    private int indexVal;
    private Number[] rioStatusArray;
    private Number[] dropStatusArray;
    protected RIODropInfo[] rioDropInfo;
    protected boolean rioInfoValid;
    private boolean validTCop;
    private Applet thisApplet;

    RIOCommStatus(CommBean commBean, Applet applet, RIOCommInfo rIOCommInfo) {
        block9: {
            this.rioStatusArray = new Number[10];
            this.dropStatusArray = new Number[10];
            this.rioDropInfo = new RIODropInfo[32];
            this.rioInfoValid = false;
            this.thisApplet = applet;
            this.getStatusVals = new GetNumber(commBean.getServer());
            this.getStatusVals.setAddress(MACH_CONFIG);
            this.getStatusVals.setQuantity((short)10);
            this.getStatusVals.setDatatype((short)5);
            try {
                this.getStatusVals.readValues();
                this.rioStatusArray = this.getStatusVals.getValues();
                rIOCommInfo.rioPresent = true;
                if (rIOCommInfo.rioPresent) {
                    rIOCommInfo.TCopValid = this.validTrafficCop(commBean);
                    if (rIOCommInfo.TCopValid) {
                        this.getRioVals = new GetNumber(commBean.getServer());
                        this.getRioVals.setAddress(DROP_ADDR);
                        this.getRioVals.setQuantity((short)1);
                        this.getRioVals.setDatatype((short)5);
                        try {
                            this.getRioVals.readValues();
                            this.dropAddress = this.getRioVals.getValue();
                            this.dropStatusAddress = "80" + String.valueOf(this.dropAddress);
                            this.getRioVals.setAddress(this.dropStatusAddress);
                            this.getRioVals.setQuantity((short)106);
                            this.getRioVals.setDatatype((short)5);
                            try {
                                this.getRioVals.readValues();
                                this.dropStatusArray = this.getRioVals.getValues();
                                this.rioInfoValid = true;
                                rIOCommInfo.startUpCode = this.dropStatusArray[0].shortValue();
                                short s = this.dropStatusArray[1].shortValue();
                                rIOCommInfo.cableARcvErr.dmaRcvCount = (byte)s;
                                rIOCommInfo.cableARcvErr.frameSizeErrorCount = (byte)(s >> 8);
                                s = this.dropStatusArray[2].shortValue();
                                rIOCommInfo.cableARcvErr.badDropCount = (byte)s;
                                rIOCommInfo.cableARcvErr.rcvErrorCount = (byte)(s >> 8);
                                rIOCommInfo.cableARcvErr.lastRcvLanError = this.dropStatusArray[3].shortValue();
                                s = this.dropStatusArray[4].shortValue();
                                rIOCommInfo.cableBRcvErr.dmaRcvCount = (byte)s;
                                rIOCommInfo.cableBRcvErr.frameSizeErrorCount = (byte)(s >> 8);
                                s = this.dropStatusArray[5].shortValue();
                                rIOCommInfo.cableBRcvErr.badDropCount = (byte)s;
                                rIOCommInfo.cableBRcvErr.rcvErrorCount = (byte)(s >> 8);
                                rIOCommInfo.cableBRcvErr.lastRcvLanError = this.dropStatusArray[6].intValue();
                                s = this.dropStatusArray[7].shortValue();
                                rIOCommInfo.globalCommHealth = (s & Short.MIN_VALUE) == Short.MIN_VALUE;
                                rIOCommInfo.globalCableAHealth = (s & 0x4000) == 16384;
                                rIOCommInfo.globalCableBHealth = (s & 0x2000) == 8192;
                                rIOCommInfo.globalLostCommCtr = s >> 8 & 0xF00;
                                rIOCommInfo.globalTotalRetryCtr = s & 0xFF;
                                s = this.dropStatusArray[8].shortValue();
                                rIOCommInfo.cableACumErr.noResponseCount = (byte)s;
                                rIOCommInfo.cableACumErr.frameErrorCount = (byte)(s >> 8);
                                s = this.dropStatusArray[9].shortValue();
                                rIOCommInfo.cableBCumErr.noResponseCount = (byte)s;
                                rIOCommInfo.cableBCumErr.frameErrorCount = (byte)(s >> 8);
                                this.indexVal = 10;
                                while (this.indexVal < 106) {
                                    this.rioDropInfo[this.dropNo] = new RIODropInfo();
                                    s = this.dropStatusArray[this.indexVal].shortValue();
                                    this.rioDropInfo[this.dropNo].commHealth = (s & Short.MIN_VALUE) == Short.MIN_VALUE;
                                    this.rioDropInfo[this.dropNo].cableAHealth = (s & 0x4000) == 16384;
                                    this.rioDropInfo[this.dropNo].cableBHealth = (s & 0x2000) == 8192;
                                    this.rioDropInfo[this.dropNo].cumulativeRetryCtr = s & 0xFF;
                                    this.rioDropInfo[this.dropNo].retryExhaustedCtr = s >> 8 & 0xF00;
                                    s = this.dropStatusArray[this.indexVal + 1].shortValue();
                                    this.rioDropInfo[this.dropNo].cableACumErr.noResponseCount = (byte)s;
                                    this.rioDropInfo[this.dropNo].cableACumErr.frameErrorCount = (byte)(s >> 8);
                                    s = this.dropStatusArray[this.indexVal + 2].shortValue();
                                    this.rioDropInfo[this.dropNo].cableBCumErr.noResponseCount = (byte)s;
                                    this.rioDropInfo[this.dropNo].cableBCumErr.frameErrorCount = (byte)(s >> 8);
                                    ++this.dropNo;
                                    this.indexVal += 3;
                                }
                                break block9;
                            }
                            catch (Exception exception) {
                                String string = MessageStrings.getString("M_COMMERR");
                                String string2 = exception.getMessage();
                                MessageDisplay messageDisplay = new MessageDisplay(this.thisApplet, string, string2);
                                this.rioInfoValid = false;
                                this.zeroOutRioCommInfo(rIOCommInfo);
                                exception.printStackTrace();
                            }
                        }
                        catch (Exception exception) {
                            String string = MessageStrings.getString("M_COMMERR");
                            String string3 = exception.getMessage();
                            MessageDisplay messageDisplay = new MessageDisplay(this.thisApplet, string, string3);
                            this.rioInfoValid = false;
                            this.zeroOutRioCommInfo(rIOCommInfo);
                            exception.printStackTrace();
                        }
                        break block9;
                    }
                    this.zeroOutRioCommInfo(rIOCommInfo);
                    break block9;
                }
                this.zeroOutRioCommInfo(rIOCommInfo);
            }
            catch (Exception exception) {
                String string = MessageStrings.getString("M_ADDRERR") + DROP_ADDR;
                System.err.println("Communications Error: " + string);
                this.zeroOutRioCommInfo(rIOCommInfo);
                this.rioInfoValid = false;
                exception.printStackTrace();
            }
        }
    }

    boolean validTrafficCop(CommBean commBean) {
        GetNumber getNumber = new GetNumber(commBean.getServer());
        getNumber.setAddress(MACH_STATUS);
        getNumber.setQuantity((short)1);
        getNumber.setDatatype((short)5);
        try {
            getNumber.readValues();
            Number number = getNumber.getValue();
            return (number.shortValue() & 0x4000) == 0;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    void zeroOutRioCommInfo(RIOCommInfo rIOCommInfo) {
        rIOCommInfo.startUpCode = 0;
        rIOCommInfo.globalCommHealth = false;
        rIOCommInfo.globalCableAHealth = false;
        rIOCommInfo.globalCableBHealth = false;
        rIOCommInfo.cableARcvErr.frameSizeErrorCount = 0;
        rIOCommInfo.cableARcvErr.badDropCount = 0;
        rIOCommInfo.cableARcvErr.rcvErrorCount = 0;
        rIOCommInfo.cableARcvErr.dmaRcvCount = 0;
        rIOCommInfo.cableBRcvErr.dmaRcvCount = 0;
        rIOCommInfo.cableBRcvErr.frameSizeErrorCount = 0;
        rIOCommInfo.cableBRcvErr.badDropCount = 0;
        rIOCommInfo.cableBRcvErr.rcvErrorCount = 0;
        rIOCommInfo.cableBRcvErr.lastRcvLanError = 0;
        rIOCommInfo.cableACumErr.noResponseCount = 0;
        rIOCommInfo.cableACumErr.frameErrorCount = 0;
        rIOCommInfo.cableBCumErr.noResponseCount = 0;
        rIOCommInfo.cableBCumErr.frameErrorCount = 0;
    }

    public RIODropInfo getRIODropStatus(short s) {
        if (this.rioInfoValid) {
            return this.rioDropInfo[s + 1];
        }
        return null;
    }

    public String getDropStatusAddress() {
        return this.dropStatusAddress;
    }
}

