/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.sysdiag.qbf.ModuleHealth;
import com.schneiderautomation.sysdiag.qbf.ModuleIDs;
import com.schneiderautomation.sysdiag.qbf.RioDropHdrListener;
import com.schneiderautomation.sysdiag.qbf.RioStrings;
import com.schneiderautomation.sysdiag.qbf.TrafficCop;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;

class RioDropsPanel
extends Panel {
    private static final short MAX_RIO_HEADS = 1;
    private static final short MAX_NO_OF_DROPS = 32;
    private static final short MAX_RACKS = 5;
    private static final short MAX_NO_OF_MODULES = 16;
    private static final short TEXTFIELDSIZE = 10;
    private static final short DIODROPTYPE = 2;
    private static final short BOTH = 2;
    private static final short INPUT = 1;
    private static final short OUTPUT = 0;
    private static final short MAIN = 0;
    private static final short DROP = 1;
    private static final short MODULE = 2;
    private static TrafficCop tCop;
    private static int trafficcopaddress;
    private static short trafficcoplength;
    private static short totalnumberofdrops;
    private static short indextodropdesc;
    private static short numberofdrops;
    private static short dropnumberindex;
    private static short crpSlot;
    private static short[] headslotnumbers;
    private static short[] dropnumbers;
    private static short[] droptypes;
    private static short[] configuredmodules;
    private static short[] racknumbers;
    private static short[][] highestslotnumber;
    private static short[][] modsperrack;
    private static short[][][] moduleracknumber;
    private static short[][][] moduleslotnumber;
    private static short[][][] moduleinputs;
    private static short[][][] moduleoutputs;
    private static boolean[][][] analog;
    private static short[][][] iotype;
    private static short[][][] modulepersonality;
    private static String[][][] personalitystrings;
    private static String[][][] descstrings;
    private static String[] maintextarray;
    private static String[] droptextarray;
    private static String[] moduletextarray;
    private TextField status = new TextField(10);
    private TextField rack = new TextField(10);
    private TextField slot = new TextField(10);
    private TextField reference = new TextField(10);
    private TextField product = new TextField(10);
    private TextField drm = new TextField(10);
    private Label[] labels = new Label[6];
    private ModuleIDs modIDList;
    ModuleHealth modHealth;

    RioDropsPanel(String string, Applet applet, CommBean commBean, ModuleIDs moduleIDs) {
        this.modIDList = moduleIDs;
        this.initmaintextarray();
        this.initdroptextarray();
        this.initmoduletextarray();
        Font font = new Font("SansSerif", 1, 12);
        Color color = new Color(226, 226, 226);
        this.status.setBackground(color);
        this.status.setFont(font);
        this.status.setEditable(false);
        this.rack.setBackground(color);
        this.rack.setFont(font);
        this.rack.setEditable(false);
        this.slot.setBackground(color);
        this.slot.setFont(font);
        this.slot.setEditable(false);
        this.reference.setBackground(color);
        this.reference.setFont(font);
        this.reference.setEditable(false);
        this.product.setBackground(color);
        this.product.setFont(font);
        this.product.setEditable(false);
        this.drm.setBackground(color);
        this.drm.setFont(font);
        this.drm.setEditable(false);
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i] = new Label();
            this.labels[i].setFont(font);
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.status, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.rack, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.slot, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.reference, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.product, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.drm, gridBagConstraints);
        gridBagConstraints.insets.right = 10;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.labels[0], gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.labels[1], gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.labels[2], gridBagConstraints);
        gridBagConstraints.insets.left = 30;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        this.add((Component)this.labels[3], gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.labels[4], gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.labels[5], gridBagConstraints);
        applet.showStatus("Accessing Traffic Cop...");
        this.recordTrafficCop(commBean);
        applet.showStatus("Reading I/O health...");
        this.modHealth = new ModuleHealth(commBean, tCop.isTCopValid());
        applet.showStatus("         ");
    }

    private void initmoduletextarray() {
        if (moduletextarray == null) {
            moduletextarray = new String[6];
            RioDropsPanel.moduletextarray[0] = RioStrings.getString("STATUS");
            RioDropsPanel.moduletextarray[1] = RioStrings.getString("RACK");
            RioDropsPanel.moduletextarray[2] = RioStrings.getString("SLOT");
            RioDropsPanel.moduletextarray[3] = RioStrings.getString("REFERENCE");
            RioDropsPanel.moduletextarray[4] = RioStrings.getString("INPUTSTARTREF");
            RioDropsPanel.moduletextarray[5] = RioStrings.getString("OUTPUTSTARTREF");
        }
    }

    private void initdroptextarray() {
        if (droptextarray == null) {
            droptextarray = new String[6];
            RioDropsPanel.droptextarray[0] = RioStrings.getString("STATUS");
            RioDropsPanel.droptextarray[1] = RioStrings.getString("RACK");
            RioDropsPanel.droptextarray[2] = RioStrings.getString("HEADSLOT");
            RioDropsPanel.droptextarray[3] = RioStrings.getString("READONLY");
            RioDropsPanel.droptextarray[4] = RioStrings.getString("PRODUCTTYPE");
            RioDropsPanel.droptextarray[5] = RioStrings.getString("NUMBEROFRACKS");
        }
    }

    private void initmaintextarray() {
        if (maintextarray == null) {
            maintextarray = new String[6];
            RioDropsPanel.maintextarray[0] = RioStrings.getString("STATUS");
            RioDropsPanel.maintextarray[1] = RioStrings.getString("RACK");
            RioDropsPanel.maintextarray[2] = RioStrings.getString("HEADSLOT");
            RioDropsPanel.maintextarray[3] = RioStrings.getString("REFERENCE");
            RioDropsPanel.maintextarray[4] = RioStrings.getString("PRODUCTTYPE");
            RioDropsPanel.maintextarray[5] = RioStrings.getString("NUMBEROFDROPS");
        }
    }

    void setMultiDropData(CommBean commBean, short s) {
        this.status.setText(RioStrings.getString("OK"));
        this.status.setForeground(Color.green.darker());
        this.rack.setText("1");
        this.reference.setText("CRP 93x 00");
        this.product.setText(RioStrings.getString("QUANTUM"));
        this.drm.setText(new Integer(s).toString());
        this.slot.setText(new Integer(crpSlot).toString());
        this.doLabels(0);
    }

    void setDropData(int n, int n2) {
        if (n != 0) {
            this.status.setText(RioStrings.getString("OK"));
            this.status.setForeground(Color.green.darker());
            this.rack.setText(new Integer(n2).toString());
            this.rack.setForeground(Color.black);
            if (this.is800IO((short)(n - 1))) {
                this.product.setText("800 Series");
            } else {
                this.product.setText(RioStrings.getString("QUANTUM"));
            }
            this.product.setForeground(Color.black);
            short s = this.getNumberOfRacks((short)(n - 1));
            this.drm.setText(new Integer(s).toString());
            this.drm.setForeground(Color.black);
            this.reference.setText("FALSE ");
            this.reference.setForeground(Color.black);
            this.slot.setText(new Integer(headslotnumbers[n - 1]).toString());
            this.slot.setForeground(Color.black);
        }
        this.doLabels(1);
    }

    void setModuleData(CommBean commBean, short s, short s2, short s3) {
        this.rack.setText(new Integer(s2).toString());
        this.initmodulevars(commBean, s, s2, s3);
        this.doLabels(2);
    }

    short getNumberOfRacks(short s) {
        return racknumbers[s];
    }

    short getHighestSlotNumber(short s) {
        short s2 = 0;
        for (int i = 0; i < 5; ++i) {
            if (highestslotnumber[s][i] <= s2) continue;
            s2 = highestslotnumber[s][i];
        }
        return s2;
    }

    short getSlotNumber(short s, short s2) {
        return highestslotnumber[s][s2];
    }

    short getHeadSlot(short s) {
        return headslotnumbers[s - 1];
    }

    short getSlotNumber(short s, short s2, short s3) {
        return moduleslotnumber[s][s2][s3];
    }

    short getRackNumber(short s, short s2, short s3) {
        return moduleracknumber[s][s2][s3];
    }

    short getDropNumber(short s) {
        return dropnumbers[s];
    }

    short getDropType(short s) {
        return droptypes[s];
    }

    TrafficCop getTrafficCop() {
        return tCop;
    }

    short getNumberOfDrops() {
        return numberofdrops;
    }

    short getNumberOfModules(short s, short s2) {
        if (s >= 0) {
            return modsperrack[s][s2];
        }
        return 0;
    }

    String getPersonality(short s, short s2, short s3) {
        if (s >= 0 && s3 >= 0 && s2 <= 5) {
            return personalitystrings[s][s2][s3];
        }
        return null;
    }

    String getDesc(short s, short s2, short s3) {
        if (s >= 0 && s3 >= 0 && s2 <= 5) {
            return descstrings[s][s2][s3];
        }
        return null;
    }

    boolean is800IO(short s) {
        return s >= 0 && s <= 32 && droptypes[s] == 0;
    }

    short getIOType(short s, short s2, short s3) {
        if (s >= 0 && s3 >= 0) {
            return iotype[s][s2][s3];
        }
        return 0;
    }

    boolean getAnalog(short s, short s2, short s3) {
        if (s >= 0 && s3 >= 0) {
            return analog[s][s2][s3];
        }
        return false;
    }

    private void initmodulevars(CommBean commBean, short s, short s2, short s3) {
        short s4 = (short)(s - 1);
        short s5 = (short)(s3 - 1);
        short s6 = (short)(s2 - 1);
        short s7 = moduleslotnumber[s4][s6][s5];
        if (s3 != 0) {
            this.modHealth.getHealth(s, s2, new RioDropHdrListener(this.status, s7));
        } else {
            this.status.setText(RioStrings.getString("UNKNOWN"));
        }
        this.rack.setText(new Integer(s2).toString());
        this.slot.setText(new Integer(s7).toString());
        String string = Integer.toHexString(modulepersonality[s4][s6][s5]);
        int n = this.modIDList.findStringIndex(string, droptypes[s4]);
        if (n != this.modIDList.counter) {
            this.reference.setText(this.modIDList.name[n]);
            RioDropsPanel.personalitystrings[s4][s6][s5] = this.modIDList.name[n];
            RioDropsPanel.analog[s4][s6][s5] = this.modIDList.analog[n];
            RioDropsPanel.iotype[s4][s6][s5] = this.modIDList.inBytes[n] > 0 && this.modIDList.outBytes[n] > 0 ? 2 : (this.modIDList.inBytes[n] > 0 ? 1 : 0);
        } else {
            this.reference.setText(RioStrings.getString("UNKNOWN"));
            this.reference.setForeground(Color.magenta);
            RioDropsPanel.personalitystrings[s4][s6][s5] = "Unknown";
        }
        this.product.setText(new Integer(moduleinputs[s4][s6][s5]).toString());
        this.drm.setText(new Integer(moduleoutputs[s4][s6][s5]).toString());
    }

    private void recordTrafficCop(CommBean commBean) {
        if (tCop == null) {
            tCop = new TrafficCop(commBean);
            trafficcopaddress = tCop.getTCopAddress();
            if (trafficcopaddress == 0) {
                return;
            }
            trafficcoplength = tCop.getTCopLength();
            if (trafficcoplength == 0) {
                return;
            }
            totalnumberofdrops = tCop.getTCopDrops();
            if (totalnumberofdrops == 0) {
                return;
            }
            this.saveTrafficCop();
        }
    }

    private boolean saveTrafficCop() {
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        indextodropdesc = (short)3;
        numberofdrops = 0;
        dropnumberindex = 0;
        for (short s = 0; s < totalnumberofdrops; s = (short)(s + 1)) {
            short s2;
            short s3 = TrafficCop.dDescArray[s].dropNumber;
            short s4 = TrafficCop.dDescArray[s].dropType;
            if (s4 == 2 || s3 == 1) continue;
            crpSlot = s2 = (short)TrafficCop.dDescArray[s].headSlotNum;
            short s5 = (short)(s3 - 1);
            RioDropsPanel.headslotnumbers[s5] = s2;
            RioDropsPanel.dropnumbers[RioDropsPanel.dropnumberindex] = s3;
            RioDropsPanel.droptypes[s5] = s4;
            dropnumberindex = (short)(dropnumberindex + 1);
            numberofdrops = (short)(numberofdrops + 1);
            RioDropsPanel.configuredmodules[s5] = TrafficCop.dDescArray[s].numModulesCfgd;
            for (int i = 0; i < configuredmodules[s5]; ++i) {
                short s6;
                short s7 = TrafficCop.dDescArray[s].mDescArray[i].slot;
                short s8 = TrafficCop.dDescArray[s].mDescArray[i].rack;
                if (s7 == 0 || s8 == 0) continue;
                short s9 = (short)(s7 - 1);
                short s10 = (short)(s8 - 1);
                RioDropsPanel.moduleracknumber[s5][s10][s9] = s8;
                if (s8 > racknumbers[s5]) {
                    RioDropsPanel.racknumbers[s5] = s8;
                }
                RioDropsPanel.moduleslotnumber[s5][s10][s9] = s7;
                if (highestslotnumber[s5][s10] < s7) {
                    RioDropsPanel.highestslotnumber[s5][s10] = s7;
                }
                RioDropsPanel.modulepersonality[s5][s10][s9] = s6 = (short)TrafficCop.dDescArray[s].mDescArray[i].modulePerson;
                String string = Integer.toHexString(s6);
                int n = this.modIDList.findStringIndex(string, droptypes[s5]);
                if (n != this.modIDList.counter) {
                    RioDropsPanel.personalitystrings[s5][s10][s9] = this.modIDList.name[n];
                    RioDropsPanel.descstrings[s5][s10][s9] = this.modIDList.desc[n];
                    short[] sArray = modsperrack[s5];
                    short s11 = s10;
                    sArray[s11] = (short)(sArray[s11] + 1);
                } else {
                    RioDropsPanel.personalitystrings[s5][s10][s9] = "???-???";
                }
                RioDropsPanel.moduleinputs[s5][s10][s9] = (short)TrafficCop.dDescArray[s].mDescArray[i].inStartReference;
                RioDropsPanel.moduleoutputs[s5][s10][s9] = (short)TrafficCop.dDescArray[s].mDescArray[i].outStartReference;
            }
        }
        return true;
    }

    private void doLabels(int n) {
        String[] stringArray = n == 0 ? maintextarray : (n == 1 ? droptextarray : moduletextarray);
        for (int i = 0; i < stringArray.length; ++i) {
            this.labels[i].setText(stringArray[i]);
        }
    }

    public Insets getInsets() {
        return new Insets(0, 30, 0, 30);
    }

    static {
        trafficcoplength = 0;
        indextodropdesc = 0;
        numberofdrops = 1;
        dropnumberindex = 0;
        headslotnumbers = new short[32];
        dropnumbers = new short[32];
        droptypes = new short[32];
        configuredmodules = new short[32];
        racknumbers = new short[32];
        highestslotnumber = new short[32][5];
        modsperrack = new short[32][5];
        moduleracknumber = new short[32][5][16];
        moduleslotnumber = new short[32][5][16];
        moduleinputs = new short[32][5][16];
        moduleoutputs = new short[32][5][16];
        analog = new boolean[32][5][16];
        iotype = new short[32][5][16];
        modulepersonality = new short[32][5][16];
        personalitystrings = new String[32][5][16];
        descstrings = new String[32][5][16];
    }
}

