/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.sysdiag.qbf;

import com.schneiderautomation.sysdiag.qbf.BorderStyle;
import com.schneiderautomation.sysdiag.qbf.DrawnRectangle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;

public class ThreeDRectangle
extends DrawnRectangle {
    protected static BorderStyle defaultState = BorderStyle.RAISED;
    private BorderStyle state;

    public ThreeDRectangle(Component component) {
        this(component, defaultState, DrawnRectangle.defaultThickness, 0, 0, 0, 0);
    }

    public ThreeDRectangle(Component component, int n) {
        this(component, defaultState, n, 0, 0, 0, 0);
    }

    public ThreeDRectangle(Component component, int n, int n2, int n3, int n4) {
        this(component, defaultState, DrawnRectangle.defaultThickness, n, n2, n3, n4);
    }

    public ThreeDRectangle(Component component, int n, int n2, int n3, int n4, int n5) {
        this(component, defaultState, n, n2, n3, n4, n5);
    }

    public ThreeDRectangle(Component component, BorderStyle borderStyle, int n, int n2, int n3, int n4, int n5) {
        super(component, n, n2, n3, n4, n5);
        this.state = borderStyle;
    }

    public void paint() {
        if (this.state == BorderStyle.RAISED) {
            this.paintRaised();
        } else {
            this.paintInset();
        }
    }

    public void raise() {
        this.state = BorderStyle.RAISED;
    }

    public void inset() {
        this.state = BorderStyle.INSET;
    }

    public boolean isRaised() {
        return this.state == BorderStyle.RAISED;
    }

    public String paramString() {
        return super.paramString() + "," + this.state;
    }

    public void paintRaised() {
        Graphics graphics = this.drawInto.getGraphics();
        if (graphics != null) {
            this.raise();
            this.drawTopLeftLines(graphics, this.brighter());
            this.drawBottomRightLines(graphics, this.getLineColor());
            graphics.dispose();
        }
    }

    public void paintInset() {
        Graphics graphics = this.drawInto.getGraphics();
        if (graphics != null) {
            this.inset();
            this.drawTopLeftLines(graphics, this.getLineColor());
            this.drawBottomRightLines(graphics, this.brighter());
            graphics.dispose();
        }
    }

    private void drawTopLeftLines(Graphics graphics, Color color) {
        int n = this.getThickness();
        graphics.setColor(color);
        for (int i = 0; i < n; ++i) {
            graphics.drawLine(this.x + i, this.y + i, this.x + this.width - (i + 1), this.y + i);
            graphics.drawLine(this.x + i, this.y + i + 1, this.x + i, this.y + this.height - (i + 1));
        }
    }

    private void drawBottomRightLines(Graphics graphics, Color color) {
        int n = this.getThickness();
        graphics.setColor(color);
        for (int i = 1; i <= n; ++i) {
            graphics.drawLine(this.x + i - 1, this.y + this.height - i, this.x + this.width - i, this.y + this.height - i);
            graphics.drawLine(this.x + this.width - i, this.y + i - 1, this.x + this.width - i, this.y + this.height - i);
        }
    }
}

