/*
 * Decompiled with CFR 0.152.
 */
package GXGrid;

import java.io.Serializable;

public class GXRange
implements Cloneable,
Serializable {
    public int top;
    public int bottom;
    public int left;
    public int right;
    public int m_nType;
    public boolean a;

    public GXRange() {
        this.right = 0;
        this.left = 0;
        this.bottom = 0;
        this.top = 0;
        this.a = false;
    }

    public GXRange(int n2, int n3, int n4, int n5) {
        this.setCells(n2, n3, n4, n5);
    }

    public GXRange setCells(int n2, int n3, int n4, int n5) {
        this.m_nType = 0;
        this.left = Math.min(n3, n5);
        this.right = Math.max(n3, n5);
        this.top = Math.min(n2, n4);
        this.bottom = Math.max(n2, n4);
        this.a = true;
        return this;
    }

    public GXRange setRows(int n2, int n3) {
        this.m_nType = 1;
        this.top = Math.min(n2, n3);
        this.bottom = Math.max(n2, n3);
        this.right = 0;
        this.left = 0;
        this.a = true;
        return this;
    }

    public GXRange setCols(int n2, int n3) {
        this.m_nType = 2;
        this.left = Math.min(n2, n3);
        this.right = Math.max(n2, n3);
        this.bottom = 0;
        this.top = 0;
        this.a = true;
        return this;
    }

    public GXRange setTable() {
        this.m_nType = 3;
        this.a = true;
        return this;
    }

    public GXRange expandRange(int n2, int n3, int n4, int n5) {
        switch (this.m_nType) {
            case 2: {
                this.top = n2;
                this.bottom = n4;
                break;
            }
            case 1: {
                this.left = n3;
                this.right = n5;
                break;
            }
            case 3: {
                this.top = n2;
                this.bottom = n4;
                this.left = n3;
                this.right = n5;
            }
        }
        this.m_nType = 0;
        return this;
    }

    public int getLeft() {
        return this.left;
    }

    public int getRight() {
        return this.right;
    }

    public int getTop() {
        return this.top;
    }

    public int getBottom() {
        return this.bottom;
    }

    public int getWidth() {
        return this.right - this.left + 1;
    }

    public int getHeight() {
        return this.bottom - this.top + 1;
    }

    public boolean unionRange(GXRange gXRange, GXRange gXRange2) {
        this.left = Math.min(gXRange.left, gXRange2.left);
        this.right = Math.max(gXRange.right, gXRange2.right);
        this.top = Math.min(gXRange.top, gXRange2.top);
        this.bottom = Math.max(gXRange.bottom, gXRange2.bottom);
        this.a = this.left <= this.right && this.top <= this.bottom;
        return this.a;
    }

    public boolean subtractRange(GXRange gXRange, GXRange gXRange2) {
        this.left = gXRange2.right < gXRange.right ? Math.max(gXRange.left, gXRange2.right) : gXRange.left;
        this.right = this.left + (gXRange.right - gXRange.left) - (gXRange2.right - gXRange2.left);
        this.top = gXRange2.bottom < gXRange.bottom ? Math.max(gXRange.top, gXRange2.bottom) : gXRange.top;
        this.bottom = this.top + (gXRange.bottom - gXRange.top) - (gXRange2.bottom - gXRange2.top);
        this.a = this.left <= this.right && this.top <= this.bottom;
        return this.a;
    }

    public boolean isValid() {
        return this.a && this.top <= this.bottom && this.left <= this.right && this.top >= 0 && this.left >= 0;
    }

    public boolean isCells() {
        return this.m_nType == 0 && this.a;
    }

    public boolean isRows() {
        return this.m_nType == 1 && this.a;
    }

    public boolean isCols() {
        return this.m_nType == 2 && this.a;
    }

    public boolean isTable() {
        return this.m_nType == 3 && this.a;
    }

    public boolean isCellInRange(int n2, int n3) {
        return this.a && (this.m_nType == 2 && this.left <= n3 && n3 <= this.right || this.m_nType == 1 && this.top <= n2 && n2 <= this.bottom || this.m_nType == 3 || this.m_nType == 0 && this.top <= n2 && n2 <= this.bottom && this.left <= n3 && n3 <= this.right);
    }

    public boolean intersects(GXRange gXRange) {
        return gXRange.right > this.left && gXRange.bottom > this.top && gXRange.left < this.right && gXRange.top < this.bottom;
    }

    public boolean equals(GXRange gXRange) {
        return this.m_nType == gXRange.m_nType && this.a == gXRange.a && this.top == gXRange.top && this.bottom == gXRange.bottom && this.left == gXRange.left && this.right == gXRange.right;
    }

    public synchronized Object clone() {
        try {
            GXRange gXRange = (GXRange)super.clone();
            return gXRange;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }
}

