/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.factorycast.ServerChangeListener;
import com.schneiderautomation.gde.BeanErrorHandler;
import com.schneiderautomation.gde.BeanLoader;
import com.schneiderautomation.gde.ErrorHandler;
import com.schneiderautomation.gde.GdeApplet;
import com.schneiderautomation.gde.GdeEditor;
import com.schneiderautomation.gde.GdeStrings;
import com.schneiderautomation.gde.GdeTopPanel;
import com.schneiderautomation.gde.GraphicalObject;
import com.schneiderautomation.gde.ObjectDescriptor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.Beans;
import java.io.IOException;
import java.io.Serializable;

public class Wrapper
extends Panel
implements MouseListener,
MouseMotionListener,
BeanErrorHandler,
Serializable {
    static final long serialVersionUID = -3043007821280925382L;
    public static int BORDER_WIDTH = -1;
    public static int BORDER_WIDTH_X2 = BORDER_WIDTH * 2;
    static final int MAX_WRAPPER_SIZE = 800;
    static final int NEWBORDER = 10;
    private static transient Image border1;
    private static transient Image border2;
    private static transient Image border3;
    private transient boolean selected;
    private transient boolean fErrorState;
    private transient GdeApplet applet;
    private transient CommBean comm;

    Wrapper(ObjectDescriptor objectDescriptor, int n) throws ClassNotFoundException, IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Component component = (Component)Beans.instantiate(classLoader, objectDescriptor.name);
        this.setName(objectDescriptor.label);
        component.setName(objectDescriptor.label + " " + n);
        this.setLayout(null);
        this.add(component);
        this.addMouseListeners(this);
    }

    void connect(GdeApplet gdeApplet) {
        this.applet = gdeApplet;
        this.addComponentListener(gdeApplet);
        this.connect(gdeApplet.comm);
    }

    void connect(CommBean commBean) {
        this.comm = commBean;
        this.connectBean();
    }

    void disconnect() {
        this.disconnectBean();
        if (this.applet != null) {
            this.removeComponentListener(this.applet);
        }
    }

    void setUserInputEnabled(boolean bl) {
        GraphicalObject graphicalObject = this.getGraphicalObject();
        if (graphicalObject != null) {
            if (bl) {
                graphicalObject.enableUserInput();
            } else {
                graphicalObject.disableUserInput();
            }
        }
    }

    Component getBean() {
        return this.getComponents()[0];
    }

    GraphicalObject getGraphicalObject() {
        try {
            return (GraphicalObject)((Object)this.getBean());
        }
        catch (ClassCastException classCastException) {
            return null;
        }
    }

    boolean isSelected() {
        return this.selected;
    }

    void setSelected(boolean bl) {
        this.selected = bl;
        this.repaint();
    }

    void setErrorStatus(boolean bl) {
        this.fErrorState = bl;
        if (this.fErrorState) {
            GdeTopPanel.bWidgeterror = true;
        }
        this.repaint();
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        this.getBean().setBounds(BORDER_WIDTH, BORDER_WIDTH, n3 - BORDER_WIDTH_X2, n4 - BORDER_WIDTH_X2);
        Dimension dimension = this.getBean().getSize();
        super.setBounds(n, n2, dimension.width + BORDER_WIDTH_X2, dimension.height + BORDER_WIDTH_X2);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        graphics.setColor(this.getBackground());
        if (this.selected) {
            if (this.applet.editorPanel.bb.reference == this) {
                if (border1 == null) {
                    border1 = Wrapper.createBorder(this, Color.blue);
                }
                graphics.drawImage(border1, 0, 0, null);
            } else {
                if (border2 == null) {
                    border2 = Wrapper.createBorder(this, Color.black);
                }
                graphics.drawImage(border2, 0, 0, null);
            }
            Rectangle rectangle = this.getBean().getBounds();
            rectangle.grow(1, 1);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        } else if (this.fErrorState) {
            if (this.applet != null) {
                if (!this.applet.fEditMode) {
                    if (border3 == null) {
                        border3 = Wrapper.createBorder(this, Color.magenta);
                    }
                    graphics.drawImage(border3, 0, 0, null);
                    Rectangle rectangle = this.getBean().getBounds();
                    graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
            } else {
                if (border3 == null) {
                    border3 = Wrapper.createBorder(this, Color.magenta);
                }
                graphics.drawImage(border3, 0, 0, null);
                Rectangle rectangle = this.getBean().getBounds();
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        } else {
            Dimension dimension = this.getSize();
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        super.paint(graphics);
    }

    public void reportStatus(String string, String string2) {
        GraphicalObject graphicalObject = this.getGraphicalObject();
        if (graphicalObject != null) {
            this.setErrorStatus(graphicalObject.isErrorStatus());
        }
        if (string2 != null) {
            Object[] objectArray = new Object[]{string, string2};
            this.printBeanError(GdeStrings.getFormattedString("BEAN_STATUS", objectArray));
        }
        this.getBean().repaint();
    }

    public void reportReadError(String string, String string2) {
        if (string2 == null) {
            string2 = "???";
        }
        Object[] objectArray = new Object[]{string, string2};
        this.printBeanError(GdeStrings.getFormattedString("BEAN_READ_ERROR", objectArray));
    }

    public void reportWriteError(String string, String string2) {
        if (string2 == null) {
            string2 = "???";
        }
        Object[] objectArray = new Object[]{string, string2};
        this.printBeanError(GdeStrings.getFormattedString("BEAN_WRITE_ERROR", objectArray));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.applet != null && this.applet.idBeanInsert < 0 && this.applet.fEditMode) {
            Component component = (Component)mouseEvent.getSource();
            Dimension dimension = this.getSize();
            if (mouseEvent.getX() < 10) {
                if (mouseEvent.getY() < 10) {
                    component.setCursor(GdeEditor.NW_RESIZE_CURSOR);
                } else if (mouseEvent.getY() >= dimension.height - 10) {
                    component.setCursor(GdeEditor.SW_RESIZE_CURSOR);
                } else {
                    component.setCursor(GdeEditor.W_RESIZE_CURSOR);
                }
            } else if (mouseEvent.getX() >= dimension.width - 10) {
                if (mouseEvent.getY() < 10) {
                    component.setCursor(GdeEditor.NE_RESIZE_CURSOR);
                } else if (mouseEvent.getY() >= dimension.height - 10) {
                    component.setCursor(GdeEditor.SE_RESIZE_CURSOR);
                } else {
                    component.setCursor(GdeEditor.E_RESIZE_CURSOR);
                }
            } else if (mouseEvent.getY() < 10) {
                component.setCursor(GdeEditor.N_RESIZE_CURSOR);
            } else if (mouseEvent.getY() >= dimension.height - 10) {
                component.setCursor(GdeEditor.S_RESIZE_CURSOR);
            }
            if (mouseEvent.getX() > 10 && mouseEvent.getX() < dimension.width - 10 && mouseEvent.getY() > 10 && mouseEvent.getY() < dimension.height - 10) {
                component.setCursor(GdeEditor.MOVE_CURSOR);
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.applet != null && this.applet.idBeanInsert < 0 && this.applet.fEditMode) {
            if (mouseEvent.getClickCount() == 1) {
                if (mouseEvent.isControlDown()) {
                    if (this.selected) {
                        this.applet.editorPanel.bb.unsetCurrentComponent(this);
                    } else {
                        this.applet.editorPanel.bb.setCurrentComponent(this, false);
                    }
                } else {
                    this.applet.editorPanel.bb.setCurrentComponent(this, !mouseEvent.isShiftDown());
                }
                this.mouseMoved(mouseEvent);
            } else if (mouseEvent.getClickCount() == 2) {
                if (BeanLoader.getCustomizerClass(this.getBean().getClass()) != null) {
                    this.applet.showCustomizer();
                } else {
                    this.applet.showPropertySheet();
                }
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.applet != null && this.applet.idBeanInsert < 0 && this.applet.fEditMode && this.selected) {
            Component component = (Component)mouseEvent.getSource();
            if (component != this) {
                component.setCursor(GdeEditor.MOVE_CURSOR);
                this.setCursor(GdeEditor.MOVE_CURSOR);
                this.setResizeCursor(mouseEvent.getX(), mouseEvent.getY());
            } else if (this.getBean().getBounds().contains(mouseEvent.getPoint())) {
                this.setCursor(GdeEditor.MOVE_CURSOR);
                this.setResizeCursor(mouseEvent.getX(), mouseEvent.getY());
            } else {
                this.setResizeCursor(mouseEvent.getX(), mouseEvent.getY());
            }
            this.applet.editorPanel.bb.startDrag(this, this.getCursor(), mouseEvent);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.applet != null && this.applet.idBeanInsert < 0) {
            this.applet.editorPanel.bb.doDrag(mouseEvent);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.applet != null && this.applet.idBeanInsert < 0) {
            this.applet.editorPanel.bb.endDrag();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void printBeanError(String string) {
        if (this.applet != null && this.applet.statusOut != null) {
            this.applet.statusOut.printErr(string);
        } else {
            ErrorHandler.report(string);
        }
    }

    private void connectBean() {
        GraphicalObject graphicalObject = this.getGraphicalObject();
        if (graphicalObject != null && this.comm != null) {
            this.comm.addServerChangeListener((ServerChangeListener)graphicalObject);
        }
    }

    private void disconnectBean() {
        GraphicalObject graphicalObject = this.getGraphicalObject();
        if (graphicalObject != null && this.comm != null) {
            this.comm.removeServerChangeListener((ServerChangeListener)graphicalObject);
        }
    }

    private void setResizeCursor(int n, int n2) {
        Dimension dimension = this.getSize();
        if (n < 10) {
            if (n2 < 10) {
                this.setCursor(GdeEditor.NW_RESIZE_CURSOR);
            } else if (n2 >= dimension.height - 10) {
                this.setCursor(GdeEditor.SW_RESIZE_CURSOR);
            } else {
                this.setCursor(GdeEditor.W_RESIZE_CURSOR);
            }
        } else if (n >= dimension.width - 10) {
            if (n2 < 10) {
                this.setCursor(GdeEditor.NE_RESIZE_CURSOR);
            } else if (n2 >= dimension.height - 10) {
                this.setCursor(GdeEditor.SE_RESIZE_CURSOR);
            } else {
                this.setCursor(GdeEditor.E_RESIZE_CURSOR);
            }
        } else if (n2 < 10) {
            this.setCursor(GdeEditor.N_RESIZE_CURSOR);
        } else if (n2 >= dimension.height - 10) {
            this.setCursor(GdeEditor.S_RESIZE_CURSOR);
        }
    }

    private static final synchronized Image createBorder(Component component, Color color) {
        Image image = component.createImage(800, 800);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, 800, 800);
        graphics.setColor(color);
        for (int i = 0; i < 1600; i += 2) {
            graphics.drawLine(0, i, i, 0);
        }
        graphics.dispose();
        return image;
    }

    private final void addMouseListeners(Container container) {
        container.addMouseListener(this);
        container.addMouseMotionListener(this);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                this.addMouseListeners((Container)componentArray[i]);
                continue;
            }
            componentArray[i].addMouseListener(this);
            componentArray[i].addMouseMotionListener(this);
        }
    }
}

