/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.navigator;

import com.schneiderautomation.dt.DT;
import com.schneiderautomation.namespace.VarLookupInterface;
import com.schneiderautomation.navigator.VarList;
import com.schneiderautomation.navigator.VarSelectEvent;
import com.schneiderautomation.navigator.VarSelectOwner;
import com.schneiderautomation.navigator.VarSortVector;
import com.schneiderautomation.vars.SymbolItem;
import com.schneiderautomation.vars.VarInfo;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.TextEvent;
import java.awt.event.TextListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class VarSelect
extends Dialog
implements Runnable,
ActionListener,
TextListener,
ItemListener {
    private static ResourceBundle strings;
    private static final short VT_STRUCT = 2;
    private static final int WIDTH_NAME = 150;
    private static final int WIDTH_TYPE = 70;
    private static final String SPACES;
    private FontMetrics fm;
    private int cxSpace = 1;
    private VarList varList;
    private TextField varNameFilter;
    private Checkbox varTypeFilter;
    private Button okButton;
    private Button applyButton;
    private Button cancelButton;
    private VarLookupInterface varLookup;
    private VarSelectOwner owner;
    private Thread engine;
    private VarSortVector vars;
    private BitSet dtFilter;
    private boolean filtered;
    private int nameFilterModified;

    public VarSelect(Frame frame, VarSelectOwner varSelectOwner, boolean bl, boolean bl2, Locale locale) {
        super(frame, bl);
        this.owner = varSelectOwner;
        try {
            this.setLocale(locale);
            strings = ResourceBundle.getBundle("com.schneiderautomation.navigator.VarSelectStrBundle", this.getLocale());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.varList = new VarList(bl2);
        this.varNameFilter = new TextField(15);
        this.varTypeFilter = new Checkbox(this.getString("TYPEFILT_LBL"));
        this.okButton = new Button(this.getString("OK_BTN_LBL"));
        this.applyButton = new Button(this.getString("APPLY_BTN_LBL"));
        this.cancelButton = new Button(this.getString("CANCEL_BTN_LBL"));
        this.vars = new VarSortVector();
        this.varNameFilter.addTextListener(this);
        this.varTypeFilter.addItemListener(this);
        this.okButton.addActionListener(this);
        this.applyButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.varList.addActionListener(this);
        this.varList.addItemListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                VarSelect.this.dispose();
            }

            public void windowClosed(WindowEvent windowEvent) {
                VarSelect.this.stop();
                VarSelect.this.owner.varSelectClosed();
            }
        });
        Panel panel = new Panel();
        panel.add(this.okButton);
        if (!bl) {
            panel.add(this.applyButton);
        }
        panel.add(this.cancelButton);
        ((Component)this).setBackground(Color.lightGray);
        this.setTitle(this.getString("TITLE"));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.add((Component)new Label(this.getString("SHOW_ONLY_LBL")), gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.add((Component)this.varNameFilter, gridBagConstraints);
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.add((Component)this.varTypeFilter, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)this.varList, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.add((Component)panel, gridBagConstraints);
        this.setResizable(false);
        this.pack();
        Insets insets = this.getInsets();
        Dimension dimension = this.getSize();
        ((Component)this).setSize(dimension.width, dimension.height + insets.bottom);
        this.fm = this.getFontMetrics(this.varList.getFont());
        this.cxSpace = this.fm.stringWidth(" ");
    }

    public synchronized void setDatatypeFilter(BitSet bitSet) {
        this.dtFilter = bitSet;
        this.filtered = false;
    }

    public void showMe() {
        this.filterVars();
        this.start();
        this.show();
    }

    public void hideMe() {
        this.dispose();
    }

    public synchronized void initSelection(VarLookupInterface varLookupInterface) throws Exception {
        this.varLookup = varLookupInterface;
        this.vars.removeAllElements();
        this.filtered = false;
        Enumeration enumeration = varLookupInterface.getSymbols();
        while (enumeration.hasMoreElements()) {
            this.vars.addElement((VarInfo)enumeration.nextElement());
        }
    }

    public synchronized String[] getSelection() {
        int[] nArray = this.varList.getSelectedIndexes();
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            this.varList.deselect(nArray[i]);
            String string = this.varList.getItem(nArray[i]);
            stringArray[i] = string.substring(0, string.indexOf(" "));
        }
        this.okButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        return stringArray;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String[] stringArray = this.getSelection();
        if (actionEvent.getSource() != this.cancelButton && stringArray.length > 0) {
            this.owner.varSelectionPerformed(new VarSelectEvent((Object)this, stringArray));
        }
        if (actionEvent.getSource() != this.applyButton) {
            this.dispose();
        }
    }

    public synchronized void textValueChanged(TextEvent textEvent) {
        this.filtered = false;
        this.nameFilterModified = 1;
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.varTypeFilter) {
            this.filtered = false;
            this.filterVars();
        } else {
            boolean bl = this.varList.getSelectedIndexes().length > 0;
            this.okButton.setEnabled(bl);
            this.applyButton.setEnabled(bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.engine != null) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            VarSelect varSelect = this;
            synchronized (varSelect) {
                if (this.nameFilterModified > 0 && ++this.nameFilterModified > 8) {
                    this.nameFilterModified = 0;
                    this.filterVars();
                }
            }
        }
    }

    private synchronized void filterVars() {
        if (!this.filtered) {
            this.filtered = true;
            this.okButton.setEnabled(false);
            this.applyButton.setEnabled(false);
            String string = this.varNameFilter.getText().toLowerCase();
            boolean bl = this.varTypeFilter.getState();
            this.varList.delItems(0, this.varList.getItemCount() - 1);
            for (int i = 0; i < this.vars.size(); ++i) {
                VarInfo varInfo = this.vars.elementAt(i);
                String string2 = varInfo.getName();
                if (this.dtFilter != null && !this.dtFilter.get(varInfo.getDataType()) || string.length() != 0 && !string2.toLowerCase().startsWith(string) || bl && varInfo.getVariableType() == 2) continue;
                StringBuffer stringBuffer = new StringBuffer(string2);
                StringBuffer stringBuffer2 = new StringBuffer(DT.typeNames[varInfo.getDataType()]);
                StringBuffer stringBuffer3 = new StringBuffer();
                if (varInfo instanceof SymbolItem) {
                    stringBuffer3.append(((SymbolItem)varInfo).getComments());
                    if (stringBuffer3.length() > 0) {
                        this.padColumn(stringBuffer2, 70);
                    }
                }
                this.padColumn(stringBuffer, 150);
                this.varList.add(stringBuffer.toString() + stringBuffer2.toString() + stringBuffer3.toString());
            }
        }
    }

    private void padColumn(StringBuffer stringBuffer, int n) {
        stringBuffer.append(" ");
        int n2 = (n - this.fm.stringWidth(stringBuffer.toString())) / this.cxSpace;
        if (n2 > 0) {
            stringBuffer.append(SPACES.substring(0, n2));
        }
    }

    private void start() {
        if (this.engine == null) {
            this.engine = new Thread(this);
            this.engine.start();
        }
    }

    private void stop() {
        if (this.engine != null) {
            Thread thread = this.engine;
            this.engine = null;
            try {
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private String getString(String string) {
        try {
            return strings != null ? strings.getString(string) : "resources not loaded";
        }
        catch (MissingResourceException missingResourceException) {
            return "<" + string + ">";
        }
    }

    static {
        StringBuffer stringBuffer = new StringBuffer();
        while (stringBuffer.length() < 150) {
            stringBuffer.append("          ");
        }
        SPACES = new String(stringBuffer);
    }
}

