/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.gde.ColorEditor;
import java.awt.Canvas;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;

class ColorEditorPanel
extends Panel
implements FocusListener,
ItemListener,
ActionListener {
    private static final String[] colorNames = new String[]{"<R,G,B", "white", "light gray", "gray", "dark gray", "black", "red", "pink", "orange", "yellow", "green", "magenta", "cyan", "blue"};
    private static final Color[] colorValues = new Color[]{null, Color.white, Color.lightGray, Color.gray, Color.darkGray, Color.black, Color.red, Color.pink, Color.orange, Color.yellow, Color.green, Color.magenta, Color.cyan, Color.blue};
    private SampleCanvas colorPad = new SampleCanvas();
    private TextField rgbText = new TextField(12);
    private Choice colorList = new Choice();
    private ColorEditor editor;

    ColorEditorPanel(ColorEditor colorEditor) {
        int n;
        this.editor = colorEditor;
        Color color = (Color)colorEditor.getValue();
        this.setBackground(Color.lightGray);
        this.colorPad.setSize(48, 20);
        this.colorPad.setForeground(Color.black);
        this.colorPad.setBackground(color);
        this.rgbText.setText(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
        for (n = 0; n < colorNames.length; ++n) {
            this.colorList.add(colorNames[n]);
        }
        this.colorList.select(0);
        for (n = 1; n < colorValues.length; ++n) {
            if (!color.equals(colorValues[n])) continue;
            this.colorList.select(n);
            this.rgbText.setEnabled(false);
            break;
        }
        this.rgbText.addFocusListener(this);
        this.rgbText.addActionListener(this);
        this.colorList.addItemListener(this);
        this.setLayout(new FlowLayout(1, 8, 0));
        this.add(this.colorPad);
        this.add(this.rgbText);
        this.add(this.colorList);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            Color color = colorValues[this.colorList.getSelectedIndex()];
            if (color != null) {
                this.rgbText.setText(color.getRed() + "," + color.getGreen() + "," + color.getBlue());
                this.rgbText.setEnabled(false);
                this.setValue(color);
            } else {
                this.rgbText.setEnabled(true);
            }
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        this.setWithRGBText();
    }

    public void focusLost(FocusEvent focusEvent) {
        this.setWithRGBText();
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    private void setWithRGBText() {
        if (this.rgbText.isEnabled()) {
            try {
                StringTokenizer stringTokenizer = new StringTokenizer(this.rgbText.getText(), ",");
                int n = Integer.parseInt(stringTokenizer.nextToken());
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                this.setValue(new Color(n, n2, n3));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void setValue(Color color) {
        this.colorPad.setBackground(color);
        this.colorPad.repaint();
        this.editor.setValue(color);
        this.editor.firePropertyChange();
    }

    private class SampleCanvas
    extends Canvas {
        private SampleCanvas() {
        }

        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(this.getForeground());
            graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
        }
    }
}

