/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.gde.FontEditor;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;

class FontEditorPanel
extends Panel
implements ItemListener {
    private static final String[] fontNames = Toolkit.getDefaultToolkit().getFontList();
    private static final int[] fontSizes = new int[]{8, 10, 12, 14, 16, 18, 20, 24, 36, 48};
    private Choice nameList = new Choice();
    private Checkbox boldChkbox = new Checkbox("Bold");
    private Checkbox italChkbox = new Checkbox("Italic");
    private Choice sizeList = new Choice();
    private FontEditor editor;

    FontEditorPanel(FontEditor fontEditor) {
        int n;
        this.editor = fontEditor;
        Font font = (Font)fontEditor.getValue();
        this.setBackground(Color.lightGray);
        for (n = 0; n < fontNames.length; ++n) {
            this.nameList.add(fontNames[n]);
        }
        for (n = 0; n < fontSizes.length; ++n) {
            this.sizeList.add(String.valueOf(fontSizes[n]));
        }
        this.nameList.select(0);
        for (n = 0; n < fontNames.length; ++n) {
            if (!font.getFamily().equalsIgnoreCase(fontNames[n])) continue;
            this.nameList.select(n);
            break;
        }
        this.sizeList.select(0);
        for (n = 0; n < fontSizes.length; ++n) {
            if (font.getSize() != fontSizes[n]) continue;
            this.sizeList.select(n);
            break;
        }
        this.boldChkbox.setState(font.isBold());
        this.italChkbox.setState(font.isItalic());
        this.nameList.addItemListener(this);
        this.boldChkbox.addItemListener(this);
        this.italChkbox.addItemListener(this);
        this.sizeList.addItemListener(this);
        this.setLayout(new FlowLayout(1, 8, 0));
        this.add(this.nameList);
        this.add(this.sizeList);
        this.add(this.boldChkbox);
        this.add(this.italChkbox);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        boolean bl;
        boolean bl2 = bl = (itemEvent.getSource() == this.nameList || itemEvent.getSource() == this.sizeList) && itemEvent.getStateChange() == 2;
        if (!bl) {
            String string = fontNames[this.nameList.getSelectedIndex()];
            int n = fontSizes[this.sizeList.getSelectedIndex()];
            int n2 = (this.boldChkbox.getState() ? 1 : 0) + (this.italChkbox.getState() ? 2 : 0);
            this.editor.setValue(new Font(string, n2, n));
            this.editor.firePropertyChange();
        }
    }
}

