/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.factorycast.CommBean;
import com.schneiderautomation.gde.GdeApplet;
import com.schneiderautomation.gde.GdeStrings;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

class GdeControlPanel
extends Panel
implements PropertyChangeListener {
    private TextField plcname = new TextField(20);
    private Button connButton;
    private Button disconnButton;
    private Button startButton;
    private Button stopButton;
    private Button suspendButton;
    private Button resumeButton;
    private CommBean comm;
    private GdeApplet applet;

    GdeControlPanel(GdeApplet gdeApplet) {
        this.applet = gdeApplet;
        this.comm = gdeApplet.comm;
        this.comm.addPropertyChangeListener((PropertyChangeListener)this);
        Label label = new Label("PLC:");
        label.setAlignment(2);
        this.connButton = new Button(GdeStrings.getString("CONN_LBL"));
        this.disconnButton = new Button(GdeStrings.getString("DISCONN_LBL"));
        this.startButton = new Button(GdeStrings.getString("START_LBL"));
        this.stopButton = new Button(GdeStrings.getString("STOP_LBL"));
        this.suspendButton = new Button(GdeStrings.getString("SUSPEND_LBL"));
        this.resumeButton = new Button(GdeStrings.getString("RESUME_LBL"));
        this.connButton.addActionListener(new ConnectAdaptor());
        this.disconnButton.addActionListener(new DisconnectAdaptor());
        this.startButton.addActionListener(new StartAdaptor());
        this.stopButton.addActionListener(new StopAdaptor());
        this.suspendButton.addActionListener(new SuspendAdaptor());
        this.resumeButton.addActionListener(new ResumeAdaptor());
        this.disconnButton.setEnabled(false);
        this.startButton.setEnabled(false);
        this.stopButton.setEnabled(false);
        this.suspendButton.setEnabled(false);
        this.resumeButton.setEnabled(false);
        this.setBackground(Color.lightGray);
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(0);
        this.setLayout(flowLayout);
        this.add(label);
        this.add(this.plcname);
        this.add(this.connButton);
        this.add(this.disconnButton);
        this.add(this.startButton);
        this.add(this.stopButton);
        this.add(this.resumeButton);
        this.add(this.suspendButton);
    }

    void setHostName(String string) {
        this.plcname.setText(string);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("started")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.startButton.setEnabled(!bl && this.comm.isConnected());
            this.stopButton.setEnabled(bl && this.comm.isConnected());
        } else if (string.equals("suspended")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.suspendButton.setEnabled(!bl && this.comm.isConnected());
            this.resumeButton.setEnabled(bl && this.comm.isConnected());
        } else if (string.equals("connected")) {
            boolean bl = (Boolean)propertyChangeEvent.getNewValue();
            this.connButton.setEnabled(!bl);
            this.plcname.setEnabled(!bl);
            this.disconnButton.setEnabled(bl);
            this.startButton.setEnabled(bl && !this.comm.isStarted());
            this.stopButton.setEnabled(bl && this.comm.isStarted());
            this.suspendButton.setEnabled(bl && !this.comm.isSuspended());
            this.resumeButton.setEnabled(bl && this.comm.isSuspended());
        }
    }

    class ResumeAdaptor
    implements ActionListener {
        ResumeAdaptor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GdeControlPanel.this.comm.resume();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class SuspendAdaptor
    implements ActionListener {
        SuspendAdaptor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GdeControlPanel.this.comm.suspend();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    class StopAdaptor
    implements ActionListener {
        StopAdaptor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GdeControlPanel.this.comm.stop();
        }
    }

    class StartAdaptor
    implements ActionListener {
        StartAdaptor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GdeControlPanel.this.comm.start();
        }
    }

    class DisconnectAdaptor
    implements ActionListener {
        DisconnectAdaptor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GdeControlPanel.this.applet.disconnect();
        }
    }

    class ConnectAdaptor
    implements ActionListener {
        ConnectAdaptor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GdeControlPanel.this.connButton.setEnabled(false);
            GdeControlPanel.this.plcname.setEnabled(false);
            if (!GdeControlPanel.this.applet.connect(GdeControlPanel.this.plcname.getText())) {
                GdeControlPanel.this.connButton.setEnabled(true);
                GdeControlPanel.this.plcname.setEnabled(true);
            }
        }
    }
}

