/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.WebDesigner.ICustomPageIntegrator;
import com.schneiderautomation.WebDesigner.WebDesignerSimu;
import com.schneiderautomation.ftpsession.FTPSession;
import com.schneiderautomation.ftpsession.FtpSessionException;
import com.schneiderautomation.gde.BeanBox;
import com.schneiderautomation.gde.GdeApplet;
import com.schneiderautomation.misc.GlobalConfig;
import com.schneiderautomation.misc.TextFiles;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.io.StreamCorruptedException;
import java.util.Locale;

public class GdeDisplayList {
    private static final String USER = "sysdiag";
    private static final String PASSWORD = "factorycast@schneider";
    private static final String GDT_DIR = "/gdt";
    private static final String EXTENSION = ".gdt";
    private static final String PW_FILE = "/rdt/password.rde";
    private String m_ftpRoot = GlobalConfig.getFtpRoot();
    private String host;
    private Locale locale;
    private TextFiles textFiles;
    private ICustomPageIntegrator webDesignerSimu;
    private FileInputStream fin = null;
    private FileOutputStream fout = null;

    GdeDisplayList(Locale locale) {
        if (!GdeApplet.m_isApplet) {
            this.webDesignerSimu = new WebDesignerSimu();
        }
        this.locale = locale;
    }

    void connect(String string) throws IOException {
        this.host = string;
        this.textFiles = new TextFiles(string, this.locale);
    }

    void disconnect() {
        if (this.textFiles != null) {
            this.textFiles = null;
        }
    }

    public String getPassword() throws IOException {
        String[] stringArray = this.textFiles.get(this.m_ftpRoot + PW_FILE);
        return stringArray.length > 0 ? stringArray[0] : null;
    }

    String[] list() throws IOException {
        if (!GdeApplet.m_isApplet) {
            File file = new File(this.webDesignerSimu.getFilePath());
            String[] stringArray = file.list();
            String[] stringArray2 = new String[stringArray.length];
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                int n = stringArray[i].indexOf(".");
                stringArray2[i] = string = stringArray[i].substring(0, n).trim();
            }
            return stringArray2;
        }
        return this.textFiles.list(this.m_ftpRoot + GDT_DIR, EXTENSION);
    }

    void delete(String string) throws IOException {
        this.textFiles.delete(this.makeFileName(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BeanBox get(String string) throws IOException {
        BeanBox beanBox = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            FTPSession fTPSession = new FTPSession(this.locale);
            fTPSession.connectHost(this.host);
            try {
                Object object;
                fTPSession.login(USER, PASSWORD);
                fTPSession.setTransferMode(1);
                if (!GdeApplet.m_isApplet) {
                    object = this.webDesignerSimu.getFilePath() + string + EXTENSION;
                    this.fin = new FileInputStream((String)object);
                    bufferedInputStream = new BufferedInputStream(this.fin);
                } else {
                    bufferedInputStream = fTPSession.getFile(this.makeFileName(string));
                }
                try {
                    object = new ObjectInputStream(bufferedInputStream);
                    beanBox = (BeanBox)((ObjectInputStream)object).readObject();
                    Object var7_12 = null;
                }
                catch (Throwable throwable) {
                    Object var7_13 = null;
                    try {
                        bufferedInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (GdeApplet.m_isApplet) {
                            fTPSession.readComplete();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (GdeApplet.m_isApplet) {
                        fTPSession.readComplete();
                    }
                }
                catch (Exception exception) {}
            }
            finally {
                try {
                    if (GdeApplet.m_isApplet) {
                        fTPSession.quit();
                    }
                }
                catch (Exception exception) {}
            }
        }
        catch (FtpSessionException ftpSessionException) {
            throw new IOException(ftpSessionException.getMessage());
        }
        catch (StreamCorruptedException streamCorruptedException) {
            throw new IOException(streamCorruptedException.getMessage());
        }
        catch (InvalidClassException invalidClassException) {
            throw new IOException(invalidClassException.getMessage());
        }
        catch (OptionalDataException optionalDataException) {
            throw new IOException(optionalDataException.getMessage());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IOException(classNotFoundException.getMessage());
        }
        return beanBox;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(String string, BeanBox beanBox) throws IOException {
        BufferedOutputStream bufferedOutputStream = null;
        try {
            FTPSession fTPSession = new FTPSession(this.locale);
            fTPSession.connectHost(this.host);
            try {
                Object object;
                fTPSession.login(USER, PASSWORD);
                fTPSession.setTransferMode(1);
                if (!GdeApplet.m_isApplet) {
                    object = this.webDesignerSimu.getFilePath() + string + EXTENSION;
                    this.fout = new FileOutputStream((String)object);
                    bufferedOutputStream = new BufferedOutputStream(this.fout);
                    this.webDesignerSimu.refreshTreeView();
                } else {
                    bufferedOutputStream = fTPSession.putFile(this.makeFileName(string));
                }
                try {
                    object = new ObjectOutputStream(bufferedOutputStream);
                    ((ObjectOutputStream)object).writeObject(beanBox);
                    Object var7_10 = null;
                }
                catch (Throwable throwable) {
                    Object var7_11 = null;
                    try {
                        bufferedOutputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        if (GdeApplet.m_isApplet) {
                            fTPSession.writeComplete();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    bufferedOutputStream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (GdeApplet.m_isApplet) {
                        fTPSession.writeComplete();
                    }
                }
                catch (Exception exception) {}
            }
            finally {
                try {
                    fTPSession.quit();
                }
                catch (Exception exception) {}
            }
        }
        catch (FtpSessionException ftpSessionException) {
            throw new IOException(ftpSessionException.getMessage());
        }
        catch (InvalidClassException invalidClassException) {
            throw new IOException(invalidClassException.getMessage());
        }
        catch (NotSerializableException notSerializableException) {
            throw new IOException(notSerializableException.getMessage());
        }
    }

    private final String makeFileName(String string) {
        return this.m_ftpRoot + GDT_DIR + "/" + string + EXTENSION;
    }
}

