/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.gde.BeanBox;
import com.schneiderautomation.gde.ErrorHandler;
import com.schneiderautomation.gde.GdeApplet;
import com.schneiderautomation.gde.GdeMsgArea;
import com.schneiderautomation.gde.GdeScrollPane;
import com.schneiderautomation.gde.GdeStrings;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.io.IOException;
import java.util.Vector;

public class GdeEditor
extends GdeScrollPane
implements ComponentListener {
    static final Cursor WAIT_CURSOR = Cursor.getPredefinedCursor(3);
    static final Cursor SELECT_CURSOR = Cursor.getPredefinedCursor(0);
    static final Cursor INSERT_CURSOR = Cursor.getPredefinedCursor(1);
    static final Cursor MOVE_CURSOR = Cursor.getPredefinedCursor(13);
    static final Cursor NW_RESIZE_CURSOR = Cursor.getPredefinedCursor(6);
    static final Cursor NE_RESIZE_CURSOR = Cursor.getPredefinedCursor(7);
    static final Cursor SW_RESIZE_CURSOR = Cursor.getPredefinedCursor(4);
    static final Cursor SE_RESIZE_CURSOR = Cursor.getPredefinedCursor(5);
    static final Cursor N_RESIZE_CURSOR = Cursor.getPredefinedCursor(8);
    static final Cursor E_RESIZE_CURSOR = Cursor.getPredefinedCursor(11);
    static final Cursor S_RESIZE_CURSOR = Cursor.getPredefinedCursor(9);
    static final Cursor W_RESIZE_CURSOR = Cursor.getPredefinedCursor(10);
    private GdeApplet applet;
    private GdeMsgArea statusOut;
    private Panel bbPanel;
    Vector clipboard = new Vector();
    BeanBox bb;
    boolean fGrid = false;
    boolean fSnap = false;
    int cxGrid = 20;
    int cyGrid = 20;

    GdeEditor(GdeApplet gdeApplet, GdeMsgArea gdeMsgArea) {
        this.applet = gdeApplet;
        this.statusOut = gdeMsgArea;
        this.getHAdjustable().setUnitIncrement(10);
        this.getVAdjustable().setUnitIncrement(10);
        this.setBackground(Color.lightGray);
        this.bbPanel = new Panel();
        this.bbPanel.setLayout(new GridLayout(1, 1));
        this.bb = new BeanBox(gdeApplet, this, gdeMsgArea);
        this.bb.setBackground(Color.white);
        this.bbPanel.add(this.bb);
        this.add(this.bbPanel);
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.doLayout();
        this.bb.resetGrid();
    }

    void editModeChanged() {
        this.backgroundChanged();
        this.bb.repaintAll();
    }

    void backgroundChanged() {
        Color color = this.bb.getBackground();
        if (this.applet.fEditMode) {
            color = new Color(~color.getRGB());
        }
        this.bbPanel.setBackground(color);
        this.bbPanel.repaint();
    }

    synchronized void passwordEntered(boolean bl) {
        this.bb.setUserInputEnabled(bl);
    }

    synchronized void loadDisplay(String string) {
        this.bb.disconnect();
        if (string == null) {
            this.bb = new BeanBox(this.applet, this, this.statusOut);
            this.bb.setBackground(Color.white);
        } else {
            try {
                this.bb = this.applet.gdtFiles.get(string);
                this.bb.setUserInputEnabled(true);
                this.bb.connect(this.applet, this, this.statusOut);
                this.bbPanel.setBackground(this.bb.getBackground());
            }
            catch (IOException iOException) {
                String string2 = iOException.getMessage() != null ? iOException.getMessage() : iOException.toString();
                Object[] objectArray = new Object[]{string, string2};
                String string3 = GdeStrings.getFormattedString("LOAD_ERROR", objectArray);
                if (this.statusOut != null) {
                    this.statusOut.printErr(string3);
                } else {
                    ErrorHandler.report(string3);
                }
                this.bb = new BeanBox(this.applet, this, this.statusOut);
                this.bb.setBackground(Color.magenta);
            }
        }
        this.bbPanel.remove(0);
        this.bbPanel.setSize(this.bb.getSize());
        Dimension dimension = this.bb.getSize();
        this.bb.setSize(0, 0);
        this.bbPanel.add(this.bb);
        this.bb.setSize(dimension);
        this.bbPanel.doLayout();
        this.doLayout();
        if (this.bb.getSize().width == 0 || this.bb.getSize().height == 0) {
            this.bbPanel.doLayout();
        }
        this.bb.setUserInputEnabled(false);
        this.bb.repaintAll();
        this.bbPanel.repaint();
        this.applet.fModified = false;
    }

    void setWaitCursor() {
        GdeEditor.setCursor(this.bb, WAIT_CURSOR);
    }

    void setDefaultCursor() {
        GdeEditor.setCursor(this.bb, SELECT_CURSOR);
    }

    static void setCursor(Container container, Cursor cursor) {
        container.setCursor(cursor);
        Component[] componentArray = container.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] instanceof Container) {
                GdeEditor.setCursor((Container)componentArray[i], cursor);
                continue;
            }
            componentArray[i].setCursor(cursor);
        }
    }
}

