/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.gde;

import com.schneiderautomation.factorycast.AddressEditor;
import com.schneiderautomation.gde.AddressViewPanel;
import com.schneiderautomation.gde.BeanLoader;
import com.schneiderautomation.gde.GdePropertyEditorManager;
import com.schneiderautomation.gde.GdeStrings;
import com.schneiderautomation.gde.GdeTopPanel;
import com.schneiderautomation.gde.PropertyCanvas;
import com.schneiderautomation.gde.PropertySelector;
import com.schneiderautomation.gde.PropertySheet;
import com.schneiderautomation.gde.PropertyText;
import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.namespace.VarLookupInterface;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Panel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class PropertySheetPanel
extends Panel
implements PropertyChangeListener {
    private static final Object[] ZERO_ARGS = new Object[0];
    private Frame parent;
    private PropertySheet ps;
    private VarLookupInterface varLookup;
    private Component target;
    private PropertyDescriptor[] properties;
    private PropertyEditor[] editors;
    private Object[] values;
    private Component[] views;
    private Insets insets = new Insets(4, 4, 4, 4);
    private GridBagLayout layout = new GridBagLayout();
    private GridBagConstraints labelConstraints = new GridBagConstraints();
    private GridBagConstraints viewConstraints = new GridBagConstraints();

    PropertySheetPanel(Frame frame, PropertySheet propertySheet, VarLookupInterface varLookupInterface) {
        this.parent = frame;
        this.ps = propertySheet;
        this.varLookup = varLookupInterface;
        this.labelConstraints.gridx = 0;
        this.labelConstraints.gridwidth = 1;
        this.labelConstraints.gridheight = 1;
        this.labelConstraints.anchor = 17;
        this.labelConstraints.fill = 2;
        this.labelConstraints.insets.bottom = 4;
        this.viewConstraints.gridx = 1;
        this.viewConstraints.gridwidth = 1;
        this.viewConstraints.gridheight = 1;
        this.viewConstraints.anchor = 17;
        this.viewConstraints.fill = 1;
        this.viewConstraints.insets.bottom = 4;
        this.viewConstraints.weightx = 1.0;
        this.setBackground(GdeTopPanel.panelBkgnd);
        this.setLayout(this.layout);
    }

    public final Insets getInsets() {
        return this.insets;
    }

    void closeDialogs() {
        if (this.views != null) {
            for (int i = 0; i < this.views.length; ++i) {
                if (!(this.views[i] instanceof AddressViewPanel)) continue;
                ((AddressViewPanel)this.views[i]).closeVarLookupDlg();
            }
        }
    }

    synchronized void setTarget(Component component) {
        int n;
        Object object;
        this.closeDialogs();
        this.target = component;
        this.removeAll();
        if (component == null) {
            Object[] objectArray = new Object[]{GdeStrings.getString("NO_SELECTION")};
            this.ps.setTitle(GdeStrings.getFormattedString("PROP_TITLE", objectArray));
            return;
        }
        if (component.getParent() instanceof Wrapper) {
            object = new Object[]{((Wrapper)component.getParent()).getName()};
            this.ps.setTitle(GdeStrings.getFormattedString("PROP_TITLE", (Object[])object));
        } else {
            object = new Object[]{GdeStrings.getString("BEANBOX_NAME")};
            this.ps.setTitle(GdeStrings.getFormattedString("PROP_TITLE", (Object[])object));
        }
        object = BeanLoader.getBeanInfo(component.getClass());
        if (object == null) {
            return;
        }
        this.properties = object.getPropertyDescriptors();
        if (this.properties == null || this.properties.length == 0) {
            System.out.println("No properties for " + component.getName());
            return;
        }
        this.editors = new PropertyEditor[this.properties.length];
        this.values = new Object[this.properties.length];
        this.views = new Component[this.properties.length];
        this.viewConstraints.gridy = 0;
        this.labelConstraints.gridy = 0;
        int n2 = 0;
        for (n = 0; n < this.properties.length; ++n) {
            String string;
            block21: {
                Serializable serializable;
                if (this.properties[n].isHidden() || this.properties[n].isExpert()) continue;
                string = this.properties[n].getDisplayName();
                Class<?> clazz = this.properties[n].getPropertyType();
                Method method = this.properties[n].getReadMethod();
                Method method2 = this.properties[n].getWriteMethod();
                if (method == null || method2 == null) continue;
                try {
                    PropertyEditor propertyEditor = null;
                    serializable = this.properties[n].getPropertyEditorClass();
                    if (serializable != null) {
                        try {
                            propertyEditor = (PropertyEditor)((Class)serializable).newInstance();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (propertyEditor == null) {
                        propertyEditor = GdePropertyEditorManager.findEditor(clazz);
                    }
                    if (propertyEditor == null) {
                        System.out.println("Warning: Property \"" + string + "\" has no public property editor.  Skipping.");
                        continue;
                    }
                    Object object2 = method.invoke((Object)component, ZERO_ARGS);
                    if (object2 == null) {
                        System.out.println("Warning: Property \"" + string + "\" has null initial value.  Skipping.");
                        continue;
                    }
                    this.values[n] = object2;
                    this.editors[n] = propertyEditor;
                    propertyEditor.setValue(object2);
                    propertyEditor.addPropertyChangeListener(this);
                    if (propertyEditor instanceof AddressEditor) {
                        this.views[n] = new AddressViewPanel((AddressEditor)propertyEditor, null, this.varLookup);
                        break block21;
                    }
                    if (propertyEditor.isPaintable() && propertyEditor.supportsCustomEditor()) {
                        this.views[n] = new PropertyCanvas(propertyEditor, this.parent, this.ps, string);
                        break block21;
                    }
                    if (propertyEditor.getTags() != null) {
                        this.views[n] = new PropertySelector(propertyEditor);
                        break block21;
                    }
                    if (propertyEditor.getAsText() != null) {
                        this.views[n] = new PropertyText(propertyEditor);
                        break block21;
                    }
                    System.out.println("Warning: Property \"" + string + "\" has non-displayable editor.  Skipping.");
                }
                catch (InvocationTargetException invocationTargetException) {
                    serializable = invocationTargetException.getTargetException();
                    System.err.println("Skipping property " + string + ".  Exception on target: " + serializable);
                }
                catch (Exception exception) {
                    System.err.println("Skipping property " + string + ".  Exception: " + exception);
                }
                continue;
            }
            this.add((Component)new Label(string), this.labelConstraints);
            this.add(this.views[n], this.viewConstraints);
            ++this.labelConstraints.gridy;
            ++this.viewConstraints.gridy;
            ++n2;
        }
        while (n2 < 10) {
            this.add((Component)new Label(), this.labelConstraints);
            this.add((Component)new Canvas(), this.viewConstraints);
            ++this.labelConstraints.gridy;
            ++this.viewConstraints.gridy;
            ++n2;
        }
        this.ps.getScrollPane().doLayout();
        this.doLayout();
        for (n = 0; n < this.properties.length; ++n) {
            if (this.views[n] == null) continue;
            this.views[n].doLayout();
        }
        n = (this.getSize().height - this.insets.top - this.insets.bottom) / n2;
        this.ps.getScrollPane().getVAdjustable().setUnitIncrement(n);
    }

    synchronized void refresh() {
        if (this.properties == null) {
            return;
        }
        for (int i = 0; i < this.properties.length; ++i) {
            Object object;
            if (this.views[i] == null) continue;
            try {
                Method method = this.properties[i].getReadMethod();
                object = method.invoke((Object)this.target, ZERO_ARGS);
                if (object == null || object.equals(this.values[i])) continue;
                this.values[i] = object;
                this.editors[i].setValue(object);
                this.views[i].repaint();
                continue;
            }
            catch (InvocationTargetException invocationTargetException) {
                object = invocationTargetException.getTargetException();
                System.err.println("Unexpected exception while reading " + this.properties[i].getName() + ".  Exception on target: " + object);
                continue;
            }
            catch (Exception exception) {
                System.err.println("Unexpected exception while reading " + this.properties[i].getName() + ".  Exception: " + exception);
            }
        }
    }

    public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object[] objectArray;
        Object object;
        PropertyEditor propertyEditor = (PropertyEditor)propertyChangeEvent.getSource();
        for (int i = 0; i < this.editors.length; ++i) {
            if (this.editors[i] != propertyEditor) continue;
            PropertyDescriptor propertyDescriptor = this.properties[i];
            try {
                object = propertyEditor.getValue();
                if (object.equals(this.values[i])) {
                    return;
                }
                objectArray = new Object[]{object};
                propertyDescriptor.getWriteMethod().invoke((Object)this.target, objectArray);
                this.values[i] = object;
                this.ps.notifyModified();
            }
            catch (InvocationTargetException invocationTargetException) {
                objectArray = invocationTargetException.getTargetException();
                if (objectArray instanceof PropertyVetoException) {
                    System.out.println("Warning: Update vetoed for " + propertyDescriptor.getName());
                    System.out.println("    " + objectArray.getMessage());
                } else {
                    System.err.println("Unexpected exception while updating " + propertyDescriptor.getName() + ".  Exception on target: " + objectArray);
                }
            }
            catch (Exception exception) {
                System.err.println("Unexpected exception while updating " + propertyDescriptor.getName() + ".  Exception: " + exception);
            }
            this.views[i].repaint();
            break;
        }
        if (this.target.getParent() instanceof Wrapper) {
            Wrapper wrapper = (Wrapper)this.target.getParent();
            this.target.invalidate();
            int n = Wrapper.BORDER_WIDTH;
            object = this.target.getMinimumSize();
            if (((Dimension)object).width < n) {
                ((Dimension)object).width = n;
            }
            if (((Dimension)object).height < n) {
                ((Dimension)object).height = n;
            }
            objectArray = this.target.getSize();
            if (objectArray.width < ((Dimension)object).width) {
                objectArray.width = ((Dimension)object).width;
            }
            if (objectArray.height < ((Dimension)object).height) {
                objectArray.height = ((Dimension)object).height;
            }
            wrapper.setSize(objectArray.width + Wrapper.BORDER_WIDTH_X2, objectArray.height + Wrapper.BORDER_WIDTH_X2);
            this.target.repaint();
        }
        this.refresh();
    }
}

