/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.gde.Wrapper;
import com.schneiderautomation.widgets.Border;
import com.schneiderautomation.widgets.HChart;
import com.schneiderautomation.widgets.HLabel;
import com.schneiderautomation.widgets.PenLegend;
import com.schneiderautomation.widgets.TScale;
import com.schneiderautomation.widgets.VScale;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;

public class ChartGui
extends Canvas
implements Serializable {
    static final long serialVersionUID = -6421327682278675060L;
    static final int MAX_PENS = HChart.MAX_PENS;
    private Border border = new Border();
    private HLabel label = new HLabel();
    private VScale pvScale = new VScale(false, 0);
    private TScale tmScale = new TScale(1);
    private HChart chart = new HChart(this, this.tmScale);
    private PenLegend legend = new PenLegend();

    public ChartGui() {
        this.InitWrapper();
        this.setBackground(Color.lightGray);
        this.legend.setBackground(this.chart.getBackground());
        this.pvScale.setMinimum(this.chart.getMinimum());
        this.pvScale.setMaximum(this.chart.getMaximum());
        this.tmScale.setUpdateInterval(this.chart.getUpdateInterval());
        this.tmScale.setForeground(this.pvScale.getForeground());
        this.tmScale.setFont(this.pvScale.getFont());
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.tmScale.setBackground(color);
    }

    private void InitWrapper() {
        Wrapper.BORDER_WIDTH = 4;
        Wrapper.BORDER_WIDTH_X2 = Wrapper.BORDER_WIDTH * 2;
    }

    public void doLayout() {
        int n;
        Dimension dimension = this.getSize();
        this.border.setBounds(new Rectangle(0, 0, dimension.width, dimension.height));
        int n2 = this.border.getMinimumSize().height;
        dimension.width -= n2;
        dimension.height -= n2;
        int n3 = this.pvScale.getMinimumSize().width;
        int n4 = this.tmScale.getMinimumSize().height;
        int n5 = this.label.getMinimumSize().height;
        int n6 = this.legend.getMinimumSize().height;
        int n7 = dimension.width - n3;
        int n8 = dimension.height - n5 - n4 - n6;
        int n9 = n = n2 / 2;
        int n10 = n + n6;
        this.pvScale.setBounds(new Rectangle(n9, n10, n3, n8));
        n9 = n + n3;
        n10 = n;
        this.legend.setBounds(new Rectangle(n9, n10, n7, n6));
        this.chart.setBounds(new Rectangle(n9, n10 += n6, n7, n8));
        this.tmScale.setBounds(new Rectangle(n9, n10 += n8, n7, n4));
        this.label.setBounds(new Rectangle(n, n10 += n4, dimension.width, n5));
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.getMinimumSize();
        dimension.width += 100;
        dimension.height += 20;
        return dimension;
    }

    public Dimension getMinimumSize() {
        Dimension dimension = this.pvScale.getMinimumSize();
        Dimension dimension2 = this.tmScale.getMinimumSize();
        Dimension dimension3 = this.chart.getMinimumSize();
        Dimension dimension4 = this.legend.getMinimumSize();
        Dimension dimension5 = this.label.getMinimumSize();
        Dimension dimension6 = this.border.getMinimumSize();
        int n = dimension.width + Math.max(Math.max(dimension2.width, dimension3.width), dimension4.width);
        if (dimension5.width > n) {
            n = dimension5.width;
        }
        int n2 = dimension5.height + dimension2.height + dimension4.height + Math.max(dimension.height, dimension3.height);
        return new Dimension(n += dimension6.width, n2 += dimension6.height);
    }

    public void paint(Graphics graphics) {
        this.pvScale.paint(graphics);
        this.tmScale.paint(graphics);
        this.chart.paint(graphics);
        this.label.paint(graphics);
        this.border.paint(graphics);
        this.legend.paint(graphics);
        if (Wrapper.BORDER_WIDTH != 4) {
            this.InitWrapper();
        }
    }

    public void start() {
        this.chart.start();
    }

    public void stop() {
        this.chart.stop();
    }

    public void removeNotify() {
        this.chart.stop();
        super.removeNotify();
    }

    public void resetChart() {
        this.chart.reset(true);
    }

    public void setBounds(int n, int n2, int n3, int n4) {
        Dimension dimension = this.getSize();
        Dimension dimension2 = this.getMinimumSize();
        if (n3 < dimension2.width) {
            n3 = dimension2.width;
        }
        if (n4 < dimension2.height) {
            n4 = dimension2.height;
        }
        super.setBounds(n, n2, n3, n4);
        if (dimension.width != n3 || dimension.height != n4) {
            this.doLayout();
        }
    }

    public void setValue(int n, float f) {
        this.chart.setValue(n, f);
    }

    public float getValue(int n) {
        return this.chart.getValue(n);
    }

    public void setMinimum(float f) {
        this.chart.setMinimum(f);
        this.pvScale.setMinimum(this.chart.getMinimum());
        this.doLayout();
        this.repaint();
    }

    public float getMinimum() {
        return this.chart.getMinimum();
    }

    public void setMaximum(float f) {
        this.chart.setMaximum(f);
        this.pvScale.setMaximum(this.chart.getMaximum());
        this.doLayout();
        this.repaint();
    }

    public float getMaximum() {
        return this.chart.getMaximum();
    }

    public void setPrecision(int n) {
        this.pvScale.setPrecision(n);
        this.doLayout();
        this.repaint();
    }

    public int getPrecision() {
        return this.pvScale.getPrecision();
    }

    public void setLabel(String string) {
        this.label.setText(string);
        this.doLayout();
        this.repaint();
    }

    public String getLabel() {
        return this.label.getText();
    }

    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        this.repaint();
    }

    public Color getLabelColor() {
        return this.label.getForeground();
    }

    public void setLabelFont(Font font) {
        this.label.setFont(font);
        this.doLayout();
        this.repaint();
    }

    public Font getLabelFont() {
        return this.label.getFont();
    }

    public void setPenActive(int n, boolean bl) {
        this.legend.setPenActive(n, bl);
        this.doLayout();
        this.repaint();
    }

    public boolean isPenActive(int n) {
        return this.legend.isPenActive(n);
    }

    public void setPenLabel(int n, String string) {
        this.legend.setPenLabel(n, string);
        this.doLayout();
        this.repaint();
    }

    public String getPenLabel(int n) {
        return this.legend.getPenLabel(n);
    }

    public void setPenColor(int n, Color color) {
        this.chart.setPenColor(n, color);
        this.legend.setPenColor(n, this.chart.getPenColor(n));
        this.repaint();
    }

    public Color getPenColor(int n) {
        return this.chart.getPenColor(n);
    }

    public void setChartBackground(Color color) {
        this.chart.setBackground(color);
        this.legend.setBackground(this.chart.getBackground());
        this.repaint();
    }

    public Color getChartBackground() {
        return this.chart.getBackground();
    }

    public void setGridColor(Color color) {
        this.chart.setGridColor(color);
        this.repaint();
    }

    public Color getGridColor() {
        return this.chart.getGridColor();
    }

    public void setUpdateInterval(float f) {
        this.chart.setUpdateInterval((int)(f * 1000.0f));
        this.tmScale.setUpdateInterval(this.chart.getUpdateInterval());
        this.repaint();
    }

    public float getUpdateInterval() {
        return (float)this.chart.getUpdateInterval() / 1000.0f;
    }

    public void setGridDivisions(int n) {
        this.chart.setGridDivisions(n);
        this.repaint();
    }

    public int getGridDivisions() {
        return this.chart.getGridDivisions();
    }

    public void setTimeDivisions(int n) {
        this.tmScale.setMajorTics(n);
        this.doLayout();
        this.repaint();
    }

    public int getTimeDivisions() {
        return this.tmScale.getMajorTics();
    }

    public void setMinorTics(int n) {
        this.pvScale.setMinorTics(n);
        this.doLayout();
        this.repaint();
    }

    public int getMinorTics() {
        return this.pvScale.getMinorTics();
    }

    public void setMajorTics(int n) {
        this.pvScale.setMajorTics(n);
        this.doLayout();
        this.repaint();
    }

    public int getMajorTics() {
        return this.pvScale.getMajorTics();
    }

    public void setScaleFont(Font font) {
        this.pvScale.setFont(font);
        this.tmScale.setFont(this.pvScale.getFont());
        this.doLayout();
        this.repaint();
    }

    public Font getScaleFont() {
        return this.pvScale.getFont();
    }

    public void setScaleColor(Color color) {
        this.pvScale.setForeground(color);
        this.tmScale.setForeground(this.pvScale.getForeground());
        this.repaint();
    }

    public Color getScaleColor() {
        return this.pvScale.getForeground();
    }

    public void setBorderColor(Color color) {
        this.border.setColor(color);
        this.repaint();
    }

    public Color getBorderColor() {
        return this.border.getColor();
    }

    public void setBorderWidth(int n) {
        this.border.setWidth(n);
        this.doLayout();
        this.repaint();
    }

    public int getBorderWidth() {
        return this.border.getWidth();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        try {
            objectInputStream.defaultReadObject();
            if (this.legend == null) {
                this.legend = new PenLegend();
                this.legend.setBackground(this.chart.getBackground());
                this.legend.setPenColor(0, this.chart.getPenColor(0));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ClassNotFoundException reading ChartGui object: " + classNotFoundException.getMessage());
        }
    }
}

