/*
 * Decompiled with CFR 0.152.
 */
package com.schneiderautomation.widgets;

import com.schneiderautomation.widgets.Knob;
import com.schneiderautomation.widgets.SelectorInterface;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.io.Serializable;

class CircularSelector
extends Knob
implements SelectorInterface,
Serializable {
    static final long serialVersionUID = -4500486018949535728L;
    private long[] values = new long[]{0L, 1L, 2L};

    CircularSelector(Component component) {
        super(component);
        this.setEUMinimum(0.0f);
        this.setEUMaximum(this.values.length - 1);
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        super.mouseReleased(mouseEvent);
        this.setValue(this.getValue());
        this.refresh();
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
    }

    public boolean isEnabled() {
        return super.isEnabled();
    }

    public void setValues(long[] lArray) {
        this.values = lArray;
        this.setEUMaximum(lArray.length - 1);
    }

    public long[] getValues() {
        return this.values;
    }

    public void select(long l) {
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i] != l) continue;
            this.setValue(i);
            break;
        }
    }

    public long getSelectedValue() {
        return this.values[this.getValue()];
    }

    void setValue(int n) {
        this.setEUValue(n);
    }

    int getValue() {
        return (int)((double)this.getEUValue() + 0.5);
    }
}

